/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPath {
    private final Set<File> entries = new LinkedHashSet<File>();
    private static final String PATHSEP = File.pathSeparator;

    public SearchPath() {
    }

    public SearchPath(File ... fileArray) {
        this.append(fileArray);
    }

    public SearchPath(SearchPath ... searchPathArray) {
        this.append(searchPathArray);
    }

    public SearchPath(String ... stringArray) {
        this.append(stringArray);
    }

    public SearchPath append(Collection<File> collection) {
        for (File file : collection) {
            if (!file.exists()) continue;
            this.entries.add(file);
        }
        return this;
    }

    public SearchPath append(File ... fileArray) {
        for (File file : fileArray) {
            if (!file.exists()) continue;
            this.entries.add(file);
        }
        return this;
    }

    public SearchPath append(SearchPath ... searchPathArray) {
        for (SearchPath searchPath : searchPathArray) {
            this.entries.addAll(searchPath.entries);
        }
        return this;
    }

    public SearchPath append(String ... stringArray) {
        for (String string : stringArray) {
            for (String string2 : string.split(Pattern.quote(PATHSEP))) {
                File file;
                if (string2.length() <= 0 || !(file = new File(string2)).exists()) continue;
                this.entries.add(file);
            }
        }
        return this;
    }

    public SearchPath removeAll(Collection<File> collection) {
        this.entries.removeAll(collection);
        return this;
    }

    public SearchPath retainAll(Collection<File> collection) {
        this.entries.retainAll(collection);
        return this;
    }

    public List<File> asList() {
        return new ArrayList<File>(this.entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : this.entries) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(PATHSEP);
            }
            stringBuilder.append(file);
        }
        return stringBuilder.toString();
    }
}

