/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDK_Version
implements Comparable<JDK_Version> {
    private static final Map<String, JDK_Version> values = new HashMap<String, JDK_Version>();
    public static JDK_Version V1_1 = JDK_Version.forName("1.1");
    public static JDK_Version V1_5 = JDK_Version.forName("1.5");
    public static JDK_Version V1_6 = JDK_Version.forName("1.6");
    public static JDK_Version V9 = JDK_Version.forName("9");
    public static JDK_Version V10 = JDK_Version.forName("10");
    public final int major;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDK_Version forName(String string) {
        if (string == null) {
            return null;
        }
        Map<String, JDK_Version> map = values;
        synchronized (map) {
            JDK_Version jDK_Version = values.get(string);
            if (jDK_Version == null) {
                try {
                    int n;
                    if (string.startsWith("1.")) {
                        n = Integer.parseInt(string.substring(2));
                        if (n > 10) {
                            return null;
                        }
                    } else {
                        n = Integer.parseInt(string);
                        if (n < 5) {
                            return null;
                        }
                    }
                    jDK_Version = new JDK_Version(n);
                    values.put(string, jDK_Version);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return jDK_Version;
        }
    }

    public static JDK_Version forThisJVM() {
        return JDK_Version.forName(System.getProperty("java.specification.version"));
    }

    private JDK_Version(int n) {
        this.major = n;
    }

    public String name() {
        return (this.major < 9 ? "1." : "") + this.major;
    }

    public boolean equals(Object object) {
        return object instanceof JDK_Version && this.major == ((JDK_Version)object).major;
    }

    public int hashCode() {
        return this.major;
    }

    @Override
    public int compareTo(JDK_Version jDK_Version) {
        return this.major < jDK_Version.major ? -1 : (this.major == jDK_Version.major ? 0 : 1);
    }

    public String toString() {
        return "JDK " + (this.major < 9 ? "1." : "") + this.major;
    }
}

