/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.RegressionCompileCommand;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileActionHelper
extends ActionHelper {
    private static final AStatus passed = AStatus.passed("Compilation successful");
    private static final AStatus failed = AStatus.failed("Compilation failed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AStatus runCompile(String string, Map<String, String> map, List<String> list, int n, ActionHelper.OutputHandler outputHandler) {
        Object object;
        Object object2;
        Object object3;
        ActionHelper.SaveState saveState = new ActionHelper.SaveState();
        Properties properties = System.getProperties();
        for (Map.Entry<String, String> object42 : map.entrySet()) {
            object3 = object42.getKey();
            object2 = object42.getValue();
            if (((String)object3).equals("test.class.path.prefix")) {
                object = new SearchPath(new String[]{object2, System.getProperty("java.class.path")});
                properties.put("java.class.path", ((SearchPath)object).toString());
                continue;
            }
            properties.put(object42.getKey(), object42.getValue());
        }
        System.setProperties(properties);
        PrintStream printStream = outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDOUT, false);
        PrintStream printStream2 = outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDERR, true);
        object3 = outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.DIRECT, false);
        object2 = outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.DIRECT_LOG, false);
        object = AStatus.error("");
        try {
            Object object4;
            AStatus aStatus = CompileActionHelper.redirectOutput(printStream, printStream2);
            if (!aStatus.isPassed()) {
                AStatus alarm = aStatus;
                return alarm;
            }
            Alarm alarm = Alarm.NONE;
            if (n > 0) {
                object4 = outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.LOG, true);
                alarm = Alarm.schedulePeriodicInterrupt(n, TimeUnit.SECONDS, (PrintWriter)object4, Thread.currentThread());
            }
            try {
                object4 = new RegressionCompileCommand(){

                    protected AStatus getStatus(int n) {
                        JDK_Version jDK_Version = JDK_Version.forThisJVM();
                        return CompileActionHelper.getStatusForJavacExitCode(jDK_Version, n);
                    }
                };
                String[] stringArray = list.toArray(new String[list.size()]);
                object = ((RegressionCompileCommand)object4).run(stringArray, (PrintWriter)object2, (PrintWriter)object3);
            }
            finally {
                alarm.cancel();
            }
        }
        finally {
            ((PrintWriter)object3).close();
            ((PrintWriter)object2).close();
            printStream.close();
            printStream2.close();
            object = saveState.restore(string, (AStatus)object);
        }
        return object;
    }

    public static AStatus getStatusForJavacExitCode(JDK_Version jDK_Version, int n) {
        if (jDK_Version == null || jDK_Version.compareTo(JDK_Version.V1_6) < 0) {
            return n == 0 ? passed : failed;
        }
        switch (n) {
            case 0: {
                return passed;
            }
            case 1: {
                return failed;
            }
            case 2: {
                return AStatus.error("command line error (exit code 2)");
            }
            case 3: {
                return AStatus.error("system error (exit code 3)");
            }
            case 4: {
                return AStatus.error("compiler crashed (exit code 4)");
            }
        }
        return AStatus.error("unexpected exit code from javac: " + n);
    }
}

