/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jdis.AnnotationElement;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class AnnotationData {
    protected String visAnnotToken = "@+";
    protected String invAnnotToken = "@-";
    protected String dataName = "AnnotationData";
    private boolean invisible = false;
    private int type_cpx = 0;
    private ArrayList<AnnotationElement> array = new ArrayList();
    private ClassData cls;

    public AnnotationData(boolean invisible, ClassData cls) {
        this.cls = cls;
        this.invisible = invisible;
    }

    public void read(DataInputStream in) throws IOException {
        this.type_cpx = in.readShort();
        int elemValueLength = in.readShort();
        TraceUtils.traceln(3, String.format(" %s: name[%d]=%s", this.dataName, this.type_cpx, this.cls.pool.getString(this.type_cpx)), String.format(" %s: %s  num_elems: %d", this.dataName, this.cls.pool.getString(this.type_cpx), elemValueLength));
        for (int evc = 0; evc < elemValueLength; ++evc) {
            AnnotationElement elem = new AnnotationElement(this.cls);
            TraceUtils.traceln(3, String.format(" %s: %s reading [%d]", this.dataName, this.cls.pool.getString(this.type_cpx), evc));
            elem.read(in, this.invisible);
            this.array.add(elem);
        }
    }

    public void print(PrintWriter out, String tab) {
        this.printHeader(out, tab);
        this.printBody(out, "");
    }

    protected void printHeader(PrintWriter out, String tab) {
        if (this.invisible) {
            out.print(tab + this.invAnnotToken);
        } else {
            out.print(tab + this.visAnnotToken);
        }
        String annoName = this.cls.pool.getString(this.type_cpx);
        if (annoName.startsWith("L") && annoName.endsWith(";")) {
            annoName = annoName.substring(1, annoName.length() - 1);
        }
        out.print(annoName);
    }

    protected void printBody(PrintWriter out, String tab) {
        out.print(" { ");
        int i = 0;
        for (AnnotationElement elem : this.array) {
            elem.print(out, tab);
            if (i++ >= this.array.size() - 1) continue;
            out.print(", ");
        }
        out.print("  }");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String annoName = this.cls.pool.getString(this.type_cpx);
        if (annoName.startsWith("L") && annoName.endsWith(";")) {
            annoName = annoName.substring(1, annoName.length() - 1);
        }
        if (this.invisible) {
            sb.append(this.invAnnotToken);
        } else {
            sb.append(this.visAnnotToken);
        }
        sb.append(annoName);
        sb.append(" { ");
        int i = 0;
        for (AnnotationElement elem : this.array) {
            sb.append(elem.toString());
            if (i++ >= this.array.size() - 1) continue;
            sb.append(", ");
        }
        this._toString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void _toString(StringBuilder sb) {
    }
}

