/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.lang.reflect.Modifier;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.ParserCP;
import org.openjdk.asmtools.jasm.Scanner;
import org.openjdk.asmtools.jasm.StackMapData;
import org.openjdk.asmtools.jasm.SwitchTable;
import org.openjdk.asmtools.jasm.Tables;

public class ParserInstr
extends ParseBase {
    private ParserCP cpParser = null;

    protected ParserInstr(Scanner scanner, Parser parser, ParserCP cpParser, Environment env) {
        super.init(scanner, parser, env);
        this.cpParser = cpParser;
    }

    protected void parseInstr() throws Scanner.SyntaxError, IOException {
        int mnenoc_pos;
        String mnemocode;
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            this.scanner.scan();
        }
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            this.scanner.scan();
        }
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
        }
        while (true) {
            if (this.scanner.token != JasmTokens.Token.IDENT) {
                return;
            }
            mnemocode = this.scanner.idValue;
            mnenoc_pos = this.scanner.pos;
            this.scanner.scan();
            if (this.scanner.token != JasmTokens.Token.COLON) break;
            this.scanner.scan();
            this.parser.curCode.LabelDef(mnenoc_pos, mnemocode);
        }
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(mnemocode);
        if (opcode == null) {
            this.debugScan(" Error:  mnemocode = '" + mnemocode + "'.   ");
        }
        OpcodeTables.OpcodeType optype = opcode.type();
        Argument arg = null;
        Object arg2 = null;
        StackMapData sMap = null;
        this.debugScan(" --IIIII---[ParserInstr:[parseInstr]:  (Pos: " + mnenoc_pos + ") mnemocode: '" + opcode.parsekey() + "' ");
        switch (optype) {
            case NORMAL: {
                switch (opcode) {
                    case opc_bytecode: {
                        while (true) {
                            this.parser.curCode.addInstr(mnenoc_pos, OpcodeTables.Opcode.opc_bytecode, this.parser.parseUInt(1), null);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_try: {
                        while (true) {
                            this.parser.curCode.beginTrap(this.scanner.pos, this.parser.parseIdent());
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_endtry: {
                        while (true) {
                            this.parser.curCode.endTrap(this.scanner.pos, this.parser.parseIdent());
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_catch: {
                        this.parser.curCode.trapHandler(this.scanner.pos, this.parser.parseIdent(), this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS));
                        return;
                    }
                    case opc_var: {
                        while (true) {
                            this.parser.parseLocVarDef();
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_endvar: {
                        while (true) {
                            this.parser.parseLocVarEnd();
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_locals_map: {
                        DataVector localsMap;
                        sMap = this.parser.curCode.getStackMap();
                        if (sMap.localsMap != null) {
                            this.env.error(this.scanner.pos, "localsmap.repeated");
                        }
                        sMap.localsMap = localsMap = new DataVector();
                        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                            return;
                        }
                        while (true) {
                            this.parser.parseMapItem(localsMap);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_stack_map: {
                        DataVector stackMap;
                        sMap = this.parser.curCode.getStackMap();
                        if (sMap.stackMap != null) {
                            this.env.error(this.scanner.pos, "stackmap.repeated");
                        }
                        sMap.stackMap = stackMap = new DataVector();
                        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                            return;
                        }
                        while (true) {
                            this.parser.parseMapItem(stackMap);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_stack_frame_type: {
                        sMap = this.parser.curCode.getStackMap();
                        if (sMap.stackFrameType != null) {
                            this.env.error(this.scanner.pos, "frametype.repeated");
                        }
                        sMap.setStackFrameType(this.parser.parseIdent());
                        return;
                    }
                    case opc_aload: 
                    case opc_astore: 
                    case opc_fload: 
                    case opc_fstore: 
                    case opc_iload: 
                    case opc_istore: 
                    case opc_lload: 
                    case opc_lstore: 
                    case opc_dload: 
                    case opc_dstore: 
                    case opc_ret: 
                    case opc_aload_w: 
                    case opc_astore_w: 
                    case opc_fload_w: 
                    case opc_fstore_w: 
                    case opc_iload_w: 
                    case opc_istore_w: 
                    case opc_lload_w: 
                    case opc_lstore_w: 
                    case opc_dload_w: 
                    case opc_dstore_w: 
                    case opc_ret_w: {
                        arg = this.parser.parseLocVarRef();
                        break;
                    }
                    case opc_iinc: {
                        arg = this.parser.parseLocVarRef();
                        this.scanner.expect(JasmTokens.Token.COMMA);
                        arg2 = this.parser.parseInt(1);
                        break;
                    }
                    case opc_tableswitch: 
                    case opc_lookupswitch: {
                        arg2 = this.parseSwitchTable();
                        break;
                    }
                    case opc_newarray: {
                        int type;
                        if (this.scanner.token == JasmTokens.Token.INTVAL) {
                            type = this.scanner.intValue;
                        } else {
                            type = Tables.basictypeValue(this.scanner.idValue);
                            if (type == -1) {
                                this.env.error(this.scanner.pos, "type.expected");
                                throw new Scanner.SyntaxError();
                            }
                        }
                        this.scanner.scan();
                        arg = new Argument(type);
                        break;
                    }
                    case opc_new: 
                    case opc_anewarray: 
                    case opc_instanceof: 
                    case opc_checkcast: {
                        arg = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
                        break;
                    }
                    case opc_bipush: {
                        arg = this.parser.parseInt(1);
                        break;
                    }
                    case opc_sipush: {
                        arg = this.parser.parseInt(2);
                        break;
                    }
                    case opc_ldc: 
                    case opc_ldc_w: 
                    case opc_ldc2_w: {
                        arg = this.cpParser.parseConstRef(null);
                        break;
                    }
                    case opc_putstatic: 
                    case opc_getstatic: 
                    case opc_putfield: 
                    case opc_getfield: {
                        arg = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_FIELD);
                        break;
                    }
                    case opc_invokevirtual: {
                        arg = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_METHOD);
                        break;
                    }
                    case opc_invokestatic: 
                    case opc_invokespecial: {
                        Tables.ConstType ctype01 = Tables.ConstType.CONSTANT_METHOD;
                        Tables.ConstType ctype02 = Tables.ConstType.CONSTANT_INTERFACEMETHOD;
                        if (Modifier.isInterface(this.parser.cd.access)) {
                            ctype01 = Tables.ConstType.CONSTANT_INTERFACEMETHOD;
                            ctype02 = Tables.ConstType.CONSTANT_METHOD;
                        }
                        arg = this.cpParser.parseConstRef(ctype01, ctype02);
                        break;
                    }
                    case opc_jsr: 
                    case opc_goto: 
                    case opc_ifeq: 
                    case opc_ifge: 
                    case opc_ifgt: 
                    case opc_ifle: 
                    case opc_iflt: 
                    case opc_ifne: 
                    case opc_if_icmpeq: 
                    case opc_if_icmpne: 
                    case opc_if_icmpge: 
                    case opc_if_icmpgt: 
                    case opc_if_icmple: 
                    case opc_if_icmplt: 
                    case opc_if_acmpeq: 
                    case opc_if_acmpne: 
                    case opc_ifnull: 
                    case opc_ifnonnull: 
                    case opc_jsr_w: 
                    case opc_goto_w: {
                        arg = this.parseLabelRef();
                        break;
                    }
                    case opc_invokeinterface: {
                        arg = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_INTERFACEMETHOD);
                        this.scanner.expect(JasmTokens.Token.COMMA);
                        arg2 = this.parser.parseUInt(1);
                        break;
                    }
                    case opc_invokedynamic: {
                        arg = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_INVOKEDYNAMIC);
                        break;
                    }
                    case opc_multianewarray: {
                        arg = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
                        this.scanner.expect(JasmTokens.Token.COMMA);
                        arg2 = this.parser.parseUInt(1);
                        break;
                    }
                    case opc_wide: 
                    case opc_nonpriv: 
                    case opc_priv: {
                        int opc2 = opcode.value() << 8 | this.parser.parseUInt((int)1).arg;
                        opcode = OpcodeTables.opcode(opc2);
                    }
                }
                break;
            }
            case WIDE: {
                arg = this.parser.parseLocVarRef();
                if (opcode != OpcodeTables.Opcode.opc_iinc_w) break;
                this.scanner.expect(JasmTokens.Token.COMMA);
                arg2 = this.parser.parseInt(2);
                break;
            }
            case NONPRIVELEGED: 
            case PRIVELEGED: {
                break;
            }
            default: {
                this.env.error(this.scanner.prevPos, "wrong.mnemocode", (Object)mnemocode);
                throw new Scanner.SyntaxError();
            }
        }
        this.parser.curCode.addInstr(mnenoc_pos, opcode, arg, arg2);
    }

    protected SwitchTable parseSwitchTable() throws Scanner.SyntaxError, IOException {
        SwitchTable table;
        block6: {
            this.scanner.expect(JasmTokens.Token.LBRACE);
            int numpairs = 0;
            table = new SwitchTable(this.env);
            block4: while (numpairs < 1000) {
                switch (this.scanner.token) {
                    case INTVAL: {
                        int key = this.scanner.intValue * this.scanner.sign;
                        this.scanner.scan();
                        this.scanner.expect(JasmTokens.Token.COLON);
                        table.addEntry(key, this.parseLabelRef());
                        ++numpairs;
                        if (this.scanner.token != JasmTokens.Token.SEMICOLON) break;
                        this.scanner.scan();
                        continue block4;
                    }
                    case DEFAULT: {
                        this.scanner.scan();
                        this.scanner.expect(JasmTokens.Token.COLON);
                        if (table.deflabel != null) {
                            this.env.error("default.redecl");
                        }
                        table.deflabel = this.parseLabelRef();
                        if (this.scanner.token != JasmTokens.Token.SEMICOLON) break;
                        this.scanner.scan();
                        continue block4;
                    }
                }
                break block6;
            }
            this.env.error("long.switchtable", (Object)"1000");
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        return table;
    }

    protected Argument parseLabelRef() throws Scanner.SyntaxError, IOException {
        switch (this.scanner.token) {
            case INTVAL: {
                int v = this.scanner.intValue * this.scanner.sign;
                this.scanner.scan();
                return new Argument(v);
            }
            case IDENT: {
                String label = this.scanner.stringValue;
                this.scanner.scan();
                return this.parser.curCode.LabelRef(label);
            }
        }
        this.env.error("label.expected");
        throw new Scanner.SyntaxError();
    }
}

