/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.ArrayList;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jasm.TypeAnnotationData;

public abstract class MemberData {
    protected int access;
    protected AttrData syntheticAttr;
    protected AttrData deprecatedAttr;
    protected DataVectorAttr<AnnotationData> annotAttrVis = null;
    protected DataVectorAttr<AnnotationData> annotAttrInv = null;
    protected DataVectorAttr<TypeAnnotationData> type_annotAttrVis = null;
    protected DataVectorAttr<TypeAnnotationData> type_annotAttrInv = null;
    protected ClassData cls;
    protected AttrData signatureAttr;

    public MemberData(ClassData cls, int access) {
        this.cls = cls;
        this.init(access);
    }

    public MemberData(ClassData cls) {
        this.cls = cls;
    }

    public void init(int access) {
        this.access = access;
    }

    public void createPseudoMod() {
        if (Modifiers.isSyntheticPseudoMod(this.access)) {
            this.syntheticAttr = new AttrData(this.cls, Tables.AttrTag.ATT_Synthetic.parsekey());
            this.access &= 0xFFFEFFFF;
        }
        if (Modifiers.isDeprecatedPseudoMod(this.access)) {
            this.deprecatedAttr = new AttrData(this.cls, Tables.AttrTag.ATT_Deprecated.parsekey());
            this.access &= 0xFFFDFFFF;
        }
    }

    public void setSignatureAttr(ConstantPool.ConstCell value_cpx) {
        this.signatureAttr = new CPXAttr(this.cls, Tables.AttrTag.ATT_Signature.parsekey(), value_cpx);
    }

    protected abstract DataVector getAttrVector();

    protected final DataVector getDataVector(Data ... extraAttrs) {
        DataVector<Data> attrs = new DataVector<Data>();
        for (Data extra : extraAttrs) {
            if (extra == null) continue;
            attrs.add(extra);
        }
        if (this.annotAttrVis != null) {
            attrs.add(this.annotAttrVis);
        }
        if (this.annotAttrInv != null) {
            attrs.add(this.annotAttrInv);
        }
        if (this.type_annotAttrVis != null) {
            attrs.add(this.type_annotAttrVis);
        }
        if (this.type_annotAttrInv != null) {
            attrs.add(this.type_annotAttrInv);
        }
        return attrs;
    }

    public void addAnnotations(ArrayList<AnnotationData> list) {
        for (AnnotationData item : list) {
            boolean invisible = item.invisible;
            if (item instanceof TypeAnnotationData) {
                TypeAnnotationData ta = (TypeAnnotationData)item;
                if (invisible) {
                    if (this.type_annotAttrInv == null) {
                        this.type_annotAttrInv = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeInvisibleTypeAnnotations.parsekey());
                    }
                    this.type_annotAttrInv.add(ta);
                    continue;
                }
                if (this.type_annotAttrVis == null) {
                    this.type_annotAttrVis = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeVisibleTypeAnnotations.parsekey());
                }
                this.type_annotAttrVis.add(ta);
                continue;
            }
            if (invisible) {
                if (this.annotAttrInv == null) {
                    this.annotAttrInv = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeInvisibleAnnotations.parsekey());
                }
                this.annotAttrInv.add(item);
                continue;
            }
            if (this.annotAttrVis == null) {
                this.annotAttrVis = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeVisibleAnnotations.parsekey());
            }
            this.annotAttrVis.add(item);
        }
    }
}

