/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.openjdk.asmtools.jasm.Main;
import org.openjdk.asmtools.util.I18NResourceBundle;

public class Environment {
    static boolean traceFlag = false;
    boolean debugInfoFlag = false;
    private String inputFileName;
    private String simpleInputFileName;
    public PrintWriter out;
    private boolean nowarn;
    private byte[] data;
    private int bytepos;
    private int linepos;
    public int pos;
    public int nerrors;
    public int nwarnings;
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    ErrorMessage errors;

    public Environment(DataInputStream dis, String inputFileName, PrintWriter out, boolean nowarn) throws IOException {
        this.out = out;
        this.inputFileName = inputFileName;
        this.nowarn = nowarn;
        this.data = new byte[dis.available()];
        dis.read(this.data);
        dis.close();
        this.bytepos = 0;
        this.linepos = 1;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public String getSimpleInputFileName() {
        if (this.simpleInputFileName == null) {
            int separatorChar = this.inputFileName.matches("^[A-Za-z]+:.*") ? 47 : (int)File.separatorChar;
            int index = this.inputFileName.lastIndexOf(separatorChar);
            this.simpleInputFileName = index < 0 ? this.inputFileName.substring(0) : this.inputFileName.substring(index + 1);
        }
        return this.simpleInputFileName;
    }

    int lookForward() {
        try {
            return this.data[this.bytepos];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    int convertUnicode() {
        try {
            byte c;
            while ((c = this.data[this.bytepos]) == 117) {
                ++this.bytepos;
            }
            int d = 0;
            for (int i = 0; i < 4; ++i) {
                switch (c) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        d = (d << 4) + c - 48;
                        break;
                    }
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        d = (d << 4) + 10 + c - 97;
                        break;
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        d = (d << 4) + 10 + c - 65;
                        break;
                    }
                    default: {
                        this.error(this.pos, "invalid.escape.char");
                        return d;
                    }
                }
                ++this.bytepos;
                c = this.data[this.bytepos];
            }
            return d;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.error(this.pos, "invalid.escape.char");
            return -1;
        }
    }

    public int read() {
        byte c;
        this.pos = this.linepos << 19 | this.bytepos;
        try {
            c = this.data[this.bytepos];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
        ++this.bytepos;
        switch (c) {
            case 10: {
                ++this.linepos;
                return 10;
            }
            case 13: {
                if (this.lookForward() == 10) {
                    ++this.bytepos;
                }
                ++this.linepos;
                return 10;
            }
        }
        return c;
    }

    int lineNumber(int lcpos) {
        return lcpos >>> 19;
    }

    int lineNumber() {
        return this.lineNumber(this.pos);
    }

    int lineOffset(int lcpos) {
        return lcpos & 0x7FFFF;
    }

    int lineOffset() {
        return this.lineOffset(this.pos);
    }

    String errorString(String err, Object arg1, Object arg2, Object arg3) {
        String str = null;
        str = i18n.getString(err);
        if (str == null) {
            return "error message '" + err + "' not found";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '%' && i + 1 < str.length()) {
                switch (str.charAt(++i)) {
                    case 's': {
                        String arg = arg1.toString();
                        block8: for (int j = 0; j < arg.length(); ++j) {
                            c = arg.charAt(j);
                            switch (c) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    buf.append(c);
                                    continue block8;
                                }
                                default: {
                                    if (c > ' ' && c <= '\u00ff') {
                                        buf.append(c);
                                        continue block8;
                                    }
                                    buf.append('\\');
                                    buf.append('u');
                                    buf.append(Integer.toString(c, 16));
                                }
                            }
                        }
                        arg1 = arg2;
                        arg2 = arg3;
                        break;
                    }
                    case '%': {
                        buf.append('%');
                        break;
                    }
                    default: {
                        buf.append('?');
                        break;
                    }
                }
                continue;
            }
            buf.append(c);
        }
        String msg = buf.toString();
        MessageFormat form = new MessageFormat(msg);
        Object[] args = new Object[]{arg1, arg2, arg3};
        msg = form.format(args);
        return msg;
    }

    void insertError(int where, String message) {
        ErrorMessage msg = new ErrorMessage(where, message);
        if (this.errors == null) {
            this.errors = msg;
        } else if (this.errors.where > where) {
            msg.next = this.errors;
            this.errors = msg;
        } else {
            ErrorMessage m = this.errors;
            while (m.next != null && m.next.where <= where) {
                m = m.next;
            }
            msg.next = m.next;
            m.next = msg;
        }
    }

    public void flushErrors() {
        if (this.errors == null) {
            this.traceln("flushErrors: errors == null");
            return;
        }
        ErrorMessage msg = this.errors;
        while (msg != null) {
            int j;
            int off;
            int i;
            for (i = off = this.lineOffset(msg.where); i > 0 && this.data[i - 1] != 10 && this.data[i - 1] != 13; --i) {
            }
            for (j = off; j < this.data.length && this.data[j] != 10 && this.data[j] != 13; ++j) {
            }
            this.outputln(String.format("%s (%d:%d) %s", this.getSimpleInputFileName(), this.lineNumber(msg.where), off - i, msg.message));
            this.outputln(new String(this.data, i, j - i));
            char[] strdata = new char[off - i + 1];
            for (j = i; j < off; ++j) {
                strdata[j - i] = this.data[j] == 9 ? 9 : 32;
            }
            strdata[off - i] = 94;
            this.outputln(new String(strdata));
            msg = msg.next;
        }
        this.errors = null;
    }

    public void output(String msg) {
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            this.out.write(msg.charAt(i));
        }
        this.out.flush();
    }

    public void outputln(String msg) {
        this.output((msg == null ? "" : msg) + "\n");
    }

    public void error(int where, String err, Object arg1, Object arg2, Object arg3) {
        String msg;
        if (err.startsWith("warn.")) {
            if (this.nowarn) {
                return;
            }
            ++this.nwarnings;
            msg = "Warning: ";
        } else {
            err = "err." + err;
            ++this.nerrors;
            msg = "Error: ";
        }
        msg = msg + this.errorString(err, arg1, arg2, arg3);
        this.traceln(msg);
        this.insertError(where, msg);
    }

    public final void error(int where, String err, Object arg1, Object arg2) {
        this.error(where, err, arg1, arg2, null);
    }

    public final void error(int where, String err, Object arg1) {
        this.error(where, err, arg1, null, null);
    }

    public final void error(int where, String err) {
        this.error(where, err, null, null, null);
    }

    public final void error(String err, Object arg1, Object arg2, Object arg3) {
        this.error(this.pos, err, arg1, arg2, arg3);
    }

    public final void error(String err, Object arg1, Object arg2) {
        this.error(this.pos, err, arg1, arg2, null);
    }

    public final void error(String err, Object arg1) {
        this.error(this.pos, err, arg1, null, null);
    }

    public final void error(String err) {
        this.error(this.pos, err, null, null, null);
    }

    public final String errorStr(String err, Object arg1, Object arg2, Object arg3) {
        return this.errorString(err, arg1, arg2, arg3);
    }

    public final String errorStr(String err, Object arg1, Object arg2) {
        return this.errorStr(err, arg1, arg2, null);
    }

    public final String errorStr(String err, Object arg1) {
        return this.errorStr(err, arg1, null, null);
    }

    public final String errorStr(String err) {
        return this.errorStr(err, null, null, null);
    }

    public boolean isTraceEnabled() {
        return traceFlag;
    }

    public boolean isDebugEnabled() {
        return this.debugInfoFlag;
    }

    void trace(String message) {
        if (traceFlag) {
            this.output(message);
        }
    }

    void traceln(String message) {
        if (traceFlag) {
            this.outputln(message);
        }
    }

    final class ErrorMessage {
        int where;
        String message;
        ErrorMessage next;

        ErrorMessage(int where, String message) {
            this.where = where;
            this.message = message;
        }
    }
}

