/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.List;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstantPool;

public class ClassArrayAttr
extends AttrData {
    List<ConstantPool.ConstCell> classes;

    public ClassArrayAttr(String attributeName, ClassData cdata, List<ConstantPool.ConstCell> classes) {
        super(cdata, attributeName);
        this.classes = classes;
    }

    @Override
    public int attrLength() {
        return 2 + this.classes.size() * 2;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        out.writeShort(this.classes.size());
        for (ConstantPool.ConstCell c : this.classes) {
            out.writeShort(c.arg);
        }
    }
}

