/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class WriterStream
extends OutputStream {
    private static int MAX_BUFF_SIZE = 50;
    private static int PERIOD_SIZE = 3;
    private String charsetName;
    private byte[] buff = new byte[MAX_BUFF_SIZE];
    private int index = 0;
    private Writer writer;

    public WriterStream(Writer w) {
        this.writer = w;
        OutputStreamWriter osw = new OutputStreamWriter(this);
        this.charsetName = osw.getEncoding();
    }

    public WriterStream(Writer w, String charsetName) {
        this.writer = w;
        this.charsetName = charsetName;
    }

    @Override
    public void flush() throws IOException {
        char[] chars;
        String result = new String(this.buff, 0, this.index, this.charsetName);
        for (char aChar : chars = result.toCharArray()) {
            this.writer.write(aChar);
        }
        this.index = 0;
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.index >= MAX_BUFF_SIZE) {
            this.flush();
        }
        this.buff[this.index++] = (byte)b;
        if (this.index % PERIOD_SIZE == 0) {
            String res = new String(this.buff, 0, this.index, this.charsetName);
            char[] chars = res.toCharArray();
            int ch_numb = chars.length;
            if (chars.length > 1) {
                int k = 0;
                while (chars.length == ch_numb) {
                    if ((chars = (res = new String(this.buff, 0, this.index - ++k, this.charsetName)).toCharArray()).length >= ch_numb) continue;
                    System.arraycopy(this.buff, this.index - k, this.buff, 0, k);
                    this.index = k;
                    for (char aChar : chars) {
                        this.writer.write(aChar);
                    }
                }
            }
        }
    }
}

