/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.VerboseCommand;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CommandContext {
    public static final int SYSTEM_LAF = 0;
    public static final int NIMBUS_LAF = 1;
    public static final int METAL_LAF = 2;
    public static final int DEFAULT_LAF = 1;
    static final String VERBOSE_COMMANDS = "commands";
    static final String TRACE_PREFIX = "+ ";
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(CommandContext.class);
    private Vector<Command> commands = new Vector();
    private File testSuitePath;
    private File workDirectoryPath;
    private String defaultWorkDirPath;
    private Map<String, String> desktopData;
    private boolean autoCreateWorkDirectory;
    private File configFilePath;
    private InterviewParameters config;
    private Command autoRunCommand;
    private File autoRunReportDir;
    private boolean closeDesktopWhenDoneEnabled;
    private Desktop desktop;
    private PrintWriter out;
    private int[] cumulativeTestStats = new int[4];
    private Map<String, Boolean> verboseOptionValues = new HashMap<String, Boolean>();
    private boolean verboseMax;
    private boolean verboseQuiet;
    private boolean verboseDate = true;
    private int preferredLAF = 1;
    private Harness.Observer[] harnessObservers = new Harness.Observer[0];

    public CommandContext() {
        this(new PrintWriter(System.err));
    }

    public CommandContext(PrintWriter out) {
        this.out = out;
    }

    public void addCommand(Command cmd) {
        this.commands.add(cmd);
    }

    public Command[] getCommands() {
        return this.commands.toArray(new Command[this.commands.size()]);
    }

    public void runCommands() throws Fault {
        boolean foundAction = false;
        for (Command cmd : this.commands) {
            foundAction |= cmd.isActionCommand();
            boolean verbose = this.getVerboseOptionValue(VERBOSE_COMMANDS, false);
            if (verbose) {
                this.out.println(TRACE_PREFIX + cmd.toString());
            }
            try {
                cmd.run(this);
            }
            catch (Command.Fault e) {
                throw new Fault(e);
            }
        }
        if (!foundAction && this.autoRunCommand != null) {
            try {
                this.autoRunCommand.run(this);
            }
            catch (Command.Fault e) {
                throw new Fault(i18n, "cc.errorInDefault", (Object)e.getMessage());
            }
        }
    }

    public void addHarnessObserver(Harness.Observer o) {
        this.harnessObservers = DynamicArray.append(this.harnessObservers, o);
    }

    public Harness.Observer[] getHarnessObservers() {
        return this.harnessObservers;
    }

    public Command getAutoRunCommand() {
        return this.autoRunCommand;
    }

    public void setAutoRunCommand(Command c) {
        this.autoRunCommand = c;
    }

    public File getAutoRunReportDir() {
        return this.autoRunReportDir;
    }

    public void setAutoRunReportDir(File dir) {
        this.autoRunReportDir = dir;
    }

    public void addTestStats(int ... stats) {
        if (stats.length != 4) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stats.length; ++i) {
            int n = i;
            this.cumulativeTestStats[n] = this.cumulativeTestStats[n] + stats[i];
        }
    }

    public int[] getTestStats() {
        int[] s = new int[4];
        System.arraycopy(this.cumulativeTestStats, 0, s, 0, s.length);
        return s;
    }

    public boolean isCloseDesktopWhenDoneEnabled() {
        return this.closeDesktopWhenDoneEnabled;
    }

    public void setCloseDesktopWhenDoneEnabled(boolean b) {
        this.closeDesktopWhenDoneEnabled = b;
    }

    public boolean isTestSuiteSet() {
        return this.hasConfig();
    }

    public TestSuite getTestSuite() throws Fault {
        this.initConfig();
        return this.config.getTestSuite();
    }

    public void setTestSuite(File path) throws Fault {
        if (this.testSuitePath != null && !this.testSuitePath.equals(path)) {
            throw new Fault(i18n, "cc.tsAlreadySet", (Object)this.testSuitePath);
        }
        this.testSuitePath = path;
    }

    public void setTestSuite(TestSuite ts) throws Fault, TestSuite.Fault {
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config == null) {
            this.config = ts.createInterview();
        } else if (this.config.getTestSuite() != ts) {
            throw new Fault(i18n, "cc.tsAlreadySet", (Object)this.testSuitePath);
        }
    }

    public boolean isWorkDirectorySet() {
        return this.hasConfig() && this.config.getWorkDirectory() != null;
    }

    public WorkDirectory getWorkDirectory() throws Fault {
        this.initConfig();
        return this.config.getWorkDirectory();
    }

    public void setWorkDirectory(File path) throws Fault {
        this.setWorkDirectory(path, false);
    }

    public void setWorkDirectory(WorkDirectory wd) throws Fault, TestSuite.Fault {
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config == null) {
            this.config = wd.getTestSuite().createInterview();
        } else {
            if (wd.getTestSuite() != this.config.getTestSuite()) {
                throw new Fault(i18n, "cc.wdTestSuiteMismatch", wd.getRoot(), this.config.getTestSuite().getRoot());
            }
            WorkDirectory cwd = this.config.getWorkDirectory();
            if (cwd != null && cwd != wd) {
                throw new Fault(i18n, "cc.wdAlreadySet", (Object)this.workDirectoryPath);
            }
        }
        this.config.setWorkDirectory(wd);
    }

    public void setWorkDirectory(File path, boolean create) throws Fault {
        if (this.workDirectoryPath != null && !this.workDirectoryPath.equals(path)) {
            throw new Fault(i18n, "cc.wdAlreadySet", (Object)this.workDirectoryPath);
        }
        this.autoCreateWorkDirectory = create;
        this.workDirectoryPath = path;
    }

    @Deprecated
    public InterviewParameters getInterviewParameters() throws Fault {
        return this.getConfig();
    }

    @Deprecated
    public void setInterviewParameters(InterviewParameters p) throws Fault {
        WorkDirectory cwd;
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config != null) {
            if (this.config.getTestSuite() != p.getTestSuite()) {
                throw new Fault(i18n, "cc.confTestSuiteMismatch", new Object[]{this.config.getTestSuite().getRoot()});
            }
            cwd = this.config.getWorkDirectory();
            WorkDirectory pwd = p.getWorkDirectory();
            if (cwd != null && pwd != null && pwd != cwd) {
                throw new Fault(i18n, "cc.confWorkDirMismatch", new Object[]{cwd.getRoot()});
            }
        } else {
            cwd = null;
        }
        if (this.config != null) {
            this.config.dispose();
        }
        this.config = p;
        if (this.config.getWorkDirectory() == null && cwd != null) {
            this.config.setWorkDirectory(cwd);
        }
    }

    public InterviewParameters getConfig() throws Fault {
        this.initConfig();
        return this.config;
    }

    public void setConfig(File path) throws Fault {
        if (this.config != null) {
            if (this.configFilePath == null) {
                throw new Fault(i18n, "cc.confAlreadySetDefault", (Object)path);
            }
            throw new Fault(i18n, "cc.confAlreadySet", path, this.configFilePath);
        }
        this.configFilePath = path;
    }

    public boolean hasConfig() {
        return this.config != null || this.testSuitePath != null || this.workDirectoryPath != null || this.configFilePath != null;
    }

    void setDefaultWorkDir(String path) {
        this.defaultWorkDirPath = path;
    }

    Map<String, String> getDesktopData() {
        return this.desktopData;
    }

    void setDesktopData(Map<String, String> desktopData) {
        this.desktopData = desktopData;
    }

    private boolean isInitConfigRequired() {
        return this.config == null && (this.testSuitePath != null || this.workDirectoryPath != null || this.configFilePath != null);
    }

    private void initConfig() throws Fault {
        block53: {
            if (this.config != null) {
                return;
            }
            if (this.testSuitePath != null && this.workDirectoryPath == null && this.defaultWorkDirPath != null) {
                this.workDirectoryPath = new File(this.defaultWorkDirPath);
            }
            if (this.workDirectoryPath != null && (this.autoCreateWorkDirectory || WorkDirectory.isEmptyDirectory(this.workDirectoryPath))) {
                WorkDirectory wd;
                TestSuite ts;
                File tsPath;
                Map<String, String> configData;
                if (this.testSuitePath == null) {
                    if (this.configFilePath == null) {
                        throw new Fault(i18n, "cc.noTestSuite");
                    }
                    try {
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.configFilePath));){
                            configData = PropertyUtils.load(in);
                        }
                        catch (RuntimeException e) {
                            throw new Fault(i18n, "cc.cantReadConfig", this.configFilePath, e);
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new Fault(i18n, "cc.cantFindConfig", (Object)this.configFilePath);
                    }
                    catch (IOException e) {
                        throw new Fault(i18n, "cc.cantReadConfig", this.configFilePath, e);
                    }
                    String tsp = configData.get("TESTSUITE");
                    if (tsp == null) {
                        throw new Fault(i18n, "cc.noTestSuiteInConfigFile", (Object)this.configFilePath);
                    }
                    tsPath = new File(tsp);
                } else {
                    configData = null;
                    tsPath = this.testSuitePath;
                }
                try {
                    ts = TestSuite.open(tsPath);
                }
                catch (FileNotFoundException e) {
                    throw new Fault(i18n, "cc.cantFindTS", tsPath, this.testSuitePath != null ? 0 : 1, this.configFilePath);
                }
                catch (TestSuite.Fault e) {
                    throw new Fault(i18n, "cc.cantOpenTS", tsPath, this.testSuitePath != null ? 0 : 1, this.configFilePath, e.getMessage());
                }
                try {
                    wd = WorkDirectory.create(this.workDirectoryPath, ts);
                }
                catch (WorkDirectory.Fault e) {
                    throw new Fault(i18n, "cc.cantCreateWD", (Object)this.workDirectoryPath);
                }
                if (this.configFilePath == null || configData != null) {
                    try {
                        this.config = ts.createInterview();
                    }
                    catch (TestSuite.Fault e) {
                        throw new Fault(i18n, "cc.cantCreateConfig", this.testSuitePath, e.getMessage());
                    }
                    try {
                        if (configData != null) {
                            this.config.load(configData, this.configFilePath);
                        }
                    }
                    catch (Interview.Fault e) {
                        throw new Fault(i18n, "cc.cantOpenConfig", this.configFilePath, e.getMessage());
                    }
                    this.config.setWorkDirectory(wd);
                } else {
                    try {
                        this.config = InterviewParameters.open(this.configFilePath, wd);
                    }
                    catch (IOException e) {
                        throw new Fault(i18n, "cc.cantReadConfig", this.configFilePath, e);
                    }
                    catch (Interview.Fault e) {
                        throw new Fault(i18n, "cc.cantOpenConfig", this.configFilePath, e.getMessage());
                    }
                }
                if (this.config.getTemplatePath() != null) {
                    try {
                        TemplateUtilities.setTemplateFile(this.config.getWorkDirectory(), new File(this.config.getTemplatePath()), true);
                    }
                    catch (IOException errorWritingTemplateInfo) {
                        throw new Fault(i18n, "cnfg.writeTemplate.cantWriteTemplateRef", (Object)this.workDirectoryPath);
                    }
                }
            } else {
                try {
                    this.config = InterviewParameters.open(this.testSuitePath, this.workDirectoryPath, this.configFilePath);
                    if (this.config.getWorkDirectory() == null) break block53;
                    File templateFile = TemplateUtilities.getTemplateFile(this.config.getWorkDirectory());
                    if (this.config.getTemplatePath() != null || templateFile == null) break block53;
                    try {
                        InterviewParameters tConfig = this.config.getTestSuite().loadInterviewFromTemplate(templateFile, this.config);
                        if (tConfig != null) {
                            tConfig.setWorkDirectory(this.config.getWorkDirectory());
                            if (this.config != tConfig) {
                                this.config.dispose();
                                this.config = tConfig;
                            }
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (Interview.Fault e) {
                    throw new Fault(i18n, "cc.cantInitConfig", (Object)e.getMessage());
                }
            }
        }
        if (this.testSuitePath == null) {
            this.testSuitePath = this.config.getTestSuite().getRoot();
        }
        if (this.workDirectoryPath == null && this.config.getWorkDirectory() != null) {
            this.workDirectoryPath = this.config.getWorkDirectory().getRoot();
        }
        if (this.configFilePath == null) {
            this.configFilePath = this.config.getFile();
        }
    }

    public boolean isDesktopRequired() {
        int mode = 0;
        for (Command cmd : this.commands) {
            mode = Math.max(mode, cmd.getDesktopMode());
        }
        return mode != 1;
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public void setDesktop(Desktop d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.desktop = d;
    }

    public void setVerboseMax(boolean on) {
        this.verboseMax = on;
    }

    public boolean isVerboseQuiet() {
        return this.verboseQuiet;
    }

    public void setVerboseQuiet(boolean on) {
        this.verboseQuiet = on;
    }

    public void setVerboseOptionValue(String name, boolean on) {
        this.verboseOptionValues.put(name.toLowerCase(), on);
    }

    public boolean getVerboseOptionValue(String name) {
        return this.getVerboseOptionValue(name, false);
    }

    public boolean getVerboseOptionValue(String name, boolean defaultValue) {
        if (this.verboseMax) {
            return true;
        }
        if (this.verboseQuiet) {
            return false;
        }
        Boolean b = this.verboseOptionValues.get(name.toLowerCase());
        return b == null ? defaultValue : b;
    }

    public boolean isVerboseOptionSet(String name) {
        return this.verboseOptionValues.get(name.toLowerCase()) != null;
    }

    public boolean isVerboseTimestampEnabled() {
        return this.verboseDate;
    }

    public void setVerboseTimestampEnabled(boolean on) {
        this.verboseDate = on;
    }

    public int getPreferredLookAndFeel() {
        return this.preferredLAF;
    }

    public void setPreferredLookAndFeel(int lookAndFeel) {
        this.preferredLAF = lookAndFeel;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    public void printMessage(I18NResourceBundle i18n, String key) {
        this.out.println(i18n.getString(key));
    }

    public void printMessage(I18NResourceBundle i18n, String key, Object arg) {
        this.out.println(i18n.getString(key, arg));
    }

    public void printMessage(I18NResourceBundle i18n, String key, Object ... args) {
        this.out.println(i18n.getString(key, args));
    }

    public void printErrorMessage(I18NResourceBundle i18n, String key) {
        this.out.println(i18n.getString(key));
    }

    public void printErrorMessage(I18NResourceBundle i18n, String key, Object arg) {
        this.out.println(i18n.getString(key, arg));
    }

    public void printErrorMessage(I18NResourceBundle i18n, String key, Object ... args) {
        this.out.println(i18n.getString(key, args));
    }

    public void dispose() {
        if (this.commands != null) {
            this.commands.clear();
        }
        if (this.desktopData != null) {
            this.desktopData.clear();
        }
        if (this.config != null) {
            this.config.dispose();
            this.config = null;
        }
    }

    static {
        VerboseCommand.addOption(VERBOSE_COMMANDS, new HelpTree.Node(i18n, "cc.verbose"));
    }

    public class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object ... o) {
            super(i18n.getString(s, o));
        }

        Fault(Command.Fault e) {
            super(e.getMessage(), e);
        }

        public CommandContext getContext() {
            return CommandContext.this;
        }
    }
}

