/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.tools.ServiceProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SPIDescr {
    private String name;
    private String description;
    private boolean isMultiple;
    private String usage;
    private Map<String, ServiceProvider> presets;
    private boolean handled = false;
    private Class<? extends ServiceProvider> spiClass;
    private ServiceProvider defaultSPI;

    public SPIDescr(String name, Class<? extends ServiceProvider> spiClass) {
        this.name = name;
        this.spiClass = spiClass;
    }

    public SPIDescr(String name, Class<? extends ServiceProvider> spiClass, String description) {
        this.name = name;
        this.description = description;
        this.spiClass = spiClass;
    }

    public SPIDescr(String name, Class<? extends ServiceProvider> spiClass, String description, boolean isMultiple, String usage) {
        this.name = name;
        this.description = description;
        this.isMultiple = isMultiple;
        this.usage = usage;
        this.spiClass = spiClass;
    }

    public void addPreset(String preset, ServiceProvider defaultSPI) {
        if (this.handled) {
            throw new IllegalStateException("Can't modify SPI after handling the SPI");
        }
        if (defaultSPI == null) {
            throw new IllegalArgumentException("Alias for a Service Provider can't be null. Use setDefault instead. ");
        }
        if (!this.spiClass.isInstance(defaultSPI)) {
            throw new IllegalArgumentException("Illegal default Service Provider class. Found " + defaultSPI.getClass() + ", required " + this.spiClass);
        }
        if (this.presets == null) {
            this.presets = new HashMap<String, ServiceProvider>();
        }
        this.presets.put(preset, defaultSPI);
    }

    void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean isName(String name) {
        if (name != null) {
            return name.equals(this.name);
        }
        return this.name == null;
    }

    public Class<? extends ServiceProvider> getSPIClass() {
        return this.spiClass;
    }

    public String getName() {
        return this.name;
    }

    public Collection<ServiceProvider> getPresets() {
        if (this.presets == null) {
            return null;
        }
        return this.presets.values();
    }

    public ServiceProvider getPreset(String className) {
        if (this.presets == null) {
            return null;
        }
        return this.presets.get(className);
    }

    public Map<String, ServiceProvider> getPresetsMap() {
        return this.presets;
    }

    public void setDefaultSPI(ServiceProvider defaultSPI) {
        this.defaultSPI = defaultSPI;
    }

    public ServiceProvider getDefaultSPI() {
        return this.defaultSPI;
    }
}

