/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.tools.ServiceProvider;

public class OptionDescr {
    public static final int VAL_NONE = 0;
    public static final int VAL_SINGLE = 1;
    public static final int VAL_MULTI = 2;
    public static final int VAL_ALL = 3;
    public static final String[][] ON_OFF = new String[][]{{"on", "on"}, {"off", "off"}};
    public static final String ON = "on";
    public static final String OFF = "off";
    public String name;
    public String title;
    public boolean hasValue = false;
    public String[][] allowedValues;
    public boolean isMultiple = false;
    public String usage;
    public int flags;
    public String defVal;
    public String[] aliases;
    public ServiceProvider registeringSPI;
    public int val_kind;
    private static final String TAB = "    ";
    private static final String NL = "\n";

    public OptionDescr() {
    }

    public OptionDescr(String name, String title, String usage) {
        this(name, title, 0, (String[][])null, usage, null);
    }

    public OptionDescr(String name, String title, String usage, String defValue) {
        this(name, title, 0, (String[][])null, usage, defValue);
    }

    public OptionDescr(String name, String[] aliases, String title, String usage) {
        this(name, aliases, title, 0, null, usage, null);
    }

    public OptionDescr(String name, String title, String[][] allowed_values, String usage, String def_val) {
        this(name, title, 1, allowed_values, usage, def_val);
    }

    public OptionDescr(String name, String[] aliases, String title, String[][] allowed_values, String usage, String def_val) {
        this(name, aliases, title, 1, allowed_values, usage, def_val);
    }

    public OptionDescr(String name, String title, int val_kind, String usage) {
        this(name, title, val_kind, (String[][])null, usage, null);
    }

    public OptionDescr(String name, String title, int val_kind, String usage, String defValue) {
        this(name, title, val_kind, (String[][])null, usage, defValue);
    }

    public OptionDescr(String name, String[] aliases, String title, int val_kind, String usage) {
        this(name, aliases, title, val_kind, null, usage, null);
    }

    public OptionDescr(String name, String[] aliases, String title, int val_kind, String usage, String defValue) {
        this(name, aliases, title, val_kind, null, usage, defValue);
    }

    public OptionDescr(String name, String title, int val_kind, String[][] allowed_values, String usage, String def_val) {
        this(name, null, title, val_kind, allowed_values, usage, def_val);
    }

    public OptionDescr(String name, String[] aliases, String title, int val_kind, String[][] allowed_values, String usage, String def_val) {
        this.name = name;
        this.aliases = aliases;
        this.title = title;
        this.usage = usage;
        this.allowedValues = allowed_values;
        this.defVal = def_val;
        this.val_kind = val_kind;
        if (val_kind != 0) {
            this.hasValue = true;
        }
        if (val_kind == 2 || val_kind == 3) {
            this.isMultiple = true;
        }
    }

    public OptionDescr(OptionDescr src) {
        this.name = src.name;
        this.title = src.title;
        this.hasValue = src.hasValue;
        this.allowedValues = src.allowedValues;
        this.isMultiple = src.isMultiple;
        this.usage = src.usage;
        this.flags = src.flags;
        this.defVal = src.defVal;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OptionDescr)) {
            return false;
        }
        OptionDescr od = (OptionDescr)o;
        return this.name.equals(od.name) && (this.title == null || od.title == null || this.title.equals(od.title));
    }

    public int hashCode() {
        int titleHash = this.title == null ? 0 : this.title.hashCode();
        return super.hashCode() + titleHash;
    }

    public boolean isName(String name) {
        if (name.equalsIgnoreCase(this.name)) {
            return true;
        }
        if (this.aliases == null) {
            return false;
        }
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!name.equalsIgnoreCase(this.aliases[i])) continue;
            return true;
        }
        return false;
    }

    public String getUsage(String prefix, String delimeter, String startTab, boolean verbose) {
        int i;
        String usageString = "";
        if (this.title != null && this.title != "") {
            usageString = startTab + this.title + NL;
        }
        usageString = usageString + startTab + TAB + prefix + this.name;
        if (this.aliases != null && this.aliases.length > 0) {
            usageString = usageString + "(";
            for (i = 0; i < this.aliases.length - 1; ++i) {
                usageString = usageString + this.aliases[i] + ", ";
            }
            usageString = usageString + this.aliases[this.aliases.length - 1];
            usageString = usageString + ")";
        }
        if (this.hasValue) {
            usageString = usageString + delimeter;
            if (this.allowedValues != null && this.allowedValues.length > 0) {
                usageString = usageString + "[";
                for (i = 0; i < this.allowedValues.length - 1; ++i) {
                    usageString = usageString + this.allowedValues[i][0] + "|";
                }
                usageString = usageString + this.allowedValues[this.allowedValues.length - 1][0];
                usageString = usageString + "] (By default is: " + this.defVal + ")";
                if (verbose) {
                    for (i = 0; i < this.allowedValues.length; ++i) {
                        usageString = usageString + NL + startTab + TAB + TAB + this.allowedValues[i][0] + " : " + this.allowedValues[i][1];
                    }
                }
            } else {
                usageString = usageString + "'string value'";
                if (this.defVal != null) {
                    usageString = usageString + " (By default is: " + this.defVal + ")";
                }
                if (this.isMultiple) {
                    usageString = usageString + " (Option could be specified several times.)";
                }
            }
        }
        if (verbose) {
            if (this.usage != null && !"".equals(this.usage)) {
                usageString = usageString + NL + startTab + TAB + this.usage.replace(NL, NL + startTab + TAB);
            }
            if (this.registeringSPI != null) {
                usageString = usageString + NL + startTab + TAB + TAB + "registered by " + this.registeringSPI.getClass();
            }
            usageString = usageString + NL;
        }
        return usageString;
    }

    public boolean isAllowedValue(String value) {
        if (this.allowedValues == null) {
            return true;
        }
        for (String[] s : this.allowedValues) {
            if (!s[0].equals(value)) continue;
            return true;
        }
        return false;
    }

    public ServiceProvider getRegisteringSPI() {
        return this.registeringSPI;
    }

    public void setRegisteringSPI(ServiceProvider spi) {
        this.registeringSPI = spi;
    }
}

