/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;

public class SubpackageCoverage
extends AbstractCoverage {
    private int class_cov = 0;
    private int class_anc = 0;
    private int class_tot = 0;
    private int meth_cov = 0;
    private int meth_anc = 0;
    private int meth_tot = 0;
    private int field_cov = 0;
    private int field_anc = 0;
    private int field_tot = 0;
    private int block_cov = 0;
    private int block_anc = 0;
    private int block_tot = 0;
    private int branch_cov = 0;
    private int branch_anc = 0;
    private int branch_tot = 0;
    private int line_cov = 0;
    private int line_anc = 0;
    private int line_tot = 0;
    private DataType[] supportedColumns = new DataType[]{DataType.CLASS, DataType.METHOD, DataType.FIELD, DataType.BLOCK, DataType.BRANCH, DataType.LINE};

    public void add(AbstractCoverage cov) {
        CoverageData d = cov.getData(DataType.CLASS);
        this.class_cov += d.getCovered();
        this.class_anc += d.getAnc();
        this.class_tot += d.getTotal();
        d = cov.getData(DataType.METHOD);
        this.meth_cov += d.getCovered();
        this.meth_anc += d.getAnc();
        this.meth_tot += d.getTotal();
        d = cov.getData(DataType.FIELD);
        this.field_cov += d.getCovered();
        this.field_anc += d.getAnc();
        this.field_tot += d.getTotal();
        d = cov.getData(DataType.BLOCK);
        this.block_cov += d.getCovered();
        this.block_anc += d.getAnc();
        this.block_tot += d.getTotal();
        d = cov.getData(DataType.BRANCH);
        this.branch_cov += d.getCovered();
        this.branch_anc += d.getAnc();
        this.branch_tot += d.getTotal();
        d = cov.getData(DataType.LINE);
        this.line_cov += d.getCovered();
        this.line_anc += d.getAnc();
        this.line_tot += d.getTotal();
    }

    @Override
    public DataType getDataType() {
        return DataType.PRODUCT;
    }

    @Override
    public CoverageData getData(DataType column) {
        return this.getData(column, -1);
    }

    @Override
    public CoverageData getData(DataType column, int testNumber) {
        switch (column) {
            case CLASS: {
                return new CoverageData(this.class_cov, this.class_anc, this.class_tot);
            }
            case METHOD: {
                return new CoverageData(this.meth_cov, this.meth_anc, this.meth_tot);
            }
            case FIELD: {
                return new CoverageData(this.field_cov, this.field_anc, this.field_tot);
            }
            case BLOCK: {
                return new CoverageData(this.block_cov, this.block_anc, this.block_tot);
            }
            case BRANCH: {
                return new CoverageData(this.branch_cov, this.branch_anc, this.branch_tot);
            }
            case LINE: {
                return new CoverageData(this.line_cov, this.line_anc, this.line_tot);
            }
        }
        return new CoverageData();
    }

    @Override
    protected DataType[] getDataTypes() {
        return this.supportedColumns;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public boolean isCovered() {
        return this.getData(DataType.CLASS).getCovered() > 0;
    }

    @Override
    public boolean isCoveredByTest(int testnum) {
        throw new UnsupportedOperationException("Not supported here yet.");
    }
}

