/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.OffsetLabel;
import com.sun.tdk.jcov.util.Utils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class OffsetRecordingMethodAdapter
extends MethodVisitor {
    private int currentOffset;
    private int currentInstructionIndex = 0;
    protected int[] bcis = new int[60];
    protected final DataMethodWithBlocks method;

    public OffsetRecordingMethodAdapter(MethodVisitor mv, DataMethodWithBlocks method) {
        super(393216, mv);
        this.method = method;
    }

    DataMethodWithBlocks method() {
        return this.method;
    }

    private void recordInstructionOffset() {
        if (this.currentInstructionIndex >= this.bcis.length) {
            this.bcis = Utils.copyOf(this.bcis, this.bcis.length * 2);
        }
        this.bcis[this.currentInstructionIndex++] = this.currentOffset;
    }

    @Override
    public void visitLabel(Label label) {
        OffsetLabel ol = (OffsetLabel)label;
        this.currentOffset = ol.originalOffset;
        if (ol.realLabel) {
            super.visitLabel(label);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        this.recordInstructionOffset();
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.recordInstructionOffset();
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.recordInstructionOffset();
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        this.recordInstructionOffset();
        super.visitTypeInsn(opcode, desc);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.recordInstructionOffset();
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.recordInstructionOffset();
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.recordInstructionOffset();
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.recordInstructionOffset();
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.recordInstructionOffset();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.recordInstructionOffset();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.recordInstructionOffset();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String anno, boolean b) {
        this.method().addAnnotation(anno);
        return super.visitAnnotation(anno, b);
    }

    @Override
    public void visitEnd() {
        this.recordInstructionOffset();
        this.method().setBytecodeLength(this.currentOffset);
        super.visitEnd();
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.recordInstructionOffset();
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.recordInstructionOffset();
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }
}

