/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataAbstract;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.util.NaturalComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataPackage
extends DataAbstract
implements Comparable<DataPackage> {
    private final String name;
    private String moduleName;
    private final List<DataClass> classes;

    public DataPackage(int rootId, String name, String modulename) {
        super(rootId);
        this.name = name;
        this.moduleName = modulename;
        this.classes = new LinkedList<DataClass>();
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getName() {
        return this.name;
    }

    public void addClass(DataClass k) {
        this.classes.add(k);
    }

    public List<DataClass> getClasses() {
        return this.classes;
    }

    public DataClass findClass(String className) {
        for (DataClass cl : this.classes) {
            if (!cl.getName().equals(className)) continue;
            return cl;
        }
        return null;
    }

    public boolean removeClass(DataClass k) {
        return this.classes.remove(k);
    }

    public boolean removeClass(String k) {
        if (k == null) {
            return false;
        }
        Iterator<DataClass> it = this.classes.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(k)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public String kind() {
        return "package";
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        ctx.attr("name", this.name.replace('/', '.'));
        ctx.attr("moduleName", this.moduleName);
    }

    @Override
    void xmlBody(XmlContext ctx) {
        Collections.sort(this.classes);
        for (DataClass k : this.classes) {
            k.xmlGen(ctx);
        }
    }

    @Override
    public int compareTo(DataPackage pack) {
        return NaturalComparator.INSTANCE.compare(this.name, pack.getName());
    }

    public boolean applyFilter(MemberFilter filter) {
        Iterator<DataClass> it = this.classes.iterator();
        while (it.hasNext()) {
            DataClass clazz = it.next();
            if (!filter.accept(clazz)) {
                it.remove();
                continue;
            }
            clazz.applyFilter(filter);
        }
        return this.classes.isEmpty();
    }

    public void sort() {
        Collections.sort(this.classes);
        for (DataClass c : this.classes) {
            c.sort();
        }
    }

    void writeObject(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.moduleName);
        out.writeShort(this.classes.size());
        for (DataClass dc : this.classes) {
            dc.writeObject(out);
        }
    }

    DataPackage(int rootID, DataInput in) throws IOException {
        super(rootID);
        this.name = in.readUTF();
        this.moduleName = in.readUTF();
        int classNum = in.readUnsignedShort();
        this.classes = new ArrayList<DataClass>(classNum);
        for (int i = 0; i < classNum; ++i) {
            this.classes.add(new DataClass(rootID, in));
        }
    }
}

