/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.data.ScaleOptions;
import com.sun.tdk.jcov.instrument.DataAnnotated;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InvokeMethodAdapter;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.CollectDetect;
import com.sun.tdk.jcov.tools.OneElemIterator;
import com.sun.tdk.jcov.util.NaturalComparator;
import com.sun.tdk.jcov.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class DataField
extends DataAnnotated
implements Comparable<DataField>,
Iterable<DataBlock> {
    private final DataClass parent;
    private final int access;
    private final String name;
    private final String vmSig;
    private String signature;
    private final Object value;
    private final DataBlock block;

    public DataField(DataClass k, int access, String name, String desc, String signature, Object value) {
        this(k, access, name, desc, signature, value, -1);
    }

    public DataField(final DataClass k, int access, final String name, final String desc, String signature, Object value, int id) {
        super(k.rootId);
        this.parent = k;
        this.access = access;
        this.name = name;
        this.vmSig = desc;
        this.signature = signature;
        this.value = value;
        boolean newSlot = id == -1;
        int slot = newSlot ? Collect.newSlot() : id;
        this.block = new DataBlock(this.rootId, slot, newSlot, 0L){

            @Override
            public String kind() {
                return "fld";
            }

            @Override
            protected boolean wasCollectHit() {
                return CollectDetect.wasInvokeHit(InvokeMethodAdapter.getInvokeID(k.getFullname(), name, desc));
            }

            @Override
            protected long collectCount() {
                return CollectDetect.invokeCountFor(InvokeMethodAdapter.getInvokeID(k.getFullname(), name, desc));
            }

            @Override
            protected void setCollectCount(long count) {
                CollectDetect.setInvokeCountFor(InvokeMethodAdapter.getInvokeID(k.getFullname(), name, desc), count);
            }
        };
        k.addField(this);
    }

    public DataField clone(DataClass newClass, int newAccess, String newName) {
        return new DataField(newClass, newAccess, newName, this.vmSig, this.signature, this.value);
    }

    boolean wasHit() {
        return this.block.wasHit();
    }

    public int getId() {
        return this.block.getId();
    }

    public long getCount() {
        return this.block.getCount();
    }

    public void setCount(long count) {
        this.block.setCount(count);
    }

    public Scale getScale() {
        return this.block.scale;
    }

    public void setScale(Scale scale) {
        this.block.scale = scale;
    }

    public DataClass getParent() {
        return this.parent;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getVmSig() {
        return this.vmSig;
    }

    public Object getValue() {
        return this.value;
    }

    public DataBlock getBlock() {
        return this.block;
    }

    @Deprecated
    public boolean isPublic() {
        return (this.access & 5) != 0;
    }

    public boolean isPublicAPI() {
        return (this.access & 5) != 0;
    }

    public boolean hasPrivateModifier() {
        return (this.access & 2) != 0;
    }

    public boolean hasPublicModifier() {
        return (this.access & 1) != 0;
    }

    public boolean hasProtectedModifier() {
        return (this.access & 4) != 0;
    }

    public boolean hasStaticModifier() {
        return (this.access & 8) != 0;
    }

    public boolean hasModifier(int modifierCode) {
        return (this.access & modifierCode) != 0;
    }

    public String[] getAccessFlags() {
        return this.accessFlags(this.access);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public String kind() {
        return this.block.kind();
    }

    @Override
    void xmlGen(XmlContext ctx) {
        super.xmlGenBodiless(ctx);
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        ctx.attrNormalized("name", this.name);
        ctx.attr("vmsig", this.vmSig);
        this.xmlAccessFlags(ctx, this.access);
        ctx.attr("access", this.access);
        ctx.attr("id", this.block.getId());
        if (this.value != null) {
            ctx.attr("val", this.value);
        }
        if (this.signature != null) {
            ctx.attrNormalized("signature", this.signature);
        }
        if (this.block.getCount() > 0L) {
            ctx.attr("count", this.block.getCount());
        }
        DataRoot r = DataRoot.getInstance(this.rootId);
        if (this.block.scale != null) {
            ScaleOptions opts = r.getScaleOpts();
            StringBuffer sb = new StringBuffer(Utils.halfBytesRequiredFor(this.block.scale.size()));
            sb.setLength(sb.capacity());
            sb.setLength(this.block.scale.convertToChars(opts.scalesCompressed(), sb, opts.getScaleCompressor()));
            ctx.attr("scale", sb);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataField)) {
            return false;
        }
        DataField fld = (DataField)o;
        return this.parent.equals(fld.parent) && this.name.equals(fld.name) && this.vmSig.equals(fld.vmSig);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        hash = 17 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 17 * hash + (this.vmSig != null ? this.vmSig.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(DataField field) {
        return NaturalComparator.INSTANCE.compare(this.name, field.getName());
    }

    public void checkCompatibility(DataField other, String trace) throws MergeException {
        if (!this.getDataRoot().getParams().isDynamicCollect() && !other.getDataRoot().getParams().isDynamicCollect() && this.block.getId() != other.block.getId()) {
            throw new MergeException("Field has other id than it's merging copy, expected " + this.block.getId() + "; found " + other.block.getId(), trace, 0);
        }
    }

    public void merge(DataField other) {
        this.block.mergeScale(other.block);
        this.block.setCount(this.getCount() + other.getCount());
    }

    @Override
    public Iterator<DataBlock> iterator() {
        return new OneElemIterator<DataBlock>(this.block);
    }

    @Override
    String[] accessFlags(int access) {
        String[] as = super.accessFlags(access);
        ArrayList<String> lst = new ArrayList<String>();
        for (String s : as) {
            if (s.equals("bridge") || s.equals("varargs")) continue;
            lst.add(s);
        }
        return lst.toArray(new String[lst.size()]);
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeUTF(this.name);
        DataField.writeString(out, this.signature);
        DataField.writeString(out, this.vmSig);
        out.writeInt(this.access & Short.MAX_VALUE);
        if (this.value != null) {
            out.writeBoolean(true);
            out.writeUTF(this.value.getClass().getName());
        } else {
            out.writeBoolean(false);
        }
        this.block.writeObject(out);
    }

    DataField(final DataClass c, DataInput in) throws IOException {
        super(c.rootId, in);
        this.parent = c;
        this.name = in.readUTF();
        this.signature = DataField.readString(in);
        this.vmSig = DataField.readString(in);
        this.access = in.readInt();
        this.value = in.readBoolean() ? in.readUTF() : null;
        this.block = new DataBlock(c.rootId){

            @Override
            public String kind() {
                return "fld";
            }

            @Override
            protected boolean wasCollectHit() {
                return CollectDetect.wasInvokeHit(InvokeMethodAdapter.getInvokeID(c.getFullname(), DataField.this.name, DataField.this.vmSig));
            }

            @Override
            protected long collectCount() {
                return CollectDetect.invokeCountFor(InvokeMethodAdapter.getInvokeID(c.getFullname(), DataField.this.name, DataField.this.vmSig));
            }

            @Override
            protected void setCollectCount(long count) {
                CollectDetect.setInvokeCountFor(InvokeMethodAdapter.getInvokeID(c.getFullname(), DataField.this.name, DataField.this.vmSig), count);
            }
        };
    }
}

