/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataAnnotated;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.DataMethodInvoked;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.util.NaturalComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataClass
extends DataAnnotated
implements Comparable<DataClass> {
    private final String fullname;
    private String moduleName;
    private final String name;
    private long checksum;
    private final List<DataMethod> methods;
    private final List<DataField> fields;
    private int access;
    private String signature;
    private String superName;
    private String source;
    private String superInterfaces;
    private final boolean differentiateClass;
    private static final Logger logger = Logger.getLogger(DataClass.class.getName());
    private boolean inner = false;
    private boolean anonym = false;

    public DataClass(int rootId, String fullname, String moduleName, long checksum, boolean differentiateClass) {
        super(rootId);
        this.fullname = fullname;
        this.checksum = checksum;
        int slash = fullname.lastIndexOf(47);
        this.name = slash < 0 ? fullname : fullname.substring(slash + 1);
        this.methods = new LinkedList<DataMethod>();
        this.fields = new LinkedList<DataField>();
        this.differentiateClass = differentiateClass;
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setInfo(String flags, String signature, String superName, String interfaces) {
        String[] accessFlags = flags.split(" ");
        int acc = this.access(accessFlags);
        String[] sInterfaces = null;
        if (interfaces != null) {
            sInterfaces = interfaces.split(";");
        }
        this.setInfo(acc, signature, superName, sInterfaces);
    }

    public void setInfo(int access, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.signature = signature;
        this.superName = superName;
        if (interfaces != null && interfaces.length > 0) {
            this.superInterfaces = interfaces[0];
            for (int i = 1; i < interfaces.length; ++i) {
                this.superInterfaces = this.superInterfaces + ";" + interfaces[i];
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataClass)) {
            return false;
        }
        DataClass clazz = (DataClass)o;
        boolean eq = this.fullname.equals(clazz.fullname);
        if (this.checksum != -1L && clazz.checksum != -1L) {
            eq = eq && this.checksum == clazz.checksum;
        }
        return eq;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.fullname != null ? this.fullname.hashCode() : 0);
        return hash;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public String getSuperName() {
        return this.superName;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public int getAccess() {
        return this.access;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setSuperInterfaces(String superInterfaces) {
        this.superInterfaces = superInterfaces;
    }

    public String getSuperInterfaces() {
        return this.superInterfaces;
    }

    public String getName() {
        return this.name;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getPackageName() {
        int slash = this.fullname.lastIndexOf(47);
        if (slash < 0) {
            return "";
        }
        return this.fullname.substring(0, slash);
    }

    public String[] getAccessFlags() {
        return this.accessFlags(this.access);
    }

    @Deprecated
    public boolean isPublic() {
        return (this.access & 5) != 0;
    }

    public boolean isPublicAPI() {
        return (this.access & 5) != 0;
    }

    public boolean hasPrivateModifier() {
        return (this.access & 2) != 0;
    }

    public boolean hasPublicModifier() {
        return (this.access & 1) != 0;
    }

    public boolean hasProtectedModifier() {
        return (this.access & 4) != 0;
    }

    public boolean hasAbstractModifier() {
        return (this.access & 0x400) != 0;
    }

    public boolean hasStaticModifier() {
        return (this.access & 8) != 0;
    }

    public boolean hasModifier(int modifierCode) {
        return (this.access & modifierCode) != 0;
    }

    public void addMethod(DataMethod method) {
        this.methods.add(method);
    }

    public DataMethod findMethod(String methname) {
        if (methname == null) {
            return null;
        }
        for (DataMethod dm : this.methods) {
            if (!dm.getName().equals(methname)) continue;
            return dm;
        }
        return null;
    }

    public DataMethod removeMethod(String methname) {
        if (methname == null) {
            return null;
        }
        Iterator<DataMethod> it = this.methods.iterator();
        while (it.hasNext()) {
            DataMethod dm = it.next();
            if (!dm.getName().equals(methname)) continue;
            it.remove();
            return dm;
        }
        return null;
    }

    public void addField(DataField field) {
        this.fields.add(field);
    }

    public DataField findField(String fieldname) {
        if (fieldname == null) {
            return null;
        }
        for (DataField df : this.fields) {
            if (!df.getName().equals(fieldname)) continue;
            return df;
        }
        return null;
    }

    public DataField removeField(String fieldname) {
        if (fieldname == null) {
            return null;
        }
        Iterator<DataField> it = this.fields.iterator();
        while (it.hasNext()) {
            DataField dm = it.next();
            if (!dm.getName().equals(fieldname)) continue;
            it.remove();
            return dm;
        }
        return null;
    }

    public List<DataMethod> getMethods() {
        return this.methods;
    }

    public List<DataField> getFields() {
        return this.fields;
    }

    public boolean wasHit() {
        for (DataMethod method : this.methods) {
            if (!method.wasHit()) continue;
            return true;
        }
        for (DataField field : this.fields) {
            if (!field.wasHit()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String kind() {
        if (this.differentiateClass) {
            return (this.access & 0x200) == 0 ? "class" : "interface";
        }
        return "class";
    }

    @Override
    void xmlGen(XmlContext ctx) {
        if (!ctx.skipNotCoveredClasses || this.wasHit() && this.methods.size() > 0) {
            if (ctx.showAbstract) {
                super.xmlGen(ctx);
            } else if ((this.access & 0x200) == 0) {
                super.xmlGen(ctx);
            } else {
                ArrayList<DataMethod> onlyDefaultMethods = new ArrayList<DataMethod>();
                for (DataMethod method : this.methods) {
                    if ((method.getAccess() & 0x400) != 0) continue;
                    onlyDefaultMethods.add(method);
                }
                this.methods.retainAll(onlyDefaultMethods);
                if (this.methods.size() > 0) {
                    super.xmlGen(ctx);
                }
            }
        }
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        ctx.attr("name", this.name);
        ctx.attr("supername", this.superName == null ? "" : this.superName);
        if (this.checksum != -1L) {
            ctx.attr("checksum", this.checksum);
        }
        if (!this.differentiateClass && (this.access & 0x200) != 0) {
            ctx.attr("interface", true);
        }
        if (this.signature != null) {
            ctx.attrNormalized("signature", this.signature);
        }
        if (this.source != null) {
            ctx.attrNormalized("source", this.source);
        }
        if (this.inner) {
            if (this.anonym) {
                ctx.attr("inner", "anon");
            } else {
                ctx.attr("inner", "inner");
            }
        }
        this.xmlAccessFlags(ctx, this.access);
        super.xmlAttrs(ctx);
    }

    @Override
    void xmlBody(XmlContext ctx) {
        for (DataMethod method : this.methods) {
            method.xmlGen(ctx);
        }
        for (DataField field : this.fields) {
            field.xmlGen(ctx);
        }
    }

    @Override
    String[] accessFlags(int access) {
        String[] as = super.accessFlags(access);
        LinkedList<String> lst = new LinkedList<String>();
        for (String s : as) {
            if ("synchronized".equals(s)) continue;
            lst.add(s);
        }
        return lst.toArray(new String[lst.size()]);
    }

    public DataClass clone(int rootId) {
        DataClass res = new DataClass(rootId, this.fullname, this.moduleName, -1L, this.differentiateClass);
        res.access = this.access;
        res.signature = this.signature;
        res.superName = this.superName;
        res.superInterfaces = this.superInterfaces;
        res.source = this.source;
        res.methods.addAll(this.methods);
        res.fields.addAll(this.fields);
        return res;
    }

    @Override
    public int compareTo(DataClass clz) {
        return NaturalComparator.INSTANCE.compare(this.name, clz.getName());
    }

    public int checkCompatibility(DataClass other, String traceString, int severity, boolean boe) throws MergeException {
        int errors = 0;
        try {
            this.checkEquals(other, traceString + ": " + other.fullname);
        }
        catch (MergeException me) {
            if (DataClass.isCritical(me, severity)) {
                throw me;
            }
            logger.log(Level.INFO, me.getMessage());
        }
        block6: for (DataMethod meth : this.methods) {
            for (DataMethod ometh : other.methods) {
                if (!meth.equals(ometh)) continue;
                try {
                    meth.checkCompatibility(ometh, traceString + ": " + other.fullname + "." + ometh.getName() + ometh.getVmSignature());
                }
                catch (MergeException e) {
                    if (DataClass.isCritical(e, severity)) {
                        ++errors;
                        logger.log(Level.SEVERE, "Error while merging method " + ometh.getName() + ometh.getVmSignature(), e);
                        if (!boe) continue block6;
                        return errors;
                    }
                    logger.log(Level.WARNING, "Error while merging method " + ometh.getName() + ometh.getVmSignature() + " - skipped as not critical", e);
                }
                continue block6;
            }
        }
        block8: for (DataField fld : this.fields) {
            for (DataField ofld : other.fields) {
                if (!fld.equals(ofld)) continue;
                try {
                    fld.checkCompatibility(ofld, traceString + ": " + other.fullname + "." + ofld.getName());
                }
                catch (MergeException e) {
                    if (DataClass.isCritical(e, severity)) {
                        ++errors;
                        logger.log(Level.SEVERE, "Error while merging field " + ofld.getName(), e);
                        if (!boe) continue block8;
                        return errors;
                    }
                    logger.log(Level.WARNING, "Error while merging field " + ofld.getName() + " - skipped as not critical", e);
                }
                continue block8;
            }
        }
        return errors;
    }

    public void mergeSorted(DataClass other) {
        int comp;
        ListIterator<DataAnnotated> thisIt = this.methods.listIterator();
        ListIterator<DataAnnotated> otherIt = other.methods.listIterator();
        Comparable thisC = null;
        Comparable otherC = null;
        if (thisIt.hasNext()) {
            while (otherIt.hasNext()) {
                otherC = otherIt.next();
                thisC = (Comparable)((Object)thisIt.next());
                comp = thisC.compareTo(otherC);
                while (thisIt.hasNext() && comp < 0) {
                    thisC = (Comparable)((Object)thisIt.next());
                    comp = thisC.compareTo(otherC);
                }
                if (comp == 0) {
                    ((DataMethod)thisC).merge((DataMethod)otherC);
                    continue;
                }
                if (comp > 0) continue;
            }
        }
        thisIt = this.fields.listIterator();
        otherIt = other.fields.listIterator();
        thisC = null;
        otherC = null;
        if (thisIt.hasNext()) {
            while (otherIt.hasNext()) {
                otherC = (Comparable)((Object)otherIt.next());
                thisC = (Comparable)((Object)thisIt.next());
                comp = thisC.compareTo(otherC);
                while (thisIt.hasNext() && comp < 0) {
                    thisC = (Comparable)((Object)thisIt.next());
                    comp = thisC.compareTo(otherC);
                }
                if (comp == 0) {
                    ((DataField)thisC).merge((DataField)otherC);
                    continue;
                }
                if (comp > 0) continue;
            }
        }
        if (this.checksum == -1L) {
            this.checksum = other.checksum;
        }
    }

    public void merge(DataClass other) {
        block0: for (DataMethod meth : this.methods) {
            for (DataMethod ometh : other.methods) {
                if (!meth.equals(ometh)) continue;
                meth.merge(ometh);
                continue block0;
            }
        }
        block2: for (DataField fld : this.fields) {
            for (DataField ofld : other.fields) {
                if (!fld.equals(ofld)) continue;
                fld.merge(ofld);
                continue block2;
            }
        }
        if (this.checksum == -1L) {
            this.checksum = other.checksum;
        }
    }

    public void mergeOnSignatures(DataClass otherClass) {
        ListIterator<DataMethod> other_it = otherClass.methods.listIterator();
        block0: while (other_it.hasNext()) {
            DataMethod otherMethod = other_it.next();
            ListIterator<DataMethod> it = this.methods.listIterator();
            while (it.hasNext()) {
                DataMethod thisMethod = it.next();
                if (!otherMethod.getFullName().equals(thisMethod.getFullName())) continue;
                if (otherMethod instanceof DataMethodEntryOnly) {
                    thisMethod.merge(otherMethod);
                    continue block0;
                }
                ((DataBlock)thisMethod.iterator().next()).mergeScale((DataBlock)otherMethod.iterator().next());
                thisMethod.setCount(thisMethod.getCount() + otherMethod.getCount());
                continue block0;
            }
            System.out.println("Warning, class " + otherClass.getFullname() + " has method " + otherMethod.name + " that was not found in template");
        }
        block2: for (DataField otherFields : otherClass.fields) {
            ListIterator<DataField> it = this.fields.listIterator();
            while (it.hasNext()) {
                DataField thisField = it.next();
                if (!otherFields.equals(thisField)) continue;
                thisField.merge(otherFields);
                continue block2;
            }
            System.out.println("Warning, class " + otherClass.getFullname() + " has field " + otherFields.getName() + " that was not found in template");
        }
    }

    private static boolean isCritical(MergeException me, int level) {
        int errorSeverity = me.getSeverity();
        if (level == 0 || errorSeverity == 0) {
            return true;
        }
        if (level == 1 && errorSeverity == 3) {
            return false;
        }
        if (level == 2 && errorSeverity >= 2) {
            return false;
        }
        return level != 3;
    }

    private void checkEquals(DataClass other, String trace) throws MergeException {
        if (!this.fullname.equals(other.fullname)) {
            throw new MergeException("Fullname mismatch: expected '" + this.fullname + "'; found '" + other.fullname + "'", trace, 0);
        }
        if (this.checksum != -1L && other.checksum != -1L && this.checksum != other.checksum) {
            throw new MergeException("Checksum mismatch: expected '" + this.checksum + "'; found '" + other.checksum + "'", trace, 1);
        }
        if (this.methods.size() != other.methods.size()) {
            throw new MergeException("Method size mismatch: expected '" + this.methods.size() + "'; found '" + other.methods.size() + "'", trace, 1);
        }
        if (this.signature != null && !this.signature.equals(other.signature)) {
            throw new MergeException("Signature mismatch: expected '" + this.signature + "'; found '" + other.signature + "'", trace, 2);
        }
        if ((this.access | 0x20) != (other.access | 0x20)) {
            throw new MergeException("Access mismatch: expected '" + this.access + "'; found '" + other.access + "'", trace, 3);
        }
        if (this.fields.size() != other.fields.size()) {
            throw new MergeException("Field size mismatch: expected '" + this.fields.size() + "'; found '" + other.fields.size() + "'", trace, 3);
        }
    }

    void expandScales(int newSize, boolean add_before) {
        for (DataMethod m : this.methods) {
            for (DataBlock bl : m) {
                bl.expandScales(newSize, add_before);
            }
        }
        for (DataField fld : this.fields) {
            for (DataBlock bl : fld) {
                bl.expandScales(newSize, add_before);
            }
        }
    }

    void expandScales(int newSize, boolean add_before, int newcount) {
        for (DataMethod m : this.methods) {
            for (DataBlock bl : m) {
                bl.expandScales(newSize, add_before, newcount);
            }
        }
        for (DataField fld : this.fields) {
            for (DataBlock bl : fld) {
                bl.expandScales(newSize, add_before, newcount);
            }
        }
    }

    public void applyFilter(MemberFilter filter) {
        DataAnnotated next;
        Iterator<DataAnnotated> it = this.methods.iterator();
        while (it.hasNext()) {
            next = it.next();
            if (filter.accept(this, (DataMethod)next)) continue;
            it.remove();
        }
        it = this.fields.iterator();
        while (it.hasNext()) {
            next = (DataField)it.next();
            if (filter.accept(this, (DataField)next)) continue;
            it.remove();
        }
    }

    public void sort() {
        Collections.sort(this.methods);
        Collections.sort(this.fields);
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeUTF(this.name);
        DataClass.writeString(out, this.moduleName);
        DataClass.writeString(out, this.fullname);
        DataClass.writeString(out, this.signature);
        DataClass.writeString(out, this.source);
        DataClass.writeString(out, this.superName);
        DataClass.writeString(out, this.superInterfaces);
        out.writeLong(this.checksum);
        out.writeInt(this.access & Short.MAX_VALUE);
        out.writeByte((this.differentiateClass ? 1 : 0) + (this.inner ? 2 : 0) + (this.anonym ? 4 : 0));
        out.writeShort(this.fields.size());
        for (DataField f : this.fields) {
            f.writeObject(out);
        }
        out.writeShort(this.methods.size());
        for (DataMethod m : this.methods) {
            if (m instanceof DataMethodEntryOnly) {
                if ((m.access & 0x500) != 0) {
                    out.write(2);
                } else {
                    out.write(1);
                }
            } else if (m instanceof DataMethodInvoked) {
                if ((m.access & 0x500) != 0) {
                    out.write(2);
                } else {
                    out.write(1);
                }
            } else if (m instanceof DataMethodWithBlocks) {
                out.write(3);
            } else {
                System.out.println("ERROR " + m.getFullName());
                out.write(4);
                throw new IOException("DataClass.writeObject - Unknown dataMethod class " + m.getClass().getName() + ".");
            }
            m.writeObject(out);
        }
    }

    DataClass(int rootID, DataInput in) throws IOException {
        super(rootID, in);
        this.name = in.readUTF();
        this.moduleName = DataClass.readString(in);
        this.fullname = DataClass.readString(in);
        this.signature = DataClass.readString(in);
        this.source = DataClass.readString(in);
        this.superName = DataClass.readString(in);
        this.superInterfaces = DataClass.readString(in);
        this.checksum = in.readLong();
        this.access = in.readInt();
        byte b = in.readByte();
        this.differentiateClass = (b & 1) != 0;
        this.inner = (b & 2) != 0;
        this.anonym = (b & 4) != 0;
        int fieldsNum = in.readShort();
        this.fields = new ArrayList<DataField>(fieldsNum);
        for (int i = 0; i < fieldsNum; ++i) {
            this.fields.add(new DataField(this, in));
        }
        int methodsNum = in.readShort();
        this.methods = new ArrayList<DataMethod>(methodsNum);
        block6: for (int i = 0; i < methodsNum; ++i) {
            byte code = in.readByte();
            switch (code) {
                case 1: {
                    this.methods.add(new DataMethodEntryOnly(this, in));
                    continue block6;
                }
                case 2: {
                    this.methods.add(new DataMethodInvoked(this, in));
                    continue block6;
                }
                case 3: {
                    this.methods.add(new DataMethodWithBlocks(this, in));
                    continue block6;
                }
                default: {
                    throw new IOException("DataMethod with unknown code in DataClass " + code);
                }
            }
        }
    }

    public void setInner(boolean inner) {
        this.inner = inner;
    }

    public boolean isInner() {
        return this.inner;
    }

    public boolean isAnonymous() {
        return this.anonym;
    }

    public void setAnonym(boolean b) {
        this.anonym = b;
    }
}

