/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.DataAbstract;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DataAnnotated
extends DataAbstract {
    private List<String> annotations;

    DataAnnotated(int rootId) {
        super(rootId);
    }

    void addAnnotation(String anno) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<String>();
        }
        this.annotations.add(anno);
    }

    protected boolean hasAnnotation(String anno) {
        return this.annotations != null && this.annotations.contains(anno);
    }

    protected List<String> getAnnotations() {
        return this.annotations;
    }

    void writeObject(DataOutput out) throws IOException {
        if (this.annotations != null) {
            out.writeShort(this.annotations.size());
            for (String s : this.annotations) {
                out.writeUTF(s);
            }
        } else {
            out.writeShort(Short.MAX_VALUE);
        }
    }

    DataAnnotated(int rootID, DataInput in) throws IOException {
        super(rootID);
        int annoNum = in.readShort();
        if (annoNum != Short.MAX_VALUE) {
            this.annotations = new ArrayList<String>(annoNum);
            for (int i = 0; i < annoNum; ++i) {
                String s = in.readUTF();
                this.annotations.add(s);
            }
        } else {
            this.annotations = null;
        }
    }
}

