/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.instrument.ClassMorph;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.runtime.AgentSocketSaver;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.CollectDetect;
import com.sun.tdk.jcov.runtime.FileSaver;
import com.sun.tdk.jcov.runtime.JCovSaver;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.runtime.SaverDecorator;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Agent
extends JCovTool {
    private boolean detectInternal;
    private boolean classesReload;
    private boolean instrumentField;
    private boolean instrumentAbstract;
    private boolean instrumentNative;
    private boolean instrumentAnonymous = true;
    private boolean instrumentSynthetic = true;
    private String[] include;
    private String[] exclude;
    private String[] m_include;
    private String[] m_exclude;
    private String[] callerInclude;
    private String[] callerExclude;
    private String[] fm;
    private String[] saveBegin;
    private String[] saveEnd;
    private String template;
    private String filename;
    private String flushPath;
    private InstrumentationOptions.InstrumentationMode mode;
    private InstrumentationOptions.MERGE merge;
    private boolean grabberSaver = false;
    private static final Logger logger;
    private static ClassMorph classMorph;
    private String host;
    private int port;
    private static final Object LOCK;
    public static final OptionDescr DSC_OUTPUT;
    public static final OptionDescr DSC_VERBOSE;
    public static final OptionDescr DSC_TIMEOUT;
    public static final OptionDescr DSC_PORT;
    public static final OptionDescr DSC_PORT_GRABBER;
    public static final OptionDescr DSC_HOST_GRABBER;
    public static final OptionDescr DSC_LOG;
    public static final OptionDescr DSC_GRABBER;

    public static void premain(String agentArgs, Instrumentation instArg) {
        Agent tool = new Agent();
        EnvHandler handler = tool.defineHandler();
        try {
            if (agentArgs == null) {
                agentArgs = "";
            }
            handler.parseCLIArgs(EnvHandler.parseAgentString(agentArgs));
            tool.handleEnv(handler);
            if (handler.isSet(EnvHandler.PRINT_ENV)) {
                handler.printEnv();
            }
        }
        catch (EnvHandler.CLParsingException ex) {
            if (handler.isSet(EnvHandler.HELP)) {
                handler.usage();
                handler.getOut().println("\n JCov Agent command line error: " + ex.getMessage() + "\n");
                System.exit(1);
            }
            if (handler.isSet(EnvHandler.HELP_VERBOSE)) {
                handler.usage(true);
                handler.getOut().println("\n JCov Agent command line error: " + ex.getMessage() + "\n");
                System.exit(1);
            }
            handler.getOut().println(" JCov Agent command line error: " + ex.getMessage() + "\n");
            handler.getOut().println("Use \"java -jar jcov.jar Agent -h\" for command-line help or \"java -jar jcov.jar Agent -hv\" for wider description");
            System.exit(1);
        }
        catch (JCovTool.EnvHandlingException ex) {
            handler.getOut().println("JCov Agent command line error: " + ex.getMessage() + "\n");
            handler.getOut().println("Use \"java -jar jcov.jar Agent -h\" for command-line help or \"java -jar jcov.jar Agent -hv\" for wider description");
            if (handler.isSet(EnvHandler.PRINT_ENV)) {
                handler.printEnv();
            }
            System.exit(1);
        }
        catch (Throwable ex) {
            handler.getOut().println("JCov Agent command line error: " + ex.getMessage());
            System.exit(1);
        }
        if (handler.isSet(EnvHandler.PRINT_ENV)) {
            handler.printEnv();
            System.exit(0);
        }
        try {
            if (Utils.getJavaVersion() >= 160) {
                tool.premainV50(agentArgs, instArg);
            } else {
                tool.premainV49(agentArgs, instArg);
            }
        }
        catch (Exception ex) {
            System.out.println("Agent execution error: " + ex.getMessage());
            ex.printStackTrace();
            System.exit(2);
        }
    }

    public void premainV50(String agentArgs, Instrumentation inst) throws Exception {
        JCovSaver saver;
        InstrumentationParams params = new InstrumentationParams(true, this.classesReload, true, this.instrumentNative, this.instrumentField, this.detectInternal, this.instrumentAbstract ? InstrumentationOptions.ABSTRACTMODE.DIRECT : InstrumentationOptions.ABSTRACTMODE.NONE, this.include, this.exclude, this.callerInclude, this.callerExclude, this.m_include, this.m_exclude, this.mode, this.saveBegin, this.saveEnd).setInstrumentAnonymous(this.instrumentAnonymous).setInstrumentSynthetic(this.instrumentSynthetic);
        params.enable();
        CollectDetect.enterInstrumentationCode();
        Tr transformer = new Tr("RetransformApp", this.flushPath);
        inst.addTransformer(transformer, true);
        if (params.isInstrumentNative()) {
            inst.setNativeMethodPrefix(transformer, "$$generated$$_");
        }
        DataRoot root = new DataRoot(agentArgs, params);
        classMorph = new ClassMorph(this.filename, root, params);
        Class[] classes = inst.getAllLoadedClasses();
        HashSet<Class> examinedClasses = new HashSet<Class>(Arrays.asList(classes));
        int keep = 0;
        for (Class c : classes) {
            if (!inst.isModifiableClass(c) || !classMorph.shouldTransform(c.getName().replace('.', '/')) || c.getName().replace('.', '/').equals("jdk/internal/reflect/Reflection") || c.getName().replace('.', '/').equals("sun/reflect/Reflection")) continue;
            classes[keep++] = c;
        }
        transformer.ignoreLoads = false;
        if (keep > 0) {
            classes = Utils.copyOf(classes, keep);
            logger.log(Level.INFO, "About to retransform {0} classes {1}", new Object[]{keep, classes[0]});
            try {
                inst.retransformClasses(classes);
            }
            catch (UnmodifiableClassException e) {
                System.err.println("Should not happen: " + e);
                e.printStackTrace(System.err);
            }
            catch (Throwable e) {
                System.err.println("During retransform: " + e);
                e.printStackTrace(System.err);
            }
        }
        logger.log(Level.INFO, "Retransformed {0} classes", keep);
        Class[] allClasses = inst.getAllLoadedClasses();
        keep = 0;
        for (Class c : allClasses) {
            if (examinedClasses.contains(c) || !inst.isModifiableClass(c) || !classMorph.shouldTransform(c.getName().replace('.', '/'))) continue;
            allClasses[keep++] = c;
        }
        if (keep > 0) {
            logger.log(Level.INFO, "New not transformed: {0} classes {1}", new Object[]{keep, allClasses[0]});
            classes = Utils.copyOf(classes, keep);
            try {
                inst.retransformClasses(classes);
            }
            catch (UnmodifiableClassException e) {
                logger.log(Level.SEVERE, "retransformClasses: Should not happen: ", e);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Error during retransform: ", e);
            }
        }
        if (!this.grabberSaver) {
            saver = FileSaver.getFileSaver(root, this.filename, this.template, this.merge, true);
            this.loadFileSaverClasses();
            Collect.setSaver(Collect.decorateSaver(new SynchronizedSaverDecorator(saver)));
        } else {
            saver = new AgentSocketSaver(root, this.filename, this.host, this.port);
            Collect.setSaver(Collect.decorateSaver(new SynchronizedSaverDecorator(saver)));
        }
        CollectDetect.leaveInstrumentationCode();
        PropertyFinder.addAutoShutdownSave();
    }

    private void loadFileSaverClasses() throws IOException {
        File file = new File(this.filename + "_load");
        new FileOutputStream(file).close();
        file.delete();
    }

    public void premainV49(String agentArgs, Instrumentation inst) throws Exception {
        JCovSaver saver;
        InstrumentationParams params = new InstrumentationParams(true, this.instrumentNative, this.instrumentField, this.detectInternal, this.instrumentAbstract ? InstrumentationOptions.ABSTRACTMODE.DIRECT : InstrumentationOptions.ABSTRACTMODE.NONE, this.include, this.exclude, this.callerInclude, this.callerExclude, this.mode, this.saveBegin, this.saveEnd).setInstrumentAnonymous(this.instrumentAnonymous).setInstrumentSynthetic(this.instrumentSynthetic);
        params.enable();
        CollectDetect.enterInstrumentationCode();
        Tr transformer = new Tr("RetransformApp", this.flushPath);
        inst.addTransformer(transformer);
        DataRoot root = new DataRoot(agentArgs, params);
        classMorph = new ClassMorph(this.filename, root, params);
        Class[] classes = inst.getAllLoadedClasses();
        HashSet<Class> examinedClasses = new HashSet<Class>(Arrays.asList(classes));
        int keep = 0;
        for (Class c : classes) {
            if (!classMorph.shouldTransform(c.getName().replace('.', '/'))) continue;
            classes[keep++] = c;
        }
        if (keep > 0) {
            classes = Utils.copyOf(classes, keep);
            logger.log(Level.INFO, "About to retransform {0} classes {1}", new Object[]{keep, classes[0]});
        }
        logger.log(Level.INFO, "Retransformed {0} classes", keep);
        transformer.ignoreLoads = false;
        Class[] allClasses = inst.getAllLoadedClasses();
        keep = 0;
        for (Class c : allClasses) {
            if (examinedClasses.contains(c) || !classMorph.shouldTransform(c.getName().replace('.', '/'))) continue;
            allClasses[keep++] = c;
        }
        if (keep > 0) {
            classes = Utils.copyOf(allClasses, keep);
        }
        if (!this.grabberSaver) {
            saver = FileSaver.getFileSaver(root, this.filename, this.template, this.merge, true);
            this.loadFileSaverClasses();
            Collect.setSaver(Collect.decorateSaver(new SynchronizedSaverDecorator(saver)));
        } else {
            saver = new AgentSocketSaver(root, this.filename, this.host, this.port);
            Collect.setSaver(Collect.decorateSaver(new SynchronizedSaverDecorator(saver)));
        }
        CollectDetect.leaveInstrumentationCode();
        PropertyFinder.addAutoShutdownSave();
    }

    @Override
    public String usageString() {
        return "java -javaagent:jcov.jar=[=option=value[,option=value]*] ...";
    }

    @Override
    public String exampleString() {
        return "java -javaagent:jcov.jar=include=java\\.lang\\.String,native=on,type=branch,abstract=off -jar MyApp.jar";
    }

    @Override
    public String getDescr() {
        return "print help on usage jcov in dynamic mode";
    }

    @Override
    public boolean isMainClassProvided() {
        return false;
    }

    @Override
    public EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_OUTPUT, InstrumentationOptions.DSC_MERGE, DSC_VERBOSE, DSC_TIMEOUT, DSC_PORT, InstrumentationOptions.DSC_TEMPLATE, InstrumentationOptions.DSC_TYPE, InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_CALLER_INCLUDE, InstrumentationOptions.DSC_CALLER_EXCLUDE, InstrumentationOptions.DSC_MINCLUDE, InstrumentationOptions.DSC_MEXCLUDE, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_MINCLUDE_LIST, InstrumentationOptions.DSC_MEXCLUDE_LIST, InstrumentationOptions.DSC_ABSTRACT, InstrumentationOptions.DSC_NATIVE, InstrumentationOptions.DSC_FIELD, InstrumentationOptions.DSC_SYNTHETIC, InstrumentationOptions.DSC_ANONYM, InstrumentationOptions.DSC_CLASSESRELOAD, InstrumentationOptions.DSC_SAVE_BEGIN, InstrumentationOptions.DSC_SAVE_AT_END, ClassMorph.DSC_FLUSH_CLASSES, DSC_GRABBER, DSC_PORT_GRABBER, DSC_HOST_GRABBER, DSC_LOG}, (JCovTool)this);
    }

    @Override
    public int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        long timeout;
        String internal = "default";
        if (internal.equals("detect")) {
            this.detectInternal = true;
        } else if (internal.equals("show")) {
            this.detectInternal = true;
        } else if (internal.equals("include")) {
            this.detectInternal = false;
        } else if (internal.equals("default")) {
            this.detectInternal = true;
        } else {
            throw new Error("Parameter error");
        }
        this.mode = InstrumentationOptions.InstrumentationMode.fromString(opts.getValue(InstrumentationOptions.DSC_TYPE));
        if (opts.isSet(InstrumentationOptions.DSC_TEMPLATE)) {
            this.template = opts.getValue(InstrumentationOptions.DSC_TEMPLATE);
        }
        this.include = InstrumentationOptions.handleInclude(opts);
        this.exclude = InstrumentationOptions.handleExclude(opts);
        this.m_include = InstrumentationOptions.handleMInclude(opts);
        this.m_exclude = InstrumentationOptions.handleMExclude(opts);
        this.fm = InstrumentationOptions.handleFM(opts);
        this.callerInclude = opts.getValues(InstrumentationOptions.DSC_CALLER_INCLUDE);
        this.callerExclude = opts.getValues(InstrumentationOptions.DSC_CALLER_EXCLUDE);
        String abstractValue = opts.getValue(InstrumentationOptions.DSC_ABSTRACT);
        if (abstractValue.equals("off")) {
            this.instrumentAbstract = false;
        } else if (abstractValue.equals("on")) {
            this.instrumentAbstract = true;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_ABSTRACT.name + "' parameter value error: expected 'on' or 'off'; found: '" + abstractValue + "'");
        }
        String classesReloadValue = opts.getValue(InstrumentationOptions.DSC_CLASSESRELOAD);
        this.classesReload = classesReloadValue.equals("on");
        String nativeValue = opts.getValue(InstrumentationOptions.DSC_NATIVE);
        if (nativeValue.equals("on")) {
            this.instrumentNative = true;
        } else if (nativeValue.equals("off")) {
            this.instrumentNative = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_NATIVE.name + "' parameter value error: expected 'on' or 'off'; found: '" + nativeValue + "'");
        }
        String fieldValue = opts.getValue(InstrumentationOptions.DSC_FIELD);
        if (fieldValue.equals("on")) {
            this.instrumentField = true;
        } else if (fieldValue.equals("off")) {
            this.instrumentField = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_FIELD.name + "' parameter value error: expected 'on' or 'off'; found: '" + fieldValue + "'");
        }
        String anonym = opts.getValue(InstrumentationOptions.DSC_ANONYM);
        this.instrumentAnonymous = anonym.equals("on");
        String synthetic = opts.getValue(InstrumentationOptions.DSC_SYNTHETIC);
        this.instrumentSynthetic = synthetic.equals("on");
        String mergeValue = opts.getValue(InstrumentationOptions.DSC_MERGE);
        if (mergeValue.equals("merge")) {
            this.merge = InstrumentationOptions.MERGE.MERGE;
        } else if (mergeValue.equals("scale")) {
            this.merge = InstrumentationOptions.MERGE.SCALE;
        } else if (mergeValue.equals("overwrite")) {
            this.merge = InstrumentationOptions.MERGE.OVERWRITE;
        } else if (mergeValue.equals("gensuff")) {
            this.merge = InstrumentationOptions.MERGE.GEN_SUFF;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_MERGE.name + "' parameter value error: expected 'merge', 'scale', 'overwrite' or 'gensuff'; found: '" + mergeValue + "'");
        }
        this.saveBegin = opts.getValues(InstrumentationOptions.DSC_SAVE_BEGIN);
        this.saveEnd = opts.getValues(InstrumentationOptions.DSC_SAVE_AT_END);
        this.flushPath = opts.getValue(ClassMorph.DSC_FLUSH_CLASSES);
        if ("none".equals(this.flushPath)) {
            this.flushPath = null;
        }
        String logfile = opts.getValue(EnvHandler.LOGFILE);
        if (opts.isSet(DSC_LOG) || logfile != null) {
            if (logfile == null) {
                logfile = "jcov.log";
            }
            try {
                Utils.setLoggerHandler(new FileHandler(logfile));
            }
            catch (Exception ex) {
                throw new JCovTool.EnvHandlingException("Can't open file '" + logfile + "' for writing the log", ex);
            }
            if (opts.isSet(EnvHandler.LOGLEVEL)) {
                Utils.setLoggingLevel(opts.getValue(EnvHandler.LOGLEVEL));
            } else if (opts.isSet(DSC_VERBOSE)) {
                int verbositylevel = Utils.checkedToInt(opts.getValue(DSC_VERBOSE), "verbosity level", Utils.CheckOptions.INT_NONNEGATIVE);
                switch (verbositylevel) {
                    case 0: {
                        logger.setLevel(Level.SEVERE);
                        Utils.setLoggingLevel(Level.SEVERE);
                        break;
                    }
                    case 1: {
                        logger.setLevel(Level.CONFIG);
                        Utils.setLoggingLevel(Level.CONFIG);
                        break;
                    }
                    case 2: {
                        logger.setLevel(Level.INFO);
                        Utils.setLoggingLevel(Level.INFO);
                        break;
                    }
                    case 3: {
                        logger.setLevel(Level.ALL);
                        Utils.setLoggingLevel(Level.ALL);
                        break;
                    }
                    default: {
                        throw new JCovTool.EnvHandlingException("Incorrect verbosity level (" + opts.getValue(DSC_VERBOSE) + ") - should be 0..3");
                    }
                }
            }
        } else {
            Utils.setLoggingLevel(Level.OFF);
        }
        if (opts.isSet(DSC_TIMEOUT) && (timeout = (long)Utils.checkedToInt(opts.getValue(DSC_TIMEOUT), "timeout value", new Utils.CheckOptions[0])) > 0L) {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    logger.log(Level.INFO, "Agent has been timed out.");
                    if (Collect.enabled) {
                        Collect.disable();
                        Collect.saveResults();
                    }
                    Runtime.getRuntime().halt(0);
                }
            }, timeout);
        }
        this.grabberSaver = opts.isSet(DSC_GRABBER);
        if (this.grabberSaver) {
            this.host = opts.getValue(DSC_HOST_GRABBER);
            Utils.checkHostCanBeNull(this.host, "grabber host");
            this.port = Utils.checkedToInt(opts.getValue(DSC_PORT_GRABBER), "grabber port number", Utils.CheckOptions.INT_POSITIVE);
        }
        this.filename = opts.getValue(DSC_OUTPUT);
        if (!this.grabberSaver) {
            Utils.checkFileNotNull(this.filename, "output filename", Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_PARENTEXISTS);
        }
        if (opts.isSet(DSC_PORT)) {
            CommandThread cmdThread = new CommandThread(Utils.checkedToInt(opts.getValue(DSC_PORT), "command listener port number", Utils.CheckOptions.INT_POSITIVE), new InstrumentationParams(true, this.instrumentNative, this.instrumentField, this.detectInternal, this.instrumentAbstract ? InstrumentationOptions.ABSTRACTMODE.DIRECT : InstrumentationOptions.ABSTRACTMODE.NONE, this.include, this.exclude, this.callerInclude, this.callerExclude, this.mode, this.saveBegin, this.saveEnd).setInstrumentAnonymous(this.instrumentAnonymous).setInstrumentSynthetic(this.instrumentSynthetic));
            cmdThread.start();
        }
        return 0;
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(Agent.class.getName());
        LOCK = new Object();
        DSC_OUTPUT = new OptionDescr("file", new String[]{"url", "o"}, "Output path definition.", 1, "Specifies output data file. \nIf specified file already exists, collected data will be merged with data from file", "result.xml");
        DSC_VERBOSE = new OptionDescr("verbose", "Verbosity level.", new String[][]{{"0", "minimal, only fatal failure diagnostic is printed"}, {"1", "moderate, non-fatal errors are included in log"}, {"2", "high, all warnings are included in log"}, {"3", "highest, all messages are included in log"}}, "Set verbosity level.", "0");
        DSC_TIMEOUT = new OptionDescr("timeout", "Agent process timeout.", 1, "Specifies timeout for agent process in milliseconds.\n0 means there is no timeout specified. Default is 0.\n", "0");
        DSC_PORT = new OptionDescr("agent.port", new String[]{"portcl"}, "Agent command listening port", 1, "Specifies port number to listen for driving commands.\nCommands are executed sequentially, some may send messages in response. Valid commands to send are: \n   \"save\" - to save already collected data. It will respond with \"saved\" message\n   \"exit\" - to perform System.exit() immediately. Exit code number may be sent with this command.\n              It's chars should follow \"exit\"");
        DSC_PORT_GRABBER = new OptionDescr("port", new String[]{"grabberport"}, "", 1, "Specifies port number to send data to the grabber", "3334");
        DSC_HOST_GRABBER = new OptionDescr("host", new String[]{"grabberhost"}, "", 1, "Specifies host name to send data to the grabber", "localhost");
        DSC_LOG = new OptionDescr("log", "logging", 0, "Turns on JCov's agent logging.\nLog records saved in jcov.log file");
        DSC_GRABBER = new OptionDescr("grabber", "use grabber saver", 0, "Use grabber saver instead of file saver. jcov.port and jcov.host VM properties could be used to control the saver as well as JCOV_PORT and JCOV_HOST env variable");
    }

    private static class CommandThread
    extends Thread {
        private int port;
        private InstrumentationParams params;

        public CommandThread(int port, InstrumentationParams params) {
            this.port = port;
            this.params = params;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int l;
                        ServerSocket sock = new ServerSocket(this.port);
                        Socket s = sock.accept();
                        InputStream is = s.getInputStream();
                        byte[] buff = new byte[1024];
                        String rest = "";
                        while ((l = is.read(buff)) > 0) {
                            String msg = rest + new String(buff, 0, l, Charset.defaultCharset());
                            rest = this.performTask(msg, s);
                        }
                        sock.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Network IOException", ex);
                    continue;
                }
                break;
            }
        }

        private String performTask(String msg, Socket sock) throws IOException {
            COMMAND cmd;
            Pattern p = Pattern.compile("\\p{Space}*(\\p{Digit}+).*");
            msg = msg.toLowerCase(Locale.getDefault());
            PrintStream ps = new PrintStream(sock.getOutputStream(), false, "UTF-8");
            while (msg.length() > 0 && (cmd = this.nextCommand(msg = msg.trim())) != null) {
                switch (cmd) {
                    case SAVE: {
                        msg = msg.substring(cmd.cmd().length());
                        if (Collect.enabled) {
                            Collect.disable();
                            Collect.saveResults();
                            this.params.enable();
                        }
                        ps.print(COMMAND.SAVED.cmd());
                        ps.flush();
                        break;
                    }
                    case EXIT: {
                        msg = msg.substring(cmd.cmd().length());
                        Matcher m = p.matcher(msg);
                        int exitCode = 0;
                        if (m.matches()) {
                            exitCode = Integer.parseInt(m.group(1));
                        }
                        System.exit(exitCode);
                        break;
                    }
                    case EXIT_WITHOUT_SAVE: {
                        msg = msg.substring(cmd.cmd().length());
                        Matcher m = p.matcher(msg);
                        int exitCode = 0;
                        if (m.matches()) {
                            exitCode = Integer.parseInt(m.group(1));
                        }
                        FileSaver.setDisableAutoSave(true);
                        ps.print(COMMAND.AUTOSAVE_DISABLED.cmd());
                        ps.flush();
                        System.exit(exitCode);
                    }
                }
            }
            return msg;
        }

        private COMMAND nextCommand(String msg) {
            String foundPref = "";
            COMMAND found = null;
            for (COMMAND c : COMMAND.values()) {
                if (!msg.startsWith(c.cmd()) || foundPref.length() >= c.cmd().length()) continue;
                found = c;
                foundPref = c.cmd();
            }
            return found;
        }

        public static enum COMMAND {
            SAVE{

                @Override
                String cmd() {
                    return "save";
                }
            }
            ,
            SAVED{

                @Override
                String cmd() {
                    return "saved";
                }
            }
            ,
            EXIT{

                @Override
                String cmd() {
                    return "exit";
                }
            }
            ,
            EXIT_WITHOUT_SAVE{

                @Override
                String cmd() {
                    return "exitWithoutSave".toLowerCase();
                }
            }
            ,
            AUTOSAVE_DISABLED{

                @Override
                String cmd() {
                    return "autosave disabled";
                }
            };


            abstract String cmd();
        }
    }

    private static class Tr
    implements ClassFileTransformer {
        private final String flushpath;
        private final String trname;
        private boolean ignoreLoads = true;

        public Tr(String trname, String flushpath) {
            this.trname = trname;
            this.flushpath = flushpath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            Object object = LOCK;
            synchronized (object) {
                block12: {
                    byte[] byArray;
                    if (!Collect.enabled) {
                        return null;
                    }
                    CollectDetect.enterInstrumentationCode();
                    try {
                        byte[] newBuff;
                        if (this.ignoreLoads) {
                            logger.log(Level.INFO, "Ignore for now {0}", className);
                            break block12;
                        }
                        logger.log(Level.INFO, "Try to transform {0}", className);
                        byArray = newBuff = classMorph.morph(classfileBuffer, loader, this.flushpath);
                    }
                    catch (Throwable e) {
                        try {
                            logger.log(Level.SEVERE, "Adaption failed for {0} with :{1}", new Object[]{className, e});
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CollectDetect.leaveInstrumentationCode();
                        }
                    }
                    CollectDetect.leaveInstrumentationCode();
                    return byArray;
                }
                CollectDetect.leaveInstrumentationCode();
                return null;
            }
        }
    }

    private static class SynchronizedSaverDecorator
    implements SaverDecorator {
        private JCovSaver wrap;

        public SynchronizedSaverDecorator(JCovSaver wrap) {
            this.init(wrap);
        }

        @Override
        public final void init(JCovSaver saver) {
            this.wrap = saver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveResults() {
            Object object = LOCK;
            synchronized (object) {
                this.wrap.saveResults();
            }
        }
    }
}

