/*
 * Decompiled with CFR 0.152.
 */
package org.testng.asserts;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.asserts.IAssert;
import org.testng.asserts.IAssertLifecycle;

public class Assertion
implements IAssertLifecycle {
    protected void doAssert(IAssert<?> assertCommand) {
        this.onBeforeAssert(assertCommand);
        try {
            this.executeAssert(assertCommand);
            this.onAssertSuccess(assertCommand);
        }
        catch (AssertionError ex) {
            this.onAssertFailure(assertCommand, ex);
            throw ex;
        }
        finally {
            this.onAfterAssert(assertCommand);
        }
    }

    @Override
    public void executeAssert(IAssert<?> assertCommand) {
        assertCommand.doAssert();
    }

    @Override
    public void onAssertSuccess(IAssert<?> assertCommand) {
    }

    @Override
    @Deprecated
    public void onAssertFailure(IAssert<?> assertCommand) {
    }

    @Override
    public void onAssertFailure(IAssert<?> assertCommand, AssertionError ex) {
        this.onAssertFailure(assertCommand);
    }

    @Override
    public void onBeforeAssert(IAssert<?> assertCommand) {
    }

    @Override
    public void onAfterAssert(IAssert<?> assertCommand) {
    }

    public void assertTrue(final boolean condition, final String message) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(condition), Boolean.TRUE){

            @Override
            public void doAssert() {
                Assert.assertTrue(condition, message);
            }
        });
    }

    public void assertTrue(final boolean condition) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(condition), Boolean.TRUE){

            @Override
            public void doAssert() {
                Assert.assertTrue(condition);
            }
        });
    }

    public void assertFalse(final boolean condition, final String message) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(condition), Boolean.FALSE, message){

            @Override
            public void doAssert() {
                Assert.assertFalse(condition, message);
            }
        });
    }

    public void assertFalse(final boolean condition) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(condition), Boolean.FALSE){

            @Override
            public void doAssert() {
                Assert.assertFalse(condition);
            }
        });
    }

    public void fail(final String message, final Throwable realCause) {
        this.doAssert(new SimpleAssert<Object>(message){

            @Override
            public void doAssert() {
                Assert.fail(message, realCause);
            }
        });
    }

    public void fail(final String message) {
        this.doAssert(new SimpleAssert<Object>(message){

            @Override
            public void doAssert() {
                Assert.fail(message);
            }
        });
    }

    public void fail() {
        this.doAssert(new SimpleAssert<Object>(null){

            @Override
            public void doAssert() {
                Assert.fail();
            }
        });
    }

    public <T> void assertEquals(final T actual, final T expected, final String message) {
        this.doAssert(new SimpleAssert<T>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public <T> void assertEquals(final T actual, final T expected) {
        this.doAssert(new SimpleAssert<T>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final String actual, final String expected, final String message) {
        this.doAssert(new SimpleAssert<String>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final String actual, final String expected) {
        this.doAssert(new SimpleAssert<String>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final double actual, final double expected, final double delta, final String message) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(actual), Double.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, delta, message);
            }
        });
    }

    public void assertEquals(final double actual, final double expected, final double delta) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(actual), Double.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, delta);
            }
        });
    }

    public void assertEquals(final float actual, final float expected, final float delta, final String message) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(actual), Float.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, delta, message);
            }
        });
    }

    public void assertEquals(final float actual, final float expected, final float delta) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(actual), Float.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, delta);
            }
        });
    }

    public void assertEquals(final long actual, final long expected, final String message) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(actual), Long.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final long actual, final long expected) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(actual), Long.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final boolean actual, final boolean expected, final String message) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(actual), Boolean.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final boolean actual, final boolean expected) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(actual), Boolean.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final byte actual, final byte expected, final String message) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(actual), Byte.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final byte actual, final byte expected) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(actual), Byte.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final char actual, final char expected, final String message) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(actual), Character.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final char actual, final char expected) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(actual), Character.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final short actual, final short expected, final String message) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(actual), Short.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final short actual, final short expected) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(actual), Short.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final int actual, final int expected, final String message) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(actual), Integer.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final int actual, final int expected) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(actual), Integer.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertNotNull(final Object object) {
        this.doAssert(new SimpleAssert<Object>(object, null){

            @Override
            public void doAssert() {
                Assert.assertNotNull(object);
            }
        });
    }

    public void assertNotNull(final Object object, final String message) {
        this.doAssert(new SimpleAssert<Object>(object, null, message){

            @Override
            public void doAssert() {
                Assert.assertNotNull(object, message);
            }
        });
    }

    public void assertNull(final Object object) {
        this.doAssert(new SimpleAssert<Object>(object, null){

            @Override
            public void doAssert() {
                Assert.assertNull(object);
            }
        });
    }

    public void assertNull(final Object object, final String message) {
        this.doAssert(new SimpleAssert<Object>(object, null, message){

            @Override
            public void doAssert() {
                Assert.assertNull(object, message);
            }
        });
    }

    public void assertSame(final Object actual, final Object expected, final String message) {
        this.doAssert(new SimpleAssert<Object>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertSame(actual, expected, message);
            }
        });
    }

    public void assertSame(final Object actual, final Object expected) {
        this.doAssert(new SimpleAssert<Object>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertSame(actual, expected);
            }
        });
    }

    public void assertNotSame(final Object actual, final Object expected, final String message) {
        this.doAssert(new SimpleAssert<Object>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertNotSame(actual, expected, message);
            }
        });
    }

    public void assertNotSame(final Object actual, final Object expected) {
        this.doAssert(new SimpleAssert<Object>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertNotSame(actual, expected);
            }
        });
    }

    public void assertEquals(final Collection<?> actual, final Collection<?> expected) {
        this.doAssert(new SimpleAssert<Collection<?>>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final Collection<?> actual, final Collection<?> expected, final String message) {
        this.doAssert(new SimpleAssert<Collection<?>>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final Object[] actual, final Object[] expected, final String message) {
        this.doAssert(new SimpleAssert<Object[]>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEqualsNoOrder(final Object[] actual, final Object[] expected, final String message) {
        this.doAssert(new SimpleAssert<Object[]>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertEqualsNoOrder(actual, expected, message);
            }
        });
    }

    public void assertEquals(final Object[] actual, final Object[] expected) {
        this.doAssert(new SimpleAssert<Object[]>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEqualsNoOrder(final Object[] actual, final Object[] expected) {
        this.doAssert(new SimpleAssert<Object[]>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEqualsNoOrder(actual, expected);
            }
        });
    }

    public void assertEquals(final byte[] actual, final byte[] expected) {
        this.doAssert(new SimpleAssert<byte[]>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final byte[] actual, final byte[] expected, final String message) {
        this.doAssert(new SimpleAssert<byte[]>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final Set<?> actual, final Set<?> expected) {
        this.doAssert(new SimpleAssert<Set<?>>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertEquals(final Set<?> actual, final Set<?> expected, final String message) {
        this.doAssert(new SimpleAssert<Set<?>>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected, message);
            }
        });
    }

    public void assertEquals(final Map<?, ?> actual, final Map<?, ?> expected) {
        this.doAssert(new SimpleAssert<Map<?, ?>>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertEquals(actual, expected);
            }
        });
    }

    public void assertNotEquals(final Object actual, final Object expected, final String message) {
        this.doAssert(new SimpleAssert<Object>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(actual, expected, message);
            }
        });
    }

    public void assertNotEquals(final Object actual, final Object expected) {
        this.doAssert(new SimpleAssert<Object>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(actual, expected);
            }
        });
    }

    void assertNotEquals(final String actual, final String expected, final String message) {
        this.doAssert(new SimpleAssert<String>(actual, expected, message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected, message);
            }
        });
    }

    void assertNotEquals(final String actual, final String expected) {
        this.doAssert(new SimpleAssert<String>(actual, expected){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected);
            }
        });
    }

    void assertNotEquals(final long actual, final long expected, final String message) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(actual), Long.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected, message);
            }
        });
    }

    void assertNotEquals(final long actual, final long expected) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(actual), Long.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected);
            }
        });
    }

    void assertNotEquals(final boolean actual, final boolean expected, final String message) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(actual), Boolean.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected, message);
            }
        });
    }

    void assertNotEquals(final boolean actual, final boolean expected) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(actual), Boolean.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected);
            }
        });
    }

    void assertNotEquals(final byte actual, final byte expected, final String message) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(actual), Byte.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected, message);
            }
        });
    }

    void assertNotEquals(final byte actual, final byte expected) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(actual), Byte.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected);
            }
        });
    }

    void assertNotEquals(final char actual, final char expected, final String message) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(actual), Character.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(Character.valueOf(actual), Character.valueOf(expected), message);
            }
        });
    }

    void assertNotEquals(final char actual, final char expected) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(actual), Character.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(Character.valueOf(actual), Character.valueOf(expected));
            }
        });
    }

    void assertNotEquals(final short actual, final short expected, final String message) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(actual), Short.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected, message);
            }
        });
    }

    void assertNotEquals(final short actual, final short expected) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(actual), Short.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected);
            }
        });
    }

    void assertNotEquals(final int actual, final int expected, final String message) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(actual), Integer.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected, message);
            }
        });
    }

    void assertNotEquals(final int actual, final int expected) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(actual), Integer.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)actual, (Object)expected);
            }
        });
    }

    public void assertNotEquals(final float actual, final float expected, final float delta, final String message) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(actual), Float.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(actual, expected, delta, message);
            }
        });
    }

    public void assertNotEquals(final float actual, final float expected, final float delta) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(actual), Float.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(actual, expected, delta);
            }
        });
    }

    public void assertNotEquals(final double actual, final double expected, final double delta, final String message) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(actual), Double.valueOf(expected), message){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(actual, expected, delta, message);
            }
        });
    }

    public void assertNotEquals(final double actual, final double expected, final double delta) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(actual), Double.valueOf(expected)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(actual, expected, delta);
            }
        });
    }

    private static abstract class SimpleAssert<T>
    implements IAssert<T> {
        private final T actual;
        private final T expected;
        private final String m_message;

        public SimpleAssert(String message) {
            this(null, null, message);
        }

        public SimpleAssert(T actual, T expected) {
            this(actual, expected, null);
        }

        public SimpleAssert(T actual, T expected, String message) {
            this.actual = actual;
            this.expected = expected;
            this.m_message = message;
        }

        @Override
        public String getMessage() {
            return this.m_message;
        }

        @Override
        public T getActual() {
            return this.actual;
        }

        @Override
        public T getExpected() {
            return this.expected;
        }

        @Override
        public abstract void doAssert();
    }
}

