/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.DefaultTimeoutHandler;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.ShellAction;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class TimeoutHandlerProvider {
    private String className;
    private ClassLoader loader;
    private static final long defaultTimeout = 300L;
    private long timeout = 300L;

    public void setClassName(String string) {
        this.className = string;
    }

    public void setClassPath(List<File> list) throws MalformedURLException {
        URL[] uRLArray = new URL[list.size()];
        int n = 0;
        for (File file : list) {
            uRLArray[n++] = file.toURI().toURL();
        }
        this.loader = new URLClassLoader(uRLArray);
    }

    private Class<? extends TimeoutHandler> loadClass() throws ClassNotFoundException {
        Class<?> clazz = this.loader == null ? Class.forName(this.className) : Class.forName(this.className, true, this.loader);
        return clazz.asSubclass(TimeoutHandler.class);
    }

    public TimeoutHandler createHandler(Class<? extends Action> clazz, RegressionScript regressionScript, TestResult.Section section) {
        PrintWriter printWriter = section.getMessageWriter();
        File file = regressionScript.absTestScratchDir();
        File file2 = regressionScript.getTestJDK().getAbsoluteFile();
        if (this.className != null) {
            try {
                Class<? extends TimeoutHandler> clazz2 = this.loadClass();
                Constructor<? extends TimeoutHandler> constructor = clazz2.getDeclaredConstructor(PrintWriter.class, File.class, File.class);
                TimeoutHandler timeoutHandler = constructor.newInstance(printWriter, file, file2);
                timeoutHandler.setTimeout(this.timeout);
                return timeoutHandler;
            }
            catch (Exception exception) {
                printWriter.println("Failed to instantiate timeout handler: " + this.className);
                exception.printStackTrace(printWriter);
                printWriter.println("Reverting to the default timeout handler.");
            }
        }
        if (clazz == ShellAction.class) {
            return null;
        }
        return new DefaultTimeoutHandler(printWriter, file, file2);
    }

    public void setTimeout(long l) {
        this.timeout = l == -1L ? 300L : l;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

