/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.IgnoreKind;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.config.RegressionEnvironment;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.AppletAction;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.CleanAction;
import com.sun.javatest.regtest.exec.CompileAction;
import com.sun.javatest.regtest.exec.DriverAction;
import com.sun.javatest.regtest.exec.IgnoreAction;
import com.sun.javatest.regtest.exec.JUnitAction;
import com.sun.javatest.regtest.exec.Lock;
import com.sun.javatest.regtest.exec.MainAction;
import com.sun.javatest.regtest.exec.ScratchDirectory;
import com.sun.javatest.regtest.exec.ShellAction;
import com.sun.javatest.regtest.exec.TestNGAction;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.exec.TimeoutHandlerProvider;
import com.sun.javatest.regtest.report.TestNGReporter;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RegressionScript
extends Script {
    private static float cacheJavaTestTimeoutFactor = -1.0f;
    private int nextSerial = 0;
    List<Agent> agents = new ArrayList<Agent>();
    static String version;
    private static final String LINESEP;
    private static final String CANT_INSTANTIATE = "Unable to instantiate: ";
    private static final String NOT_EXT_ACTION = " does not extend Action";
    private static final String ILLEGAL_ACCESS_INIT = "Illegal access to init method: ";
    private static final String BAD_ACTION = "Bad action for script: ";
    private final Map<String, Class<?>> actionTable = new HashMap();
    private TestResult testResult;
    private RegressionEnvironment regEnv;
    private RegressionParameters params;
    private RegressionTestSuite testSuite;
    Set<String> defaultModules;
    Set<String> systemModules;
    private boolean useBootClassPath;
    private boolean usePatchModules;
    private boolean useModulePath;
    private ExecMode defaultExecMode;
    private boolean needJUnit;
    private boolean needTestNG;
    private Modules modules;
    private ScratchDirectory scratchDirectory;
    Locations locations;

    /*
     * Exception decompiling
     */
    @Override
    public Status run(String[] var1_1, TestDescription var2_2, TestEnvironment var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void printJDKInfo(PrintWriter printWriter, String string, JDK jDK, List<String> list) {
        printWriter.print(string);
        printWriter.print(": ");
        printWriter.println(jDK.getAbsoluteFile());
        String string2 = jDK.getVersionText(list);
        if (string2.length() > 0) {
            printWriter.println(string2);
        }
    }

    public static Set<File> getSourceFiles(RegressionParameters regressionParameters, TestDescription testDescription) {
        try {
            RegressionScript regressionScript = new RegressionScript();
            regressionScript.params = regressionParameters;
            regressionScript.td = testDescription;
            regressionScript.locations = new Locations(regressionParameters, testDescription);
            regressionScript.modules = new Modules(regressionParameters, testDescription);
            regressionScript.defaultModules = regressionParameters.getTestJDK().getDefaultModules(regressionParameters);
            regressionScript.systemModules = regressionParameters.getTestJDK().getSystemModules(regressionParameters);
            String string = testDescription.getParameter("run");
            LinkedList<Action> linkedList = regressionScript.parseActions(string, false);
            TreeSet<File> treeSet = new TreeSet<File>();
            while (!linkedList.isEmpty()) {
                Action action = linkedList.remove();
                Set<File> set = action.getSourceFiles();
                if (set == null) continue;
                treeSet.addAll(set);
            }
            return treeSet;
        }
        catch (Locations.Fault fault) {
            return Collections.emptySet();
        }
        catch (Modules.Fault fault) {
            return Collections.emptySet();
        }
        catch (ParseException parseException) {
            return Collections.emptySet();
        }
        catch (ParseActionsException parseActionsException) {
            throw new Error(parseActionsException);
        }
    }

    LinkedList<Action> parseActions(String string, boolean bl) throws ParseActionsException, ParseException {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        String[] stringArray = StringUtils.splitTerminator(LINESEP, string);
        this.populateActionTable();
        for (String string2 : stringArray) {
            Object object;
            String[] stringArray2 = StringUtils.splitWS(string2);
            String[] stringArray3 = StringUtils.splitSeparator("/", stringArray2[1]);
            String string3 = stringArray3[0];
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (int i = 1; i < stringArray3.length; ++i) {
                object = StringUtils.splitEqual(stringArray3[i]);
                linkedHashMap.put(object[0], object[1]);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 2; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
            object = null;
            try {
                object = this.actionTable.get(string3);
                if (object == null) {
                    if (!bl) continue;
                    throw new ParseActionsException(BAD_ACTION + string3);
                }
                Action action = (Action)((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                action.init(linkedHashMap, arrayList, this.getReason(stringArray2), this);
                linkedList.add(action);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!bl) continue;
                throw new ParseActionsException(ILLEGAL_ACCESS_INIT + object);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                if (!bl) continue;
                throw new ParseActionsException(CANT_INSTANTIATE + object + NOT_EXT_ACTION);
            }
        }
        return linkedList;
    }

    @Override
    protected int getTestTimeout() {
        return 0;
    }

    protected int getActionTimeout(int n) {
        if (n < 0) {
            n = 120;
        }
        return (int)((float)n * this.getTimeoutFactor());
    }

    protected float getTimeoutFactor() {
        if (cacheJavaTestTimeoutFactor == -1.0f) {
            float f = 1.0f;
            try {
                String string;
                String string2 = string = this.regEnv == null ? null : this.regEnv.lookup("javatestTimeoutFactor")[1];
                if (string != null) {
                    f = Float.parseFloat(string);
                }
            }
            catch (TestEnvironment.Fault fault) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cacheJavaTestTimeoutFactor = f;
        }
        return cacheJavaTestTimeoutFactor;
    }

    @Override
    protected void setAlarm(int n) {
        super.setAlarm(n);
    }

    private void populateActionTable() {
        this.addAction("applet", AppletAction.class);
        this.addAction("build", BuildAction.class);
        this.addAction("clean", CleanAction.class);
        this.addAction("compile", CompileAction.class);
        this.addAction("driver", DriverAction.class);
        this.addAction("ignore", IgnoreAction.class);
        this.addAction("junit", JUnitAction.class);
        this.addAction("main", MainAction.class);
        this.addAction("shell", ShellAction.class);
        this.addAction("testng", TestNGAction.class);
    }

    private void addAction(String string, Class<? extends Action> clazz) {
        this.actionTable.put(string, clazz);
    }

    private String getReason(String[] stringArray) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        switch (string2 = stringArray[0]) {
            case "ASSUMED_ACTION": {
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append(" ");
                }
                string = "Assumed action based on file name: run " + stringBuffer;
                break;
            }
            case "USER_SPECIFIED": {
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append(" ");
                }
                string = "User specified action: run " + stringBuffer;
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    Map<String, String> getEnvVars() {
        return this.params.getEnvVars();
    }

    boolean isCheck() {
        return this.params.isCheck();
    }

    List<String> getTestVMOptions() {
        return this.params.getTestVMOptions();
    }

    List<String> getTestToolVMOptions() {
        return this.params.getTestToolVMOptions();
    }

    List<String> getTestVMJavaOptions() {
        return this.params.getTestVMJavaOptions();
    }

    List<String> getTestDebugOptions() {
        return this.params.getTestDebugOptions();
    }

    List<String> getTestCompilerOptions() {
        return this.params.getTestCompilerOptions();
    }

    List<String> getTestJavaOptions() {
        return this.params.getTestJavaOptions();
    }

    IgnoreKind getIgnoreKind() {
        return this.params.getIgnoreKind();
    }

    File getNativeDir() {
        return this.params.getNativeDir();
    }

    Modules getModules() {
        return this.modules;
    }

    Set<String> getLibBuildArgs() throws TestRunException {
        try {
            return this.testSuite.getLibBuildArgs(this.td);
        }
        catch (TestSuite.Fault fault) {
            throw new TestRunException(fault.getMessage(), fault);
        }
    }

    File absTestWorkFile(String string) {
        return this.locations.absTestWorkFile(string);
    }

    File absTestSrcDir() {
        return this.locations.absTestSrcDir();
    }

    File absTestClsDir() {
        return this.locations.absTestClsDir();
    }

    File absTestScratchDir() {
        return this.scratchDirectory.dir.getAbsoluteFile();
    }

    File absTestClsTopDir() {
        return this.locations.absBaseClsDir();
    }

    private boolean useBootClassPath(File file) throws TestClassException {
        try {
            String string = this.locations.absBaseClsDir().toURI().relativize(file.toURI()).getPath();
            return this.testSuite.useBootClassPath(string);
        }
        catch (TestSuite.Fault fault) {
            throw new TestClassException(fault.toString());
        }
    }

    Map<PathKind, SearchPath> getCompilePaths(Locations.LibLocn libLocn, boolean bl, String string) throws TestRunException {
        Object object;
        SearchPath searchPath = new SearchPath();
        SearchPath searchPath2 = new SearchPath();
        SearchPath searchPath3 = new SearchPath();
        SearchPath searchPath4 = new SearchPath();
        SearchPath searchPath5 = new SearchPath();
        SearchPath searchPath6 = new SearchPath();
        if (libLocn == null || libLocn.name == null) {
            if (bl) {
                searchPath4.append(this.locations.absTestSrcDir());
            } else {
                object = this.locations.absTestSrcDir(string);
                searchPath6.append(new File[]{object});
                searchPath2.append(new File[]{object});
            }
        }
        if (!bl) {
            searchPath2.append(this.locations.absTestClsDir());
        }
        if (this.useModulePath()) {
            searchPath3.append(this.locations.absTestModulesDir());
        }
        if (this.usePatchModules()) {
            searchPath5.append(this.locations.absTestPatchDir());
        }
        if (libLocn != null) {
            if (bl) {
                searchPath4.append(libLocn.absSrcDir);
            } else if (string != null) {
                searchPath6.append(new File(libLocn.absSrcDir, string));
            }
        }
        if (string == null) {
            searchPath6.append(this.locations.absLibSrcList(Locations.LibLocn.Kind.PACKAGE));
        }
        searchPath2.append(this.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE));
        searchPath2.append(this.locations.absLibSrcJarList());
        if (this.useModulePath()) {
            searchPath3.append(this.locations.absLibClsList(Locations.LibLocn.Kind.USER_MODULE));
        }
        if (this.usePatchModules()) {
            searchPath5.append(this.locations.absLibClsList(Locations.LibLocn.Kind.SYS_MODULE));
        }
        if (bl) {
            if (this.needJUnit || this.needTestNG) {
                object = this.workDir.getFile("modules");
                if (this.needJUnit) {
                    this.install(this.params.getJUnitPath(), (File)object);
                }
                if (this.needTestNG) {
                    this.install(this.params.getTestNGPath(), (File)object);
                }
                searchPath3.append(new File[]{object});
            }
        } else {
            if (this.needJUnit) {
                searchPath2.append(this.params.getJUnitPath());
            }
            if (this.needTestNG) {
                searchPath2.append(this.params.getTestNGPath());
            }
        }
        object = this.getCompileJDK();
        searchPath2.append(((JDK)object).getJDKClassPath());
        Map<String, String> map = this.getEnvVars();
        String string2 = map.get("CPAPPEND");
        if (string2 != null) {
            string2 = string2.replace('/', File.separatorChar);
            searchPath2.append(string2);
        }
        EnumMap<PathKind, SearchPath> enumMap = new EnumMap<PathKind, SearchPath>(PathKind.class);
        if (!searchPath.isEmpty()) {
            enumMap.put(PathKind.BOOTCLASSPATH_APPEND, searchPath);
        }
        if (!searchPath2.isEmpty()) {
            enumMap.put(PathKind.CLASSPATH, searchPath2);
        }
        if (!searchPath3.isEmpty()) {
            enumMap.put(PathKind.MODULEPATH, searchPath3);
        }
        if (!searchPath4.isEmpty()) {
            enumMap.put(PathKind.MODULESOURCEPATH, searchPath4);
        }
        if (!searchPath5.isEmpty()) {
            enumMap.put(PathKind.PATCHPATH, searchPath5);
        }
        if (!searchPath6.isEmpty()) {
            enumMap.put(PathKind.SOURCEPATH, searchPath6);
        }
        return enumMap;
    }

    Map<PathKind, SearchPath> getExecutionPaths(boolean bl, String string, boolean bl2, boolean bl3) throws TestRunException {
        Object object;
        Object object2;
        Object object3;
        SearchPath searchPath = new SearchPath();
        SearchPath searchPath2 = new SearchPath();
        SearchPath searchPath3 = new SearchPath();
        SearchPath searchPath4 = new SearchPath();
        SearchPath searchPath5 = bl2 ? searchPath : searchPath2;
        searchPath5.append(this.locations.absTestClsDir());
        searchPath5.append(this.locations.absTestSrcDir());
        if (this.hasTestPatchMods()) {
            searchPath4.append(this.locations.absTestPatchDir());
        }
        if (this.hasTestUserMods()) {
            searchPath3.append(this.locations.absTestModulesDir());
        }
        if (bl2) {
            searchPath.append(this.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE));
            searchPath.append(this.locations.absLibSrcJarList());
        } else {
            object3 = this.locations.getLibs().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (((Locations.LibLocn)object2).kind != Locations.LibLocn.Kind.PACKAGE) continue;
                object = this.useBootClassPath(((Locations.LibLocn)object2).absClsDir) ? searchPath : searchPath2;
                ((SearchPath)object).append(((Locations.LibLocn)object2).absClsDir);
                ((SearchPath)object).append(((Locations.LibLocn)object2).absSrcDir);
            }
            searchPath2.append(this.locations.absLibSrcJarList());
        }
        if (this.useModulePath()) {
            searchPath3.append(this.locations.absLibClsList(Locations.LibLocn.Kind.USER_MODULE));
        }
        if (this.usePatchModules()) {
            searchPath4.append(this.locations.absLibClsList(Locations.LibLocn.Kind.SYS_MODULE));
        }
        if (bl) {
            if (this.needJUnit || this.needTestNG) {
                object3 = this.workDir.getFile("modules");
                if (this.needJUnit) {
                    this.install(this.params.getJUnitPath(), (File)object3);
                }
                if (this.needTestNG) {
                    this.install(this.params.getTestNGPath(), (File)object3);
                }
                searchPath3.append(new File[]{object3});
            }
        } else {
            Object object4 = object3 = !searchPath.isEmpty() || this.usePatchModules() ? searchPath : searchPath2;
            if (this.needJUnit) {
                ((SearchPath)object3).append(this.params.getJUnitPath());
            }
            if (this.needTestNG) {
                ((SearchPath)object3).append(this.params.getTestNGPath());
            }
        }
        object3 = this.getCompileJDK();
        searchPath5.append(((JDK)object3).getJDKClassPath());
        object2 = this.getEnvVars();
        object = (String)object2.get("CPAPPEND");
        if (object != null) {
            object = ((String)object).replace('/', File.separatorChar);
            searchPath2.append(new String[]{object});
        }
        if (bl3) {
            (bl2 ? searchPath : searchPath2).append(this.getJavaTestClassPath());
        }
        EnumMap<PathKind, SearchPath> enumMap = new EnumMap<PathKind, SearchPath>(PathKind.class);
        if (!searchPath.isEmpty()) {
            enumMap.put(PathKind.BOOTCLASSPATH_APPEND, searchPath);
        }
        if (!searchPath2.isEmpty()) {
            enumMap.put(PathKind.CLASSPATH, searchPath2);
        }
        if (!searchPath3.isEmpty()) {
            enumMap.put(PathKind.MODULEPATH, searchPath3);
        }
        if (!searchPath4.isEmpty()) {
            enumMap.put(PathKind.PATCHPATH, searchPath4);
        }
        return enumMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(SearchPath searchPath, File file) throws TestRunException {
        WorkDirectory workDirectory = this.params.getWorkDirectory();
        synchronized (workDirectory) {
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new TestRunException("modules in work directory is not a directory");
                }
            } else {
                file.mkdirs();
            }
            for (File file2 : searchPath.asList()) {
                File file3 = new File(file, file2.getName());
                if (file3.exists() && file3.length() == file2.length() && file3.lastModified() == file2.lastModified()) {
                    return;
                }
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                     BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));){
                    int n;
                    byte[] byArray = new byte[8192];
                    while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    throw new TestRunException("cannot init modules directory", iOException);
                }
                file3.setLastModified(file2.lastModified());
            }
        }
    }

    boolean useBootClassPath() {
        return this.useBootClassPath;
    }

    boolean usePatchModules() {
        return this.usePatchModules;
    }

    boolean hasTestPatchMods() {
        File file = this.locations.absTestPatchDir();
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                return true;
            }
        }
        return false;
    }

    boolean useModulePath() {
        return this.useModulePath;
    }

    boolean hasTestUserMods() {
        File file = this.locations.absTestModulesDir();
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                return true;
            }
        }
        return false;
    }

    ExecMode getExecMode() {
        return this.defaultExecMode;
    }

    SearchPath getJavaTestClassPath() {
        return this.params.getJavaTestClassPath();
    }

    boolean isJUnitRequired() {
        return this.needJUnit;
    }

    SearchPath getJUnitPath() {
        return this.params.getJUnitPath();
    }

    boolean isTestNGRequired() {
        return this.needTestNG;
    }

    SearchPath getTestNGPath() {
        return this.params.getTestNGPath();
    }

    SearchPath getAsmToolsPath() {
        return this.params.getAsmToolsPath();
    }

    TestNGReporter getTestNGReporter() {
        return TestNGReporter.instance(this.workDir);
    }

    Lock getLockIfRequired() throws TestRunException {
        try {
            if (!this.testSuite.needsExclusiveAccess(this.td)) {
                return null;
            }
        }
        catch (TestSuite.Fault fault) {
            throw new TestRunException("Can't determine if lock required", fault);
        }
        return Lock.get(this.params);
    }

    int getNextSerial() {
        return this.nextSerial++;
    }

    TimeoutHandlerProvider getTimeoutHandlerProvider() throws TestRunException {
        try {
            return this.params.getTimeoutHandlerProvider();
        }
        catch (MalformedURLException malformedURLException) {
            throw new TestRunException("Can't get timeout handler provider", malformedURLException);
        }
    }

    JDK getTestJDK() {
        return this.params.getTestJDK();
    }

    JDK_Version getTestJDKVersion() {
        return this.getTestJDK().getVersion(this.params);
    }

    String getJavaProg() {
        return this.params.getTestJDK().getJavaProg().getPath();
    }

    JDK getCompileJDK() {
        return this.params.getCompileJDK();
    }

    JDK_Version getCompileJDKVersion() {
        return this.getCompileJDK().getVersion(this.params);
    }

    String getJavacProg() {
        return this.params.getCompileJDK().getJavacProg().getPath();
    }

    Map<String, String> getTestProperties() throws TestClassException {
        SearchPath searchPath;
        Object object;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        switch (this.getExecMode()) {
            case AGENTVM: {
                object = new SearchPath().append(this.locations.absTestClsDir()).append(this.locations.absTestSrcDir()).append(this.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE)).append(this.locations.absLibSrcJarList());
                linkedHashMap.put("test.class.path.prefix", ((SearchPath)object).toString());
            }
        }
        linkedHashMap.put("test.src", this.locations.absTestSrcDir().getPath());
        linkedHashMap.put("test.src.path", this.toString(this.locations.absTestSrcPath()));
        linkedHashMap.put("test.classes", this.locations.absTestClsDir().getPath());
        linkedHashMap.put("test.class.path", this.toString(this.locations.absTestClsPath()));
        linkedHashMap.put("test.vm.opts", StringUtils.join(this.getTestVMOptions(), " "));
        linkedHashMap.put("test.tool.vm.opts", StringUtils.join(this.getTestToolVMOptions(), " "));
        linkedHashMap.put("test.compiler.opts", StringUtils.join(this.getTestCompilerOptions(), " "));
        linkedHashMap.put("test.java.opts", StringUtils.join(this.getTestJavaOptions(), " "));
        linkedHashMap.put("test.jdk", this.getTestJDK().getAbsolutePath());
        linkedHashMap.put("compile.jdk", this.getCompileJDK().getAbsolutePath());
        linkedHashMap.put("test.timeout.factor", String.valueOf(this.getTimeoutFactor()));
        if (!this.modules.isEmpty()) {
            linkedHashMap.put("test.modules", this.modules.toString());
        }
        if ((object = this.getNativeDir()) != null) {
            linkedHashMap.put("test.nativepath", ((File)object).getAbsolutePath());
        }
        if (this.usePatchModules()) {
            searchPath = new SearchPath();
            searchPath.append(this.locations.absLibClsList(Locations.LibLocn.Kind.SYS_MODULE));
            linkedHashMap.put("test.patch.path", searchPath.toString());
        }
        if (this.useModulePath()) {
            searchPath = new SearchPath();
            searchPath.append(this.locations.absLibClsList(Locations.LibLocn.Kind.USER_MODULE));
            linkedHashMap.put("test.module.path", searchPath.toString());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private String toString(List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(file.getPath());
        }
        return stringBuilder.toString();
    }

    Agent getAgent(JDK jDK, SearchPath searchPath, List<String> list) throws Agent.Fault {
        JDKOpts jDKOpts = new JDKOpts();
        jDKOpts.addAll("-classpath", searchPath.toString());
        jDKOpts.addAll(list);
        if (this.params.getTestJDK().hasModules()) {
            jDKOpts.addAllPatchModules(new SearchPath(this.params.getWorkDirectory().getFile("patches")));
        }
        for (Agent object2 : this.agents) {
            if (!object2.matches(this.absTestScratchDir(), jDK, jDKOpts.toList())) continue;
            return object2;
        }
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.getEnvVars());
        SearchPath searchPath2 = new SearchPath().append(jDK.getJDKClassPath()).append(this.getJavaTestClassPath());
        hashMap.put("CLASSPATH", searchPath2.toString());
        Agent.Pool pool = Agent.Pool.instance();
        Agent agent = pool.getAgent(this.absTestScratchDir(), jDK, jDKOpts.toList(), hashMap);
        this.agents.add(agent);
        return agent;
    }

    void closeAgent(Agent agent) {
        agent.close();
        this.agents.remove(agent);
    }

    void closeAgents() {
        for (Agent agent : this.agents) {
            agent.close();
        }
        this.agents.clear();
    }

    void releaseAgents() {
        Agent.Pool pool = Agent.Pool.instance();
        for (Agent agent : this.agents) {
            pool.save(agent);
        }
    }

    void saveScratchFile(File file, File file2) {
        this.scratchDirectory.retainFile(file, file2);
    }

    static String getVersion() {
        if (version == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Version version = Version.getCurrent();
            stringBuilder.append(version.product == null ? "jtreg" : version.product);
            if (version.version != null) {
                stringBuilder.append(' ').append(version.version);
            }
            if (version.milestone != null) {
                stringBuilder.append(' ').append(version.milestone);
            }
            if (version.build != null) {
                stringBuilder.append(' ').append(version.build);
            }
            RegressionScript.version = stringBuilder.toString();
        }
        return version;
    }

    static {
        LINESEP = System.getProperty("line.separator");
    }

    public static class TestClassException
    extends TestRunException {
        private static final long serialVersionUID = -5087319602062056951L;

        public TestClassException(String string) {
            super("Test Class Exception: " + string);
        }
    }

    static enum PathKind {
        BOOTCLASSPATH_APPEND,
        CLASSPATH,
        MODULEPATH,
        MODULESOURCEPATH,
        PATCHPATH,
        SOURCEPATH;

    }

    static class ParseActionsException
    extends Exception {
        static final long serialVersionUID = -3369214582449830917L;

        ParseActionsException(String string) {
            super(string);
        }
    }
}

