/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.CompileActionHelper;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.ModuleConfig;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CompileAction
extends Action {
    public static final String NAME = "compile";
    private Locations.LibLocn libLocn;
    private File destDir;
    private boolean reverseStatus = false;
    private String ref = null;
    private int timeout = -1;
    private boolean classpathp = false;
    private boolean sourcepathp = false;
    private boolean process = false;
    private String module = null;
    private boolean multiModule = false;
    private Set<String> modules;
    private boolean addDebugOpts = false;
    protected Set<String> othervmOverrideReasons = new LinkedHashSet<String>();

    @Override
    public String getName() {
        return NAME;
    }

    Status compile(Locations.LibLocn libLocn, Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws TestRunException {
        this.libLocn = libLocn;
        this.init(map, list, string, regressionScript);
        return this.run();
    }

    @Override
    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        super.init(map, list, string, regressionScript);
        if (string.startsWith("User specified action: run ")) {
            this.addDebugOpts = true;
        }
        if (list.isEmpty()) {
            throw new ParseException("No classname provided for `compile'");
        }
        block16: for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            switch (string2) {
                case "fail": {
                    this.reverseStatus = this.parseFail(string3);
                    continue block16;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(string3);
                    continue block16;
                }
                case "ref": {
                    this.ref = this.parseRef(string3);
                    continue block16;
                }
                case "process": {
                    this.process = true;
                    continue block16;
                }
                case "module": {
                    this.module = this.parseModule(string3);
                    this.modules = Collections.singleton(this.module);
                    continue block16;
                }
                case "modules": {
                    if (string3 != null) {
                        throw new ParseException("Unexpected value for `modules': " + string3);
                    }
                    this.multiModule = true;
                    this.modules = new LinkedHashSet<String>();
                    continue block16;
                }
            }
            throw new ParseException("Bad option for compile: " + string2);
        }
        if (this.module != null && this.multiModule) {
            throw new ParseException("Bad combination of options: /module=" + this.module + ", /modules");
        }
        if (this.module == null && !this.multiModule) {
            this.modules = Collections.emptySet();
        }
        if (this.timeout < 0) {
            this.timeout = regressionScript.getActionTimeout(-1);
        }
        Locations locations = regressionScript.locations;
        if (this.libLocn == null) {
            this.destDir = this.multiModule ? locations.absTestModulesDir() : locations.absTestClsDir(this.module);
        } else {
            File file = this.destDir = this.module == null ? this.libLocn.absClsDir : new File(this.libLocn.absClsDir, this.module);
        }
        if (!regressionScript.isCheck()) {
            CompileAction.mkdirs(this.destDir);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            File file;
            File file2;
            String string4 = list.get(i);
            if (string4.endsWith(".java")) {
                bl = true;
                file2 = new File(string4.replace('/', File.separatorChar));
                if (!file2.isAbsolute()) {
                    if (this.multiModule) {
                        this.addModule(string4);
                    }
                    if (!(file = locations.absTestSrcFile(this.module, file2)).exists()) {
                        throw new ParseException("Can't find source file: " + string4);
                    }
                    list.set(i, file.getPath());
                }
            } else if (string4.endsWith(".jasm") || string4.endsWith("jcod")) {
                if (this.module != null) {
                    throw new ParseException("Compile option not allowed: ");
                }
                bl2 = true;
                file2 = new File(string4.replace('/', File.separatorChar));
                if (!file2.isAbsolute()) {
                    if (this.multiModule) {
                        this.addModule(string4);
                    }
                    if (!(file = locations.absTestSrcFile(null, file2)).exists()) {
                        throw new ParseException("Can't find source file: " + string4);
                    }
                    list.set(i, file.getPath());
                }
            }
            if (string4.equals("-classpath") || string4.equals("-cp") || string4.equals("--class-path") || string4.startsWith("--class-path=")) {
                if (this.module != null || this.multiModule) {
                    throw new ParseException("Compile option not allowed: ");
                }
                this.classpathp = true;
                if (string4.startsWith("--class-path=")) continue;
                ++i;
                continue;
            }
            if (string4.equals("-sourcepath") || string4.equals("--source-path") || string4.startsWith("--source-path=")) {
                if (this.module != null || this.multiModule) {
                    throw new ParseException("Compile option not allowed: ");
                }
                this.sourcepathp = true;
                if (string4.startsWith("--source-path=")) continue;
                ++i;
                continue;
            }
            if (!string4.equals("-d")) continue;
            throw new ParseException("Compile option not allowed: ");
        }
        if (!(bl || this.process || bl2)) {
            throw new ParseException("No classname ending with `.java' found");
        }
        if (bl2) {
            if (this.sourcepathp || this.classpathp || this.process) {
                throw new ParseException("Compile option not allowed: ");
            }
            if (this.reverseStatus || this.ref != null) {
                throw new ParseException("Compile option not allowed: ");
            }
        }
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (String string : this.args) {
            if (!string.endsWith(".java") && !string.endsWith(".jasm") && !string.endsWith(".jcod")) continue;
            linkedHashSet.add(new File(string));
        }
        return linkedHashSet;
    }

    @Override
    public Set<String> getModules() {
        return this.modules;
    }

    @Override
    public Status run() throws TestRunException {
        Object object;
        this.startAction(true);
        List<String> list = new ArrayList<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = this.process;
        for (String string : this.args) {
            if (string.endsWith(".java")) {
                if (!new File(string).exists()) {
                    throw new TestRunException("Can't find source file: " + string);
                }
                list.add(string);
                bl = true;
                continue;
            }
            if (string.endsWith(".jasm")) {
                arrayList.add(string);
                continue;
            }
            if (string.endsWith(".jcod")) {
                arrayList2.add(string);
                continue;
            }
            list.add(string);
        }
        if (this.script.isCheck()) {
            object = RStatus.passed("Test description appears acceptable");
        } else {
            object = RStatus.passed("Not yet run");
            if (((Status)object).isPassed() && !arrayList.isEmpty()) {
                object = this.jasm(arrayList);
            }
            if (((Status)object).isPassed() && !arrayList2.isEmpty()) {
                object = this.jcod(arrayList2);
            }
            if (((Status)object).isPassed() && bl) {
                if (this.explicitAnnotationProcessingRequested(list = this.getJavacCommandArgs(list)) && !this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC).isEmpty()) {
                    this.othervmOverrideReasons.add("additional runtime exports needed for annotation processing");
                }
                switch (!this.othervmOverrideReasons.isEmpty() ? ExecMode.OTHERVM : this.script.getExecMode()) {
                    case AGENTVM: {
                        this.showMode(ExecMode.AGENTVM);
                        object = this.runAgentJVM(list);
                        break;
                    }
                    case OTHERVM: {
                        this.showMode(ExecMode.OTHERVM, this.othervmOverrideReasons);
                        object = this.runOtherJVM(list);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        this.endAction((Status)object);
        return object;
    }

    private Status jasm(List<String> list) {
        return this.asmtools("jasm", list);
    }

    private Status jcod(List<String> list) {
        return this.asmtools("jcoder", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status asmtools(String string, List<String> list) {
        if (list.isEmpty()) {
            return Status.passed(string + ": no files");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-d");
        arrayList.add(this.destDir.getPath());
        arrayList.addAll(list);
        try {
            String string2 = "org.openjdk.asmtools." + string + ".Main";
            this.recorder.asmtools(string2, arrayList);
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(PrintStream.class, String.class);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            try {
                Object obj = constructor.newInstance(printStream, string);
                Method method = clazz.getMethod(NAME, String[].class);
                Object object = method.invoke(obj, new Object[]{arrayList.toArray(new String[0])});
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    Status status = bl ? Status.passed(string + " OK") : Status.failed(string + " failed");
                    return status;
                }
                Status status = Status.error("unexpected result from " + string + ": " + object.toString());
                return status;
            }
            finally {
                try (PrintWriter printWriter = this.section.createOutput(string);){
                    printWriter.write(byteArrayOutputStream.toString());
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Status.error("can't find " + string);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return Status.error("error invoking " + string + ": " + reflectiveOperationException);
        }
    }

    private List<String> getJavacCommandArgs(List<String> list) throws TestRunException {
        Object object;
        Map<RegressionScript.PathKind, SearchPath> map = this.script.getCompilePaths(this.libLocn, this.multiModule, this.module);
        JDKOpts jDKOpts = new JDKOpts();
        jDKOpts.addAll(this.script.getTestCompilerOptions());
        if (this.isModuleOptionsAllowed(list)) {
            jDKOpts.addAll(this.getExtraModuleConfigOptions(Modules.Phase.STATIC));
        }
        if (this.destDir != null) {
            jDKOpts.add("-d");
            jDKOpts.add(this.destDir.toString());
        }
        if (this.multiModule) {
            jDKOpts.addPath("--module-source-path", map.get((Object)RegressionScript.PathKind.MODULESOURCEPATH));
        } else if (this.module != null) {
            jDKOpts.addAll("--patch-module", this.module + "=" + map.get((Object)RegressionScript.PathKind.SOURCEPATH));
        } else {
            jDKOpts.addPath("--source-path", map.get((Object)RegressionScript.PathKind.SOURCEPATH));
        }
        SearchPath searchPath = map.get((Object)RegressionScript.PathKind.CLASSPATH);
        jDKOpts.addPath("--class-path", searchPath);
        jDKOpts.addPath("--module-path", map.get((Object)RegressionScript.PathKind.MODULEPATH));
        SearchPath searchPath2 = map.get((Object)RegressionScript.PathKind.PATCHPATH);
        jDKOpts.addAllPatchModules(searchPath2);
        if (searchPath2 != null && !searchPath2.isEmpty() && searchPath != null && !searchPath.isEmpty()) {
            object = this.getModules(searchPath2).iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                jDKOpts.add("--add-reads=" + string + "=ALL-UNNAMED");
            }
        }
        if (!(object = this.getModules(map.get((Object)RegressionScript.PathKind.MODULEPATH))).isEmpty()) {
            jDKOpts.add("--add-modules");
            jDKOpts.add(StringUtils.join(object, ","));
        }
        jDKOpts.addAll(list);
        return jDKOpts.toList();
    }

    private boolean isModuleOptionsAllowed(List<String> list) {
        Iterator<String> iterator = list.iterator();
        block8: while (iterator.hasNext()) {
            String string;
            switch (string = iterator.next()) {
                case "-source": 
                case "-target": 
                case "--release": {
                    if (!iterator.hasNext()) continue block8;
                    JDK_Version jDK_Version = JDK_Version.forName(iterator.next());
                    return jDK_Version == null ? false : jDK_Version.compareTo(JDK_Version.V9) >= 0;
                }
            }
            if (!string.startsWith("--release=")) continue;
            JDK_Version jDK_Version = JDK_Version.forName(string.substring(string.indexOf("=") + 1));
            return jDK_Version == null ? false : jDK_Version.compareTo(JDK_Version.V9) >= 0;
        }
        return true;
    }

    private Status runOtherJVM(List<String> list) throws TestRunException {
        Object object3;
        Serializable serializable;
        Map<String, String> map = this.script.getTestProperties();
        Map<String, String> map2 = this.script.getEnvVars();
        String string = this.script.getJavacProg();
        JDKOpts jDKOpts = new JDKOpts();
        jDKOpts.addAll(this.script.getTestVMOptions());
        if (this.addDebugOpts && this.script.getCompileJDK().equals(this.script.getTestJDK())) {
            jDKOpts.addAll(this.script.getTestDebugOptions());
        }
        if (this.explicitAnnotationProcessingRequested(list)) {
            jDKOpts.addAll(this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC));
        }
        List<String> list2 = list;
        if (list.size() >= 10) {
            serializable = this.getArgFile();
            try {
                object3 = new BufferedWriter(new FileWriter((File)serializable));
                Throwable object22 = null;
                try {
                    for (String string2 : list) {
                        ((Writer)object3).write(string2);
                        ((BufferedWriter)object3).newLine();
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object22 != null) {
                            try {
                                ((BufferedWriter)object3).close();
                            }
                            catch (Throwable throwable) {
                                object22.addSuppressed(throwable);
                            }
                        } else {
                            ((BufferedWriter)object3).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                return RStatus.error("Can't write `compile' argument file");
            }
            catch (SecurityException securityException) {
                return RStatus.error("Unable to create `compile' argument file");
            }
            list = Arrays.asList("@" + serializable);
        }
        serializable = new ArrayList();
        serializable.add(string);
        for (String string3 : jDKOpts.toList()) {
            serializable.add("-J" + string3);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            serializable.add("-J-D" + entry.getKey() + "=" + entry.getValue());
        }
        serializable.addAll(list);
        if (showMode) {
            this.showMode(NAME, ExecMode.OTHERVM, this.section);
        }
        if (showCmd) {
            this.showCmd(NAME, (List<String>)((Object)serializable), this.section);
        }
        new ModuleConfig("Boot Layer (javac runtime environment)").setFromOpts(jDKOpts).write(this.configWriter);
        new ModuleConfig("javac compilation environment").setFromOpts(list2).write(this.configWriter);
        this.recorder.javac(map2, string, jDKOpts.toList(), map, list);
        object3 = new ActionHelper.PrintStringWriter();
        ActionHelper.PrintStringWriter printStringWriter = new ActionHelper.PrintStringWriter();
        ProcessCommand processCommand = new ProcessCommand(){

            @Override
            protected Status getStatus(int n, Status status) {
                JDK_Version jDK_Version = CompileAction.this.script.getCompileJDKVersion();
                AStatus aStatus = CompileActionHelper.getStatusForJavacExitCode(jDK_Version, n);
                return new Status(aStatus.getType(), aStatus.getReason());
            }
        };
        TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
        processCommand.setExecDir(this.script.absTestScratchDir()).setCommand((List<String>)((Object)serializable)).setEnvironment(map2).setStreams((PrintWriter)object3, printStringWriter).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
        Status status = RStatus.normalize(processCommand.exec());
        try (Object object = this.section.createOutput("System.out");){
            ((PrintWriter)object).write(((ActionHelper.PrintStringWriter)object3).getOutput());
        }
        object = this.section.createOutput("System.err");
        var14_26 = null;
        try {
            ((PrintWriter)object).write(printStringWriter.getOutput());
        }
        catch (Throwable throwable) {
            var14_26 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (var14_26 != null) {
                    try {
                        ((PrintWriter)object).close();
                    }
                    catch (Throwable throwable) {
                        var14_26.addSuppressed(throwable);
                    }
                } else {
                    ((PrintWriter)object).close();
                }
            }
        }
        status = this.checkReverse(status, this.reverseStatus);
        if (this.ref != null && status.isPassed()) {
            object = ((ActionHelper.PrintStringWriter)object3).getOutput() + printStringWriter.getOutput();
            status = this.checkGoldenFile((String)object, status);
        }
        return status;
    }

    private Status runAgentJVM(List<String> list) throws TestRunException {
        Agent agent;
        Object object;
        Object object2;
        Object object3;
        Map<String, String> map = this.script.getTestProperties();
        if (showMode) {
            this.showMode(NAME, ExecMode.AGENTVM, this.section);
        }
        if (showCmd) {
            this.showCmd(NAME, list, this.section);
        }
        String string = this.script.getJavacProg();
        List<String> list2 = this.script.getTestVMJavaOptions();
        this.recorder.javac(this.script.getEnvVars(), string, list2, map, list);
        try {
            object3 = this.script.getCompileJDK();
            object2 = new SearchPath(((JDK)object3).getJDKClassPath(), this.script.getJavaTestClassPath());
            object = this.addDebugOpts && ((JDK)object3).equals(this.script.getTestJDK()) ? CompileAction.join(this.script.getTestVMOptions(), this.script.getTestDebugOptions()) : this.script.getTestVMOptions();
            agent = this.script.getAgent((JDK)object3, (SearchPath)object2, (List<String>)object);
            this.section.getMessageWriter().println("Agent id: " + agent.getId());
            new ModuleConfig("Boot Layer (javac runtime environment)").setFromOpts(agent.vmOpts).write(this.configWriter);
        }
        catch (Agent.Fault fault) {
            return RStatus.error("Cannot get VM for test: " + fault.getCause());
        }
        object3 = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
        try {
            new ModuleConfig("javac compilation environment").setFromOpts(list).write(this.configWriter);
            object2 = agent.doCompileAction(this.script.getTestResult().getTestName(), map, list, this.timeout, (TimeoutHandler)object3, this.section);
        }
        catch (Agent.Fault fault) {
            object2 = fault.getCause() instanceof IOException ? RStatus.error(String.format("Agent communication error: %s; check console log for any additional details", fault.getCause())) : RStatus.error(String.format("Agent error: %s; check console log for any additional details", fault.getCause()));
        }
        if (((Status)object2).isError()) {
            this.script.closeAgent(agent);
        }
        object2 = this.checkReverse((Status)object2, this.reverseStatus);
        if (this.ref != null && ((Status)object2).isPassed()) {
            object = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT);
            String string2 = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT_LOG);
            String string3 = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDOUT);
            String string4 = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDERR);
            String string5 = (String)object + string2 + string3 + string4;
            object2 = this.checkGoldenFile(string5, (Status)object2);
        }
        return object2;
    }

    private String getOutput(ActionHelper.OutputHandler.OutputKind outputKind) {
        String string = this.section.getOutput(outputKind.name);
        return string == null ? "" : string;
    }

    private boolean explicitAnnotationProcessingRequested(List<String> list) {
        for (String string : list) {
            if (!string.equals("-processor") && !string.equals("-processorpath") && !string.equals("-processormodulepath") && !string.equals("-proc:only") && !string.equals("-Xprint")) continue;
            return true;
        }
        return false;
    }

    private String parseRef(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException("No reference file name");
        }
        File file = new File(this.script.absTestSrcDir(), string);
        if (!file.exists()) {
            throw new ParseException("Can't find reference file: " + file);
        }
        return string;
    }

    private Status checkReverse(Status status, boolean bl) {
        if (!status.isError()) {
            String string;
            boolean bl2 = status.isPassed();
            int n = status.getType();
            if (bl2 && bl) {
                string = "Compilation passed unexpectedly";
                n = 1;
            } else if (bl2 && !bl) {
                string = "Compilation successful";
            } else if (!bl2 && bl) {
                string = "Compilation failed as expected";
                n = 0;
            } else {
                string = "Compilation failed";
            }
            if (n == 1 && status.getReason() != null && !status.getReason().equals("Execution successful")) {
                string = string + ": " + status.getReason();
            }
            status = RStatus.createStatus(n, string);
        }
        return status;
    }

    /*
     * Exception decompiling
     */
    private Status checkGoldenFile(String var1_1, Status var2_2) throws TestRunException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int compareGoldenFile(BufferedReader bufferedReader, BufferedReader bufferedReader2) throws TestRunException {
        try {
            String string;
            String string2;
            int n = 0;
            do {
                string2 = bufferedReader.readLine();
                string = bufferedReader2.readLine();
                ++n;
                if (string2 != null || string != null) continue;
                return 0;
            } while (string2 != null && string != null && string2.equals(string));
            return n;
        }
        catch (IOException iOException) {
            File file = new File(this.script.absTestSrcDir(), this.ref);
            throw new TestRunException("Problem reading reference file: " + file);
        }
    }

    private void addModule(String string) {
        int n = string.indexOf(47);
        if (n > 0) {
            this.modules.add(string.substring(0, n));
        }
    }
}

