/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.AgentServer;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.util.ProcessUtils;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Agent {
    static final boolean showAgent = Flags.get("showAgent");
    static final boolean traceAgent = Flags.get("traceAgent");
    private static final SimpleDateFormat logDateFormat = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss,SSS");
    final JDK jdk;
    final List<String> vmOpts;
    final File scratchDir;
    final Process process;
    final DataInputStream in;
    final DataOutputStream out;
    final AgentServer.KeepAlive keepAlive;
    final int id;
    static int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Agent(File file, JDK jDK, List<String> list, Map<String, String> map, File file2, float f) throws Fault {
        try {
            this.id = count++;
            this.jdk = jDK;
            this.scratchDir = file;
            this.vmOpts = list;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(jDK.getJavaProg().getPath());
            arrayList.addAll(list);
            if (file2 != null) {
                arrayList.add("-Djava.security.policy=" + file2.toURI());
            }
            arrayList.add(AgentServer.class.getName());
            if (file2 != null) {
                arrayList.add("-allowSetSecurityManager");
            }
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(false);
            serverSocket.bind(new InetSocketAddress(0), 1);
            arrayList.add("-port");
            arrayList.add(String.valueOf(serverSocket.getLocalPort()));
            if (f != 1.0f) {
                arrayList.add("-timeoutFactor");
                arrayList.add(String.valueOf(f));
            }
            this.show("Started " + arrayList);
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(file);
            Map<String, String> map2 = processBuilder.environment();
            map2.clear();
            map2.putAll(map);
            this.process = processBuilder.start();
            this.copyStream("stdout", this.process.getInputStream(), System.out);
            this.copyStream("stderr", this.process.getErrorStream(), System.err);
            try {
                int n = (int)(60000.0f * f);
                serverSocket.setSoTimeout(n);
                Socket socket = serverSocket.accept();
                socket.setSoTimeout((int)(120000.0f * f));
                this.in = new DataInputStream(socket.getInputStream());
                this.out = new DataOutputStream(socket.getOutputStream());
            }
            finally {
                serverSocket.close();
            }
            this.keepAlive = new AgentServer.KeepAlive(this.out, traceAgent);
            this.keepAlive.setEnabled(true);
        }
        catch (IOException iOException) {
            throw new Fault(iOException);
        }
    }

    void copyStream(final String string, final InputStream inputStream, final PrintStream printStream) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        Agent.this.log(string + ": " + string2, printStream);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public boolean matches(File file, JDK jDK, List<String> list) {
        return file.getName().equals(this.scratchDir.getName()) && this.jdk.equals(jDK) && this.vmOpts.equals(list);
    }

    public Status doCompileAction(final String string, final Map<String, String> map, final List<String> list, int n, TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        this.trace("doCompileAction " + string + " " + list);
        return this.doAction("doCompileAction", new AgentAction(){

            @Override
            public void send() throws IOException {
                Agent.this.out.writeByte(1);
                Agent.this.out.writeUTF(string);
                Agent.this.writeMap(map);
                Agent.this.writeCollection(list);
                Agent.this.out.flush();
            }
        }, n, timeoutHandler, section);
    }

    public Status doMainAction(final String string, final Map<String, String> map, final Set<String> set, final Set<String> set2, final SearchPath searchPath, final String string2, final List<String> list, int n, TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        this.trace("doMainAction: " + string + " " + searchPath + " " + string2 + " " + list);
        return this.doAction("doMainAction", new AgentAction(){

            @Override
            public void send() throws IOException {
                Agent.this.out.writeByte(2);
                Agent.this.out.writeUTF(string);
                Agent.this.writeMap(map);
                Agent.this.writeCollection(set);
                Agent.this.writeCollection(set2);
                Agent.this.out.writeUTF(searchPath.toString());
                Agent.this.out.writeUTF(string2);
                Agent.this.writeCollection(list);
                Agent.this.out.flush();
            }
        }, n, timeoutHandler, section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status doAction(String string, AgentAction agentAction, int n, final TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        final PrintWriter printWriter = section.getMessageWriter();
        Alarm alarm = Alarm.NONE;
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        if (n > 0) {
            if (timeoutHandler == null) {
                throw new NullPointerException("TimeoutHandler is required");
            }
            this.trace(string + ": scheduling timeout handler in " + n + " seconds");
            alarm = Alarm.schedule(n, TimeUnit.SECONDS, printWriter, new Runnable(){

                @Override
                public void run() {
                    Agent.this.invokeTimeoutHandler(timeoutHandler, countDownLatch, printWriter);
                }
            });
        }
        this.keepAlive.setEnabled(false);
        try {
            Object object = this.out;
            synchronized (object) {
                agentAction.send();
            }
            this.trace(string + ": request sent");
            object = this.readResults(section);
            return object;
        }
        catch (IOException iOException) {
            this.trace(string + ":  error " + iOException);
            throw new Fault(iOException);
        }
        finally {
            alarm.cancel();
            this.keepAlive.setEnabled(true);
            if (alarm.didFire()) {
                this.waitForTimeoutHandler(string, timeoutHandler, countDownLatch);
                throw new Fault(new Exception("Agent " + this.id + " timed out with a timeout of " + n + " seconds"));
            }
        }
    }

    private void invokeTimeoutHandler(final TimeoutHandler timeoutHandler, final CountDownLatch countDownLatch, final PrintWriter printWriter) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Agent.this.trace("timeout handler triggered");
                timeoutHandler.handleTimeout(Agent.this.process);
                try {
                    Agent.this.out.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(printWriter);
                }
                try {
                    Agent.this.in.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(printWriter);
                }
                Agent.this.trace("timeout handler finished");
                countDownLatch.countDown();
            }
        };
        thread.setName("Timeout Handler for Agent " + this.getId());
        thread.start();
    }

    private void waitForTimeoutHandler(String string, TimeoutHandler timeoutHandler, CountDownLatch countDownLatch) {
        this.trace(string + ":  waiting for timeout handler to complete.");
        try {
            if (timeoutHandler.getTimeout() <= 0L) {
                countDownLatch.await();
            } else {
                boolean bl = countDownLatch.await(timeoutHandler.getTimeout() + 10L, TimeUnit.SECONDS);
                if (!bl) {
                    this.trace(string + ": timeout handler did not complete within its own timeout.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.trace(string + ":  interrupted while waiting for timeout handler to complete: " + interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.show("Closing...");
        this.keepAlive.finished();
        try {
            this.out.write(6);
            this.out.close();
        }
        catch (IOException iOException) {
            this.trace("Killing process (" + iOException + ")");
            ProcessUtils.destroyForcibly(this.process);
        }
        PrintWriter printWriter = new PrintWriter(System.err, true);
        Alarm alarm = Alarm.schedulePeriodicInterrupt(60L, TimeUnit.SECONDS, printWriter, Thread.currentThread());
        try {
            int n = this.process.waitFor();
            if (n != 0) {
                this.trace("Exited, process exit code: " + n);
            }
        }
        catch (InterruptedException interruptedException) {
            this.trace("Interrupted while closing");
            this.log("Killing process");
            ProcessUtils.destroyForcibly(this.process);
        }
        finally {
            alarm.cancel();
            Thread.interrupted();
        }
        this.show("Closed");
    }

    void writeCollection(Collection<String> collection) throws IOException {
        this.out.writeShort(collection.size());
        for (String string : collection) {
            this.out.writeUTF(string);
        }
    }

    void writeOptionalString(String string) throws IOException {
        if (string == null) {
            this.out.writeByte(0);
        } else {
            this.out.writeByte(1);
            this.out.writeUTF(string);
        }
    }

    static String readOptionalString(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        return by == 0 ? null : dataInputStream.readUTF();
    }

    void writeMap(Map<String, String> map) throws IOException {
        this.out.writeShort(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.out.writeUTF(entry.getKey());
            this.out.writeUTF(entry.getValue());
        }
    }

    Status readResults(TestResult.Section section) throws IOException {
        byte by;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block5: while ((by = this.in.readByte()) != -1) {
            switch (by) {
                case 3: {
                    String string = this.in.readUTF();
                    String string2 = this.in.readUTF();
                    this.trace("readResults: OUTPUT '" + string + "' '" + string2 + "\"");
                    Object object = (PrintWriter)hashMap.get(string);
                    if (object == null) {
                        object = string.equals(ActionHelper.OutputHandler.OutputKind.LOG.name) ? section.getMessageWriter() : section.createOutput(string);
                        hashMap.put(string, object);
                    }
                    ((PrintWriter)object).write(string2);
                    continue block5;
                }
                case 4: {
                    byte by2 = this.in.readByte();
                    String string2 = this.in.readUTF();
                    this.trace("readResults: STATUS '" + by2 + "' '" + string2 + "\"");
                    for (PrintWriter printWriter : hashMap.values()) {
                        if (printWriter == section.getMessageWriter()) continue;
                        printWriter.close();
                    }
                    Object object = RStatus.createStatus(by2, string2);
                    return object;
                }
                case 5: {
                    continue block5;
                }
            }
            throw new IOException("Agent: unexpected op: " + by);
        }
        throw new EOFException("unexpected EOF");
    }

    public int getId() {
        return this.id;
    }

    private void log(String string, PrintStream printStream) {
        printStream.println("[" + logDateFormat.format(new Date()) + "] Agent[" + this.getId() + "]: " + string);
    }

    private void log(String string) {
        this.log(string, System.err);
    }

    private void show(String string) {
        if (showAgent || traceAgent) {
            this.log(string);
        }
    }

    private void trace(String string) {
        if (traceAgent) {
            this.log(string);
        }
    }

    public static class Pool {
        private static Pool instance;
        private final Map<String, Queue<Agent>> map = new HashMap<String, Queue<Agent>>();
        private File policyFile;
        private float timeoutFactor = 1.0f;

        public static synchronized Pool instance() {
            if (instance == null) {
                instance = new Pool();
            }
            return instance;
        }

        private Pool() {
        }

        public void setSecurityPolicy(File file) {
            this.policyFile = file;
        }

        public void setTimeoutFactor(float f) {
            this.timeoutFactor = f;
        }

        synchronized Agent getAgent(File file, JDK jDK, List<String> list, Map<String, String> map) throws Fault {
            Agent agent;
            Queue<Agent> queue = this.map.get(Pool.getKey(file, jDK, list));
            Agent agent2 = agent = queue == null ? null : queue.poll();
            if (agent == null) {
                agent = new Agent(file, jDK, list, map, this.policyFile, this.timeoutFactor);
            }
            return agent;
        }

        synchronized void save(Agent agent) {
            String string = Pool.getKey(agent.scratchDir, agent.jdk, agent.vmOpts);
            Queue<Agent> queue = this.map.get(string);
            if (queue == null) {
                queue = new LinkedList<Agent>();
                this.map.put(string, queue);
            }
            queue.add(agent);
        }

        public synchronized void flush() {
            for (Queue<Agent> queue : this.map.values()) {
                for (Agent agent : queue) {
                    agent.close();
                }
            }
            this.map.clear();
        }

        synchronized void close(File file) {
            Iterator<Queue<Agent>> iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                Queue<Agent> queue = iterator.next();
                Iterator iterator2 = queue.iterator();
                while (iterator2.hasNext()) {
                    Agent agent = (Agent)iterator2.next();
                    if (!agent.scratchDir.equals(file)) continue;
                    iterator2.remove();
                }
                if (!queue.isEmpty()) continue;
                iterator.remove();
            }
        }

        private static String getKey(File file, JDK jDK, List<String> list) {
            return file.getAbsolutePath() + " " + jDK.getAbsoluteFile() + " " + StringUtils.join(list, " ");
        }
    }

    static interface AgentAction {
        public void send() throws IOException;
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(Throwable throwable) {
            super(throwable);
        }
    }
}

