/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.ActionRecorder;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Action
extends ActionHelper {
    protected static final String FILESEP = System.getProperty("file.separator");
    protected static final String LINESEP = System.getProperty("line.separator");
    protected static final String EXECQUOTE = System.getProperty("os.name").startsWith("Windows") ? "\"" : "";
    public static final String REASON_ASSUMED_ACTION = "ASSUMED_ACTION";
    public static final String REASON_USER_SPECIFIED = "USER_SPECIFIED";
    public static final String REASON_ASSUMED_BUILD = "ASSUMED_BUILD";
    public static final String REASON_FILE_TOO_OLD = "FILE_OUT_OF_DATE";
    protected static final String SREASON_ASSUMED_ACTION = "Assumed action based on file name: run ";
    protected static final String SREASON_USER_SPECIFIED = "User specified action: run ";
    protected static final String SREASON_ASSUMED_BUILD = "Named class compiled on demand";
    protected static final String SREASON_FILE_TOO_OLD = ".class file out of date or does not exist";
    protected static final String PARSE_TIMEOUT_NONE = "No timeout value";
    protected static final String PARSE_TIMEOUT_BAD_INT = "Bad integer specification: ";
    protected static final String PARSE_FAIL_UEXPECT = "Unexpected value for `fail': ";
    protected static final String PARSE_MODULE_NONE = "No module name";
    protected static final String PARSE_MODULE_INVALID = "Invalid module name";
    protected static final String PARSE_BAD_OPT_JDK = "Option not allowed using provided test JDK: ";
    protected static final String PARSE_NO_POLICY_NAME = "No policy file name";
    protected static final String PARSE_CANT_FIND_POLICY = "Can't find policy file: ";
    protected static final String PARSE_NO_SECURE_NAME = "No security manager file name";
    protected static final String PARSE_POLICY_OTHERVM = "`/policy' and `/java.security.policy` require use of `/othervm'";
    protected static final String PARSE_SECURE_OTHERVM = "`/secure' requires use of `/othervm'";
    protected static final String PARSE_TIMEOUT_MANUAL = "`/manual' disables use of `/timeout'";
    protected static final String POLICY_WRITE_PROB = "Problems writing new policy file: ";
    protected static final String POLICY_SM_PROB = "Unable to create new policy file: ";
    protected static final String LOG_COMMAND = "command: ";
    protected static final String LOG_RESULT = " result: ";
    protected static final String LOG_JT_COMMAND = "JavaTest command: ";
    protected static final String LOG_REASON = "reason: ";
    protected static final String LOG_ELAPSED_TIME = "elapsed time (seconds): ";
    protected static final String EXEC_FAIL = "Execution failed";
    protected static final String EXEC_FAIL_EXPECT = "Execution failed as expected";
    protected static final String EXEC_PASS_UNEXPECT = "Execution passed unexpectedly";
    protected static final String CHECK_PASS = "Test description appears acceptable";
    protected static final String AGENTVM_CANT_GET_VM = "Cannot get VM for test";
    protected static final String AGENTVM_IO_EXCEPTION = "Agent communication error: %s; check console log for any additional details";
    protected static final String AGENTVM_EXCEPTION = "Agent error: %s; check console log for any additional details";
    protected static final String CANT_FIND_SRC = "Can't find source file: ";
    protected static final String APPLET_ONE_ARG_REQ = "`applet' requires exactly one file argument";
    protected static final String APPLET_BAD_VAL_MANUAL = "Bad value for `manual' option: ";
    protected static final String APPLET_BAD_OPT = "Bad option for applet: ";
    protected static final String APPLET_CANT_FIND_HTML = "Can't find HTML file: ";
    protected static final String APPLET_HTML_READ_PROB = "Problem reading HTML file: ";
    protected static final String APPLET_MISS_ENDBODY = "No </body> tag in ";
    protected static final String APPLET_MISS_APPLET = "No <applet> tag in ";
    protected static final String APPLET_MISS_ENDAPPLET = "No </applet> tag in ";
    protected static final String APPLET_MISS_REQ_ATTRIB = " missing required attribute ";
    protected static final String APPLET_ARCHIVE_USUPP = "`archive' not supported in file: ";
    protected static final String APPLET_MISS_REQ_PARAM = "Missing required name or value for param in <param> tag";
    protected static final String APPLET_CANT_WRITE_ARGS = "Can't write `applet' argument file";
    protected static final String APPLET_SECMGR_FILEOPS = "Unable to create applet argument file";
    protected static final String APPLET_USER_EVAL = ", user evaluated";
    protected static final String APPLET_MANUAL_TEST = "Manual test";
    protected static final String BUILD_UNEXPECT_OPT = "Unexpected options for `build'";
    protected static final String BUILD_NO_CLASSNAME = "No classname(s) provided for `build'";
    protected static final String BUILD_BAD_CLASSNAME = "Bad classname provided for `build': ";
    protected static final String BUILD_NO_COMP_NEED = "No need to compile: ";
    protected static final String BUILD_UP_TO_DATE = "All files up to date";
    protected static final String BUILD_SUCC = "Build successful";
    protected static final String BUILD_LIB_LIST = " in directory-list: ";
    protected static final String BUILD_FUTURE_SOURCE = "WARNING: file %s has a modification time in the future: %s";
    protected static final String BUILD_FUTURE_SOURCE_2 = "Unexpected results may occur";
    protected static final String CLEAN_SUCC = "Clean successful";
    protected static final String CLEAN_UNEXPECT_OPT = "Unexpected option(s) for `clean'";
    protected static final String CLEAN_NO_CLASSNAME = "No classname(s) provided for `clean'";
    protected static final String CLEAN_BAD_CLASSNAME = "Bad classname provided for `clean': ";
    protected static final String CLEAN_RM_FAILED = "`clean' unable to delete file: ";
    protected static final String CLEAN_SECMGR_PROB = "Problem deleting directory contents: ";
    protected static final String COMPILE_NO_CLASSNAME = "No classname provided for `compile'";
    protected static final String COMPILE_NO_DOT_JAVA = "No classname ending with `.java' found";
    protected static final String COMPILE_BAD_OPT = "Bad option for compile: ";
    protected static final String COMPILE_OPT_DISALLOW = "Compile option not allowed: ";
    protected static final String COMPILE_NO_REF_NAME = "No reference file name";
    protected static final String COMPILE_CANT_FIND_REF = "Can't find reference file: ";
    protected static final String COMPILE_CANT_READ_REF = "Can't read reference file: ";
    protected static final String COMPILE_GOLD_FAIL = "Output does not match reference file: ";
    protected static final String COMPILE_GOLD_LINE = ", line ";
    protected static final String COMPILE_GOLD_READ_PROB = "Problem reading reference file: ";
    protected static final String COMPILE_MODULES_UEXPECT = "Unexpected value for `modules': ";
    protected static final String COMPILE_CANT_CREATE_ARG_FILE = "Can't create `compile' argument file";
    protected static final String COMPILE_CANT_WRITE_ARGS = "Can't write `compile' argument file";
    protected static final String COMPILE_SECMGR_FILEOPS = "Unable to create `compile' argument file";
    protected static final String COMPILE_PASS_UNEXPECT = "Compilation passed unexpectedly";
    protected static final String COMPILE_PASS = "Compilation successful";
    protected static final String COMPILE_FAIL_EXPECT = "Compilation failed as expected";
    protected static final String COMPILE_FAIL = "Compilation failed";
    protected static final String COMPILE_CANT_RESET_SECMGR = "Cannot reset security manager";
    protected static final String COMPILE_CANT_RESET_PROPS = "Cannot reset system properties";
    protected static final String IGNORE_UNEXPECT_OPTS = "Unexpected option(s) for `ignore'";
    protected static final String IGNORE_TEST_IGNORED = "Test ignored";
    protected static final String IGNORE_TEST_IGNORED_C = "Test ignored: ";
    protected static final String IGNORE_TEST_SUPPRESSED = "@ignore suppressed by command line option";
    protected static final String IGNORE_TEST_SUPPRESSED_C = "@ignore suppressed by command line option: ";
    protected static final String JUNIT_NO_CLASSNAME = "No class provided for `junit'";
    protected static final String JUNIT_BAD_MAIN_ARG = "Bad argument provided for class in `junit'";
    protected static final String DRIVER_NO_CLASSNAME = "No class provided for `driver'";
    protected static final String DRIVER_UNEXPECT_VMOPT = "VM options not allowed";
    protected static final String DRIVER_BAD_OPT = "Bad option for driver: ";
    protected static final String MAIN_NO_CLASSNAME = "No class provided for `main'";
    protected static final String MAIN_MANUAL_NO_VAL = "Arguments to `manual' option not supported: ";
    protected static final String MAIN_BAD_OPT = "Bad option for main: ";
    protected static final String MAIN_CANT_FIND_SECURE = "Can't find security manager file name: ";
    protected static final String MAIN_BAD_OPT_JDK = "Option not allowed using provided test JDK: ";
    protected static final String MAIN_NO_POLICY_NAME = "No policy file name";
    protected static final String MAIN_CANT_FIND_POLICY = "Can't find policy file: ";
    protected static final String MAIN_POLICY_OTHERVM = "`/policy' requires use of `/othervm'";
    protected static final String MAIN_NO_SECURE_NAME = "No security manager file name";
    protected static final String MAIN_SECURE_OTHERVM = "`/secure' requires use of `/othervm'";
    protected static final String MAIN_UNEXPECT_VMOPT = ": vm option(s) found, need to specify /othervm";
    protected static final String MAIN_POLICY_WRITE_PROB = "Problems writing new policy file: ";
    protected static final String MAIN_POLICY_SM_PROB = "Unable to create new policy file: ";
    protected static final String MAIN_CANT_RESET_SECMGR = "Cannot reset security manager";
    protected static final String MAIN_CANT_RESET_PROPS = "Cannot reset system properties";
    protected static final String MAIN_NO_NATIVES = "Use -nativepath to specify the location of native code";
    protected static final String MAIN_CANT_WRITE_ARGS = "Can't write `main' argument file";
    protected static final String MAIN_SECMGR_FILEOPS = "Unable to create `main' argument file";
    protected static final String SHELL_NO_SCRIPT_NAME = "No script name provided for `shell'";
    protected static final String SHELL_MANUAL_NO_VAL = "Arguments to `manual' option not supported: ";
    protected static final String SHELL_BAD_OPTION = "Bad option for shell: ";
    protected Map<String, String> opts;
    protected List<String> args;
    protected String reason;
    protected RegressionScript script;
    protected TestResult.Section section;
    protected ActionRecorder recorder;
    protected PrintWriter configWriter;
    private long startTime;
    protected static final boolean showCmd = Flags.get("showCmd");
    protected static final boolean showMode = Flags.get("showMode");
    protected static final boolean showJDK = Flags.get("showJDK");

    public abstract String getName();

    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        this.opts = map;
        this.args = list;
        this.reason = string;
        this.script = regressionScript;
    }

    public abstract Status run() throws TestRunException;

    public Set<File> getSourceFiles() {
        return null;
    }

    public Set<String> getModules() {
        return Collections.emptySet();
    }

    protected Map<String, String> getEnvVars(boolean bl) {
        File file;
        Map<String, String> map = this.script.getEnvVars();
        if (bl && (file = this.script.getNativeDir()) != null) {
            String string;
            map = new LinkedHashMap<String, String>(map);
            OS oS = OS.current();
            switch (oS.family) {
                case "aix": 
                case "os400": {
                    string = "LIBPATH";
                    break;
                }
                case "mac": {
                    string = "DYLD_LIBRARY_PATH";
                    break;
                }
                case "windows": {
                    string = "PATH";
                    break;
                }
                default: {
                    string = "LD_LIBRARY_PATH";
                }
            }
            String string2 = map.get(string);
            if (string2 == null) {
                map.put(string, file.getPath());
            } else {
                map.put(string, string2 + File.pathSeparator + file.getPath());
            }
            map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    static synchronized void mkdirs(File file) {
        file.mkdirs();
    }

    public File getArgFile() {
        File file = this.script.absTestWorkFile(this.getName() + "." + this.script.getNextSerial() + ".jta");
        file.getParentFile().mkdirs();
        return file;
    }

    protected int parseTimeout(String string) throws ParseException {
        if (string == null) {
            throw new ParseException(PARSE_TIMEOUT_NONE);
        }
        try {
            return this.script.getActionTimeout(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(PARSE_TIMEOUT_BAD_INT + string);
        }
    }

    protected boolean parseFail(String string) throws ParseException {
        if (string != null) {
            throw new ParseException(PARSE_FAIL_UEXPECT + string);
        }
        return true;
    }

    protected String parseModule(String string) throws ParseException {
        if (string == null) {
            throw new ParseException(PARSE_MODULE_NONE);
        }
        if (!this.isQualifiedName(string)) {
            throw new ParseException(PARSE_MODULE_INVALID + string);
        }
        return string;
    }

    private boolean isQualifiedName(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (!Character.isJavaIdentifierStart(c)) {
                    return false;
                }
                bl = false;
                continue;
            }
            if (c == '.') {
                bl = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return !bl;
    }

    protected String addGrantEntry(String string) throws TestRunException {
        File file = new File(this.script.absTestScratchDir(), new File(string).getName() + "_new");
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("// The following grant entries were added by jtreg.  Do not edit." + LINESEP);
            fileWriter.write("grant {" + LINESEP);
            fileWriter.write("    permission java.io.FilePermission \"" + this.script.absTestClsTopDir().getPath().replace(FILESEP, "{/}") + "${/}-\", \"read\";" + LINESEP);
            fileWriter.write("};" + LINESEP);
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.addAll(this.script.getJavaTestClassPath().asList());
            if (this.script.isJUnitRequired()) {
                arrayList.addAll(this.script.getJUnitPath().asList());
            }
            if (this.script.isTestNGRequired()) {
                arrayList.addAll(this.script.getTestNGPath().asList());
            }
            for (File serializable2 : arrayList) {
                fileWriter.write("grant codebase \"" + serializable2.toURI() + "\" {" + LINESEP);
                fileWriter.write("    permission java.security.AllPermission;" + LINESEP);
                fileWriter.write("};" + LINESEP);
            }
            fileWriter.write(LINESEP);
            fileWriter.write("// original policy file:" + LINESEP);
            fileWriter.write("// " + string + LINESEP);
            Throwable throwable = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
                String throwable2;
                while ((throwable2 = bufferedReader.readLine()) != null) {
                    fileWriter.write(throwable2 + LINESEP);
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            throw new TestRunException("Problems writing new policy file: " + file.toString());
        }
        catch (SecurityException securityException) {
            throw new TestRunException("Unable to create new policy file: " + file.toString());
        }
        return file.toString();
    }

    protected String parsePolicy(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException("No policy file name");
        }
        File file = new File(this.script.absTestSrcDir(), string);
        if (!file.exists()) {
            throw new ParseException("Can't find policy file: " + file);
        }
        return file.toString();
    }

    protected String parseSecure(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException("No security manager file name");
        }
        return string;
    }

    protected void startAction(boolean bl) {
        String string = this.getName();
        this.section = this.script.getTestResult().createSection(string);
        PrintWriter printWriter = this.section.getMessageWriter();
        printWriter.println(LOG_COMMAND + string + " " + StringUtils.join(this.args, " "));
        printWriter.println(LOG_REASON + this.reason);
        this.recorder = new ActionRecorder(this);
        if (bl) {
            this.configWriter = this.section.createOutput("configuration");
        }
        this.startTime = new Date().getTime();
    }

    protected void endAction(Status status) {
        long l = new Date().getTime() - this.startTime;
        PrintWriter printWriter = this.section.getMessageWriter();
        printWriter.println(LOG_ELAPSED_TIME + (double)l / 1000.0);
        this.recorder.close();
        this.section.setStatus(status);
    }

    protected void showCmd(String string, String[] stringArray, TestResult.Section section) {
        this.showCmd(string, Arrays.asList(stringArray), section);
    }

    protected void showCmd(String string, List<String> list, TestResult.Section section) {
        PrintWriter printWriter = section.getMessageWriter();
        printWriter.println(LOG_JT_COMMAND + string);
        for (String string2 : list) {
            printWriter.print("'" + string2 + "' ");
        }
        printWriter.println();
    }

    protected void showMode(String string, ExecMode execMode, TestResult.Section section) {
        PrintWriter printWriter = section.getMessageWriter();
        printWriter.println("MODE: " + (Object)((Object)execMode));
    }

    protected void showMode(ExecMode execMode) {
        this.showMode(execMode, null);
    }

    protected void showMode(ExecMode execMode, Set<String> set) {
        PrintWriter printWriter = this.section.getMessageWriter();
        printWriter.print("Mode: " + execMode.name().toLowerCase());
        if (set != null && !set.isEmpty()) {
            printWriter.print(" ");
            printWriter.print(set);
        }
        printWriter.println();
    }

    String[] quoteBackslash(String[] stringArray) {
        String string = "\\";
        String[] stringArray2 = new String[stringArray.length];
        if (System.getProperty("file.separator").equals(string)) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < string2.length(); ++j) {
                    String string3 = String.valueOf(string2.charAt(j));
                    stringBuilder.append(string3);
                    if (!string3.equals(string)) continue;
                    stringBuilder.append(string3);
                }
                stringArray2[i] = stringBuilder.toString();
            }
        } else {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    String singleQuoteString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'").append(string).append("'");
        return stringBuilder.toString();
    }

    protected static <T> List<T> join(List<T> list, List<T> list2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    Set<String> getModules(SearchPath searchPath) {
        if (searchPath == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (File file : searchPath.asList()) {
            this.getModules(file, linkedHashSet);
        }
        return linkedHashSet;
    }

    private void getModules(File file, Set<String> set) {
        for (File file2 : file.listFiles()) {
            if (this.isModule(file2)) {
                set.add(file2.getName());
                continue;
            }
            if (!file2.getName().endsWith(".jar")) continue;
            set.add(this.getAutomaticModuleName(file2));
        }
    }

    private boolean isModule(File file) {
        if (file.isDirectory()) {
            if (this.script.systemModules.contains(file.getName())) {
                return true;
            }
            if (new File(file, "module-info.class").exists()) {
                return true;
            }
            if (new File(file, "module-info.java").exists()) {
                return true;
            }
        }
        return false;
    }

    private String getAutomaticModuleName(File file) {
        String string = file.getName();
        String string2 = string.substring(0, string.length() - 4);
        Object var4_4 = null;
        Matcher matcher = Pattern.compile("-(\\d+(\\.|$))").matcher(string2);
        if (matcher.find()) {
            int n = matcher.start();
            string2 = string2.substring(0, n);
        }
        string2 = string2.replaceAll("[^A-Za-z0-9]", ".").replaceAll("(\\.)(\\1)+", ".").replaceAll("^\\.", "").replaceAll("\\.$", "");
        return string2;
    }

    protected List<String> getExtraModuleConfigOptions(Modules.Phase phase) {
        Object object2;
        if (!this.script.getTestJDK().hasModules()) {
            return Collections.emptyList();
        }
        Modules modules = this.script.getModules();
        boolean bl = false;
        LinkedHashSet<String> linkedHashSet = null;
        for (Object object2 : modules) {
            Object object3 = ((Modules.Entry)object2).moduleName;
            if (((Modules.Entry)object2).needAddExports()) {
                bl = true;
            }
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet<String>();
            }
            linkedHashSet.add((String)object3);
        }
        if (!bl && linkedHashSet == null) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        if (linkedHashSet != null) {
            arrayList.add("--add-modules");
            arrayList.add(StringUtils.join(linkedHashSet, ","));
        }
        for (Object object3 : modules) {
            if (((Modules.Entry)object3).packageName == null) continue;
            if (((Modules.Entry)object3).addExports) {
                arrayList.add("--add-exports");
                arrayList.add(((Modules.Entry)object3).moduleName + "/" + ((Modules.Entry)object3).packageName + "=ALL-UNNAMED");
            }
            if (!((Modules.Entry)object3).addOpens || phase != Modules.Phase.DYNAMIC) continue;
            arrayList.add("--add-opens");
            arrayList.add(((Modules.Entry)object3).moduleName + "/" + ((Modules.Entry)object3).packageName + "=ALL-UNNAMED");
        }
        object2 = this.section.getMessageWriter();
        ((PrintWriter)object2).println("Additional options from @modules: " + StringUtils.join(arrayList, " "));
        return arrayList;
    }

    protected boolean includesOption(String string, String string2, List<String> list) {
        boolean bl = false;
        for (String string3 : list) {
            if (string3.equals(string + "=" + string2)) {
                return true;
            }
            if (string3.equals(string)) {
                bl = true;
                continue;
            }
            if (bl && string3.equals(string2)) {
                return true;
            }
            bl = false;
        }
        return false;
    }
}

