/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.config.GroupManager;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class TestManager {
    private final TestFinder.ErrorHandler errHandler;
    private final PrintWriter out;
    private final File baseDir;
    private File reportDir;
    private File workDir;
    boolean allowEmptyGroups = true;
    Map<File, Entry> map = new TreeMap<File, Entry>();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestManager.class);

    public TestManager(PrintWriter printWriter, File file, TestFinder.ErrorHandler errorHandler) {
        this.out = printWriter;
        this.baseDir = file.getAbsoluteFile();
        this.errHandler = errorHandler;
    }

    public void addTestFiles(Collection<File> collection, boolean bl) throws Main.Fault {
        HashMap<File, File> hashMap = new HashMap<File, File>();
        for (File file : collection) {
            this.addTest(hashMap, file, null, bl);
        }
    }

    public void addTestFileIds(Collection<FileId> collection, boolean bl) throws Main.Fault {
        HashMap<File, File> hashMap = new HashMap<File, File>();
        for (FileId fileId : collection) {
            this.addTest(hashMap, fileId.file, fileId.id, bl);
        }
    }

    private void addTest(Map<File, File> map, File file, String string, boolean bl) throws Main.Fault {
        File file2 = this.canon(file);
        if (!file2.exists()) {
            throw new Main.Fault(i18n, "tm.cantFindFile", file);
        }
        File file3 = this.getRootDir(map, file2);
        if (file3 == null) {
            throw new Main.Fault(i18n, "tm.cantDetermineTestSuite", file);
        }
        Entry entry = this.getEntry(file3);
        if (file.equals(file3)) {
            entry.all = true;
            entry.files.clear();
        } else if (!entry.all) {
            entry.files.put(TestManager.getRelativePath(file3, file2, string), bl);
        }
    }

    public void addGroups(Collection<String> collection) throws Main.Fault {
        for (String string : collection) {
            int n = string.lastIndexOf(":");
            if (n == -1) {
                throw new Main.Fault(i18n, "tm.badGroupSpec", string);
            }
            File file = this.canon(n == 0 ? this.baseDir : new File(string.substring(0, n)));
            if (!new File(file, "TEST.ROOT").exists()) {
                throw new Main.Fault(i18n, "tm.badGroupTestSuite", string);
            }
            Entry entry = this.getEntry(file);
            entry.groups.add(string.substring(n + 1));
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isMultiRun() {
        return this.map.size() > 1;
    }

    public Set<RegressionTestSuite> getTestSuites() throws Main.Fault {
        LinkedHashSet<RegressionTestSuite> linkedHashSet = new LinkedHashSet<RegressionTestSuite>();
        for (Entry entry : this.map.values()) {
            if (entry.testSuite == null) {
                try {
                    entry.testSuite = RegressionTestSuite.open(entry.rootDir, this.errHandler);
                    if (!entry.testSuite.getRootDir().equals(entry.rootDir)) {
                        System.err.println("e.testSuite.getRootDir(): " + entry.testSuite.getRootDir());
                        System.err.println("e.rootDir: " + entry.rootDir);
                        System.err.println(entry.testSuite.getRootDir().equals(entry.rootDir));
                        throw new AssertionError();
                    }
                }
                catch (TestSuite.Fault fault) {
                    throw new Main.Fault(i18n, "tm.cantOpenTestSuite", entry.testSuite, fault);
                }
            }
            linkedHashSet.add(entry.testSuite);
        }
        return linkedHashSet;
    }

    public void setWorkDirectory(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        if (this.workDir != null) {
            throw new IllegalStateException();
        }
        this.workDir = file;
    }

    public File getWorkDirectory() {
        if (this.workDir == null) {
            throw new IllegalStateException();
        }
        return this.workDir;
    }

    public WorkDirectory getWorkDirectory(RegressionTestSuite regressionTestSuite) throws Main.Fault {
        Entry entry = this.map.get(regressionTestSuite.getRootDir());
        if (entry == null) {
            throw new IllegalStateException();
        }
        if (entry.workDir == null) {
            if (entry.subdir == null && this.isMultiRun()) {
                this.initSubdirs();
            }
            File file = entry.subdir == null ? this.workDir : new File(this.workDir, entry.subdir);
            try {
                entry.workDir = WorkDirectory.isWorkDirectory(file) ? WorkDirectory.open(file, regressionTestSuite) : (file.exists() ? WorkDirectory.convert(file, regressionTestSuite) : WorkDirectory.create(file, regressionTestSuite));
            }
            catch (WorkDirectory.Fault fault) {
                throw new Main.Fault(i18n, "tm.cantRead", file.getName(), fault);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Main.Fault(i18n, "tm.cantRead", file.getName(), fileNotFoundException);
            }
        }
        return entry.workDir;
    }

    public void setReportDirectory(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        if (this.reportDir != null) {
            throw new IllegalStateException();
        }
        this.reportDir = file;
    }

    public File getReportDirectory() {
        if (this.reportDir == null) {
            throw new IllegalStateException();
        }
        return this.reportDir;
    }

    public File getReportDirectory(RegressionTestSuite regressionTestSuite) throws Main.Fault {
        Entry entry = this.map.get(regressionTestSuite.getRootDir());
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (this.reportDir != null && entry.reportDir == null) {
            if (entry.subdir == null && this.isMultiRun()) {
                this.initSubdirs();
            }
            entry.reportDir = entry.subdir == null ? this.reportDir : new File(this.reportDir, entry.subdir);
        }
        return entry.reportDir;
    }

    String getSubdirectory(RegressionTestSuite regressionTestSuite) throws Main.Fault {
        if (this.map.size() <= 1) {
            return null;
        }
        Entry entry = this.map.get(regressionTestSuite.getRootDir());
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (entry.subdir == null) {
            this.initSubdirs();
        }
        return entry.subdir;
    }

    public Set<String> getTests(RegressionTestSuite regressionTestSuite) throws Main.Fault {
        String string;
        Entry entry = this.map.get(regressionTestSuite.getRootDir());
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (entry.all) {
            return null;
        }
        WorkDirectory workDirectory = this.getWorkDirectory(regressionTestSuite);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Boolean> object : entry.files.entrySet()) {
            string = object.getKey();
            boolean bl = object.getValue();
            if (this.validatePath(workDirectory, string)) {
                linkedHashSet.add(string);
                continue;
            }
            if (bl) continue;
            throw new Main.Fault(i18n, "tm.notATest", string);
        }
        for (File file : this.expandGroups(entry)) {
            string = TestManager.getRelativePath(entry.rootDir, file, null);
            if (!this.validatePath(workDirectory, string)) continue;
            linkedHashSet.add(string);
        }
        if (linkedHashSet.isEmpty() && (!this.allowEmptyGroups || entry.groups.isEmpty())) {
            throw new NoTests();
        }
        return linkedHashSet;
    }

    private boolean validatePath(WorkDirectory workDirectory, String string) {
        try {
            TestResultTable testResultTable = workDirectory.getTestResultTable();
            if (testResultTable.validatePath(string)) {
                if (string.matches("(?i).*#[a-z0-9]+")) {
                    return true;
                }
                File file = workDirectory.getTestSuite().getRootDir();
                File file2 = new File(file, string);
                if (file2.isDirectory()) {
                    return true;
                }
                TestResultTable.TreeIterator treeIterator = testResultTable.getIterator(new String[]{string}, null);
                while (treeIterator.hasNext()) {
                    TestResult testResult = treeIterator.next();
                    String string2 = testResult.getDescription().getRootRelativePath();
                    if (!string.equals(string2)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (TestResult.Fault fault) {
            return false;
        }
    }

    public Set<String> getGroups(RegressionTestSuite regressionTestSuite) throws Main.Fault {
        Entry entry = this.map.get(regressionTestSuite.getRootDir());
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        return entry.groups;
    }

    private Entry getEntry(File file) {
        Entry entry = this.map.get(file);
        if (entry == null) {
            entry = new Entry(file);
            this.map.put(file, entry);
        }
        return entry;
    }

    private File getRootDir(Map<File, File> map, File file) {
        if (file == null) {
            return null;
        }
        if (file.isFile()) {
            return this.getRootDir(map, file.getParentFile());
        }
        File file2 = map.get(file);
        if (file2 == null) {
            file2 = new File(file, "TEST.ROOT").exists() ? file : this.getRootDir(map, file.getParentFile());
            map.put(file, file2);
        }
        return file2;
    }

    private void initSubdirs() throws Main.Fault {
        String string;
        if (WorkDirectory.isWorkDirectory(this.workDir)) {
            throw new Main.Fault(i18n, "tm.workDirNotSuitableInMultiTestSuiteMode", new Object[0]);
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (this.workDir.exists()) {
            if (!this.workDir.isDirectory()) {
                throw new Main.Fault(i18n, "tm.notADirectory", this.workDir);
            }
            for (File file : this.workDir.listFiles()) {
                File file2;
                Entry entry;
                string = file.getName();
                hashSet.add(string);
                if (!WorkDirectory.isUsableWorkDirectory(file) || (entry = this.map.get(file2 = this.getTestSuiteForWorkDirectory(file))) == null) continue;
                entry.subdir = string;
            }
        }
        for (Entry entry : this.map.values()) {
            if (entry.subdir != null) continue;
            String string2 = entry.rootDir.getName();
            if (entry.rootDir.getParentFile() != null) {
                string2 = entry.rootDir.getParentFile().getName() + "_" + string2;
            }
            if (hashSet.contains(string2)) {
                int n = 0;
                while (hashSet.contains(string = string2 + "_" + n)) {
                    ++n;
                }
                string2 = string;
            }
            entry.subdir = string2;
            hashSet.add(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getTestSuiteForWorkDirectory(File file) {
        File file3 = new File(new File(file, "jtData"), "testsuite");
        try (FileInputStream fileInputStream = new FileInputStream(file3);){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string = properties.getProperty("root");
            if (string == null) return new File("__UNKNOWN__");
            File file2 = new File(string);
            return file2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new File("__UNKNOWN__");
    }

    private Set<File> expandGroups(Entry entry) throws Main.Fault {
        try {
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            GroupManager groupManager = entry.testSuite.getGroupManager(this.out);
            for (String string : entry.groups) {
                try {
                    linkedHashSet.addAll(groupManager.getFiles(string));
                }
                catch (GroupManager.InvalidGroup invalidGroup) {
                    throw new Main.Fault(i18n, "tm.invalidGroup", string);
                }
            }
            return linkedHashSet;
        }
        catch (IOException iOException) {
            throw new Main.Fault(i18n, "tm.cantReadGroups", entry.testSuite.getRootDir(), iOException);
        }
    }

    File canon(File file) {
        File file2 = file.isAbsolute() ? file : new File(this.baseDir, file.getPath());
        try {
            return file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            return TestManager.getNormalizedFile(file2);
        }
    }

    static File getNormalizedFile(File file) {
        return new File(file.getAbsoluteFile().toURI().normalize());
    }

    static String getRelativePath(File file, File file2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (file2 != null) {
            if (file2.equals(file)) {
                if (string != null) {
                    stringBuilder.append("#").append(string);
                }
                return stringBuilder.toString();
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '/');
            }
            stringBuilder.insert(0, file2.getName());
            file2 = file2.getParentFile();
        }
        return null;
    }

    public static class FileId {
        final File file;
        final String id;

        public FileId(File file, String string) {
            this.file = file;
            this.id = string;
        }
    }

    private class Entry {
        final File rootDir;
        boolean all = false;
        Map<String, Boolean> files = new LinkedHashMap<String, Boolean>();
        Set<String> groups = new LinkedHashSet<String>();
        RegressionTestSuite testSuite;
        String subdir;
        WorkDirectory workDir;
        File reportDir;

        Entry(File file) {
            this.rootDir = file;
        }
    }

    public class NoTests
    extends Main.Fault {
        private static final long serialVersionUID = 1L;

        public NoTests() {
            super(i18n, "tm.noTests", new Object[0]);
        }
    }
}

