/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.config.Expr;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.RegressionParameters;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RegressionContext
implements Expr.Context {
    private static final String VM_PREFIX = "-XX:";
    private static final String ON_PREFIX = "-XX:+";
    private static final String OFF_PREFIX = "-XX:-";
    private static final String GC_PREFIX = "-XX:+Use";
    private static final String GC_SUFFIX = "GC";
    private static final String MODE_MIXED = "Xmixed";
    private static final String MODE_INT = "Xint";
    private static final String MODE_COMP = "Xcomp";
    private final RegressionParameters params;
    private final Map<String, String> values;
    private final Set<String> validPropNames;

    static RegressionContext getDefault() {
        try {
            return new RegressionContext(null);
        }
        catch (JDK.Fault fault) {
            throw new IllegalStateException();
        }
    }

    RegressionContext(RegressionParameters regressionParameters) throws JDK.Fault {
        OS oS;
        JDK_Version jDK_Version;
        this.params = regressionParameters;
        this.validPropNames = null;
        this.values = new HashMap<String, String>();
        this.values.put("null", "null");
        if (regressionParameters == null) {
            jDK_Version = null;
            oS = OS.current();
        } else {
            JDK jDK = regressionParameters.getTestJDK();
            Properties properties = jDK.getProperties(regressionParameters);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.values.put((String)entry.getKey(), (String)entry.getValue());
            }
            jDK_Version = JDK_Version.forName(properties.getProperty("java.specification.version"));
            oS = OS.forProps(properties);
        }
        this.values.put("jdk.version", jDK_Version != null ? jDK_Version.name() : "unknown");
        this.values.put("jdk.version.major", jDK_Version != null ? String.valueOf(jDK_Version.major) : "0");
        this.values.put("os.name", oS.name);
        this.values.put("os.arch", oS.arch);
        this.values.put("os.simpleArch", oS.simple_arch);
        this.values.put("os.version", oS.version);
        this.values.put("os.simpleVersion", oS.simple_version);
        this.values.put("os.family", oS.family);
        this.values.put("os.processors", String.valueOf(oS.processors));
        this.values.put("os.maxMemory", String.valueOf(oS.maxMemory));
        this.values.put("os.maxSwap", String.valueOf(oS.maxSwap));
        this.processVMOptions(regressionParameters == null ? Collections.emptyList() : regressionParameters.getTestVMJavaOptions());
    }

    RegressionContext(RegressionContext regressionContext, Set<String> set) {
        this.params = regressionContext.params;
        this.values = regressionContext.values;
        this.validPropNames = set;
    }

    @Override
    public boolean isValidName(String string) {
        if (this.validPropNames == null) {
            return true;
        }
        if (this.values.containsKey(string)) {
            return true;
        }
        if (string.startsWith("vm.opt.")) {
            return true;
        }
        return this.validPropNames.contains(string);
    }

    @Override
    public String get(String string) {
        String string2 = this.values.get(string);
        return string2 == null ? "null" : string2;
    }

    public String toString() {
        return this.values.toString();
    }

    private void processVMOptions(List<String> list) {
        String string = null;
        String string2 = null;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String object : list) {
            int entry;
            if (object.equals("-Xmixed")) {
                string2 = MODE_MIXED;
                continue;
            }
            if (object.equals("-Xint")) {
                string2 = MODE_INT;
                continue;
            }
            if (object.equals("-Xcomp")) {
                string2 = MODE_COMP;
                continue;
            }
            if (object.startsWith(GC_PREFIX) && object.endsWith(GC_SUFFIX)) {
                string = object.substring(GC_PREFIX.length(), object.length() - GC_SUFFIX.length());
                hashMap.put(object.substring(ON_PREFIX.length()), true);
                continue;
            }
            if (object.startsWith(ON_PREFIX)) {
                hashMap.put(object.substring(ON_PREFIX.length()), true);
                continue;
            }
            if (object.startsWith(OFF_PREFIX)) {
                hashMap.put(object.substring(OFF_PREFIX.length()), false);
                continue;
            }
            if (!object.startsWith(VM_PREFIX) || (entry = object.indexOf(61)) <= 0) continue;
            String string3 = object.substring(VM_PREFIX.length(), entry);
            String string4 = object.substring(entry + 1);
            hashMap2.put(string3, string4);
        }
        String string5 = "null";
        this.putIfAbsent(this.values, "vm.flavor", string5);
        this.putIfAbsent(this.values, "vm.bits", string5);
        this.putIfAbsent(this.values, "vm.gc", string != null ? string : string5);
        this.putIfAbsent(this.values, "vm.compMode", (String)(string2 != null ? string2 : string5));
        for (Map.Entry entry : hashMap.entrySet()) {
            this.putIfAbsent(this.values, "vm.opt." + (String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.putIfAbsent(this.values, "vm.opt." + (String)entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private void putIfAbsent(Map<String, String> map, String string, String string2) {
        if (!map.containsKey(string)) {
            map.put(string, string2);
        }
    }
}

