/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.GetJDKProperties;
import com.sun.javatest.regtest.agent.GetSystemProperty;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExtraPropDefns;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JDK {
    private static final Map<File, JDK> cache = new HashMap<File, JDK>();
    private final File jdk;
    private final File absJDK;
    private String javaSpecificationVersion;
    private JDK_Version jdkVersion;
    private Map<Set<String>, String> fullVersions;
    private Boolean hasOldSymbolFile = null;
    private final Map<RegressionParameters, Info> infoMap = new HashMap<RegressionParameters, Info>();
    private static boolean showModules = Flags.get("showModules");

    public static JDK of(String string) {
        return JDK.of(new File(string));
    }

    public static synchronized JDK of(File file) {
        JDK jDK = cache.get(file);
        if (jDK == null) {
            jDK = new JDK(file);
            cache.put(file, jDK);
        }
        return jDK;
    }

    private JDK(File file) {
        this.jdk = file;
        this.absJDK = file.getAbsoluteFile();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JDK)) {
            return false;
        }
        JDK jDK = (JDK)object;
        return this.absJDK.equals(jDK.absJDK);
    }

    public int hashCode() {
        return this.absJDK.hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    public File getFile() {
        return this.jdk;
    }

    public File getAbsoluteFile() {
        return this.absJDK;
    }

    public File getJavaProg() {
        return new File(new File(this.absJDK, "bin"), "java");
    }

    public File getJavacProg() {
        return new File(new File(this.absJDK, "bin"), "javac");
    }

    public boolean exists() {
        return this.jdk.exists();
    }

    public String getPath() {
        return this.jdk.getPath();
    }

    public String getAbsolutePath() {
        return this.absJDK.getPath();
    }

    public SearchPath getJDKClassPath() {
        return new SearchPath(new File(new File(this.absJDK, "lib"), "tools.jar"));
    }

    public JDK_Version getVersion(RegressionParameters regressionParameters) {
        return this.getJDKVersion(regressionParameters.getJavaTestClassPath());
    }

    public synchronized JDK_Version getJDKVersion(SearchPath searchPath) {
        if (this.jdkVersion == null) {
            this.jdkVersion = JDK_Version.forName(this.getJavaSpecificationVersion(searchPath));
        }
        return this.jdkVersion;
    }

    private synchronized String getJavaSpecificationVersion(SearchPath searchPath) {
        block7: {
            if (this.javaSpecificationVersion != null) {
                return this.javaSpecificationVersion;
            }
            for (Info object : this.infoMap.values()) {
                if (object.jdkProperties == null) continue;
                this.javaSpecificationVersion = object.jdkProperties.getProperty("java.specification.version");
                if (this.javaSpecificationVersion == null) continue;
                return this.javaSpecificationVersion;
            }
            this.javaSpecificationVersion = "unknown";
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.environment().put("CLASSPATH", searchPath.toString());
            processBuilder.command(this.getJavaProg().getPath(), GetSystemProperty.class.getName(), "java.specification.version");
            processBuilder.redirectErrorStream(true);
            try {
                Process interruptedException = processBuilder.start();
                List<String> list = this.getOutput(interruptedException);
                int n = interruptedException.waitFor();
                if (n != 0) break block7;
                for (String string : list) {
                    String[] stringArray = string.trim().split("=", 2);
                    if (stringArray.length != 2 || !stringArray[0].equals("java.specification.version")) continue;
                    this.javaSpecificationVersion = stringArray[1];
                    break;
                }
            }
            catch (InterruptedException iOException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.javaSpecificationVersion == null || this.javaSpecificationVersion.length() == 0) {
            this.javaSpecificationVersion = "1.1";
        }
        return this.javaSpecificationVersion;
    }

    public synchronized String getVersionText(Collection<String> collection) {
        LinkedHashSet<String> linkedHashSet;
        String string;
        if (this.fullVersions == null) {
            this.fullVersions = new HashMap<Set<String>, String>();
        }
        if ((string = this.fullVersions.get(linkedHashSet = new LinkedHashSet<String>(collection))) == null) {
            string = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getJavaProg().getPath());
            arrayList.addAll(collection);
            arrayList.add("-version");
            try {
                Process process = new ProcessBuilder(arrayList).redirectErrorStream(true).start();
                List<String> list = this.getOutput(process);
                int n = process.waitFor();
                if (n == 0) {
                    string = StringUtils.join(list, "\n");
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fullVersions.put(linkedHashSet, string);
        }
        return string;
    }

    public synchronized Properties getProperties(RegressionParameters regressionParameters) throws Fault {
        Info info = this.getInfo(regressionParameters);
        if (info.jdkProperties == null) {
            info.jdkProperties = this.execGetProperties(regressionParameters, Collections.emptyList(), Arrays.asList("--system-properties", "--modules=boot-layer"), true);
        }
        return info.jdkProperties;
    }

    public boolean hasModules() {
        Iterator<RegressionParameters> iterator = this.infoMap.keySet().iterator();
        if (iterator.hasNext()) {
            RegressionParameters regressionParameters = iterator.next();
            return !this.getDefaultModules(regressionParameters).isEmpty();
        }
        throw new IllegalStateException();
    }

    public synchronized Set<String> getDefaultModules(RegressionParameters regressionParameters) {
        Info info = this.getInfo(regressionParameters);
        if (info.defaultModules == null) {
            try {
                Properties properties = this.getProperties(regressionParameters);
                String string = properties.getProperty("jtreg.modules");
                info.defaultModules = string == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(string.split(" +"))));
            }
            catch (Fault fault) {
                throw new IllegalStateException(fault);
            }
            if (showModules) {
                System.err.println("default modules: " + new TreeSet<String>(info.defaultModules));
            }
        }
        return info.defaultModules;
    }

    public synchronized Set<String> getSystemModules(RegressionParameters regressionParameters) {
        Info info = this.getInfo(regressionParameters);
        if (info.systemModules == null) {
            if (this.getVersion(regressionParameters).compareTo(JDK_Version.V9) >= 0) {
                try {
                    String string;
                    String string2 = "--modules=all-system";
                    Object object = regressionParameters.getTestVMJavaOptions().iterator();
                    while (object.hasNext()) {
                        string = object.next();
                        if (!string.matches("--(add|limit)-modules(=.*)?")) continue;
                        string2 = "--modules=boot-layer";
                        break;
                    }
                    if ((string = ((Properties)(object = this.execGetProperties(regressionParameters, Collections.emptyList(), Arrays.asList(string2), false))).getProperty("jtreg.modules")) == null) {
                        info.systemModules = Collections.emptySet();
                    }
                    info.systemModules = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(string.split(" +"))));
                }
                catch (Fault fault) {
                    throw new IllegalStateException(fault);
                }
            } else {
                info.systemModules = Collections.emptySet();
            }
            if (showModules) {
                System.err.println("system modules: " + new TreeSet<String>(info.systemModules));
            }
        }
        return info.systemModules;
    }

    public boolean hasOldSymbolFile() {
        if (this.hasOldSymbolFile == null) {
            Comparable<JDK_Version> comparable;
            if (this.javaSpecificationVersion != null && (((JDK_Version)(comparable = JDK_Version.forName(this.javaSpecificationVersion))).compareTo(JDK_Version.V1_5) <= 0 || ((JDK_Version)comparable).compareTo(JDK_Version.V10) >= 0)) {
                this.hasOldSymbolFile = false;
                return this.hasOldSymbolFile;
            }
            comparable = new File(new File(this.absJDK, "lib"), "ct.sym");
            if (((File)comparable).exists()) {
                try (JarFile jarFile = new JarFile((File)comparable);){
                    JarEntry jarEntry = jarFile.getJarEntry("META-INF/sym/rt.jar/java/lang/Object.class");
                    this.hasOldSymbolFile = jarEntry != null;
                }
                catch (IOException iOException) {
                    this.hasOldSymbolFile = false;
                }
            } else {
                this.hasOldSymbolFile = false;
            }
        }
        return this.hasOldSymbolFile;
    }

    private Properties execGetProperties(RegressionParameters regressionParameters, List<String> list, List<String> list2, boolean bl) throws Fault {
        ExtraPropDefns extraPropDefns = bl ? regressionParameters.getTestSuite().getExtraPropDefns() : new ExtraPropDefns();
        try {
            extraPropDefns.compile(regressionParameters, regressionParameters.getCompileJDK(), regressionParameters.getWorkDirectory().getFile("extraPropDefns"));
        }
        catch (ExtraPropDefns.Fault fault) {
            throw new Fault(fault.getMessage(), fault);
        }
        JDKOpts jDKOpts = new JDKOpts();
        jDKOpts.add("--class-path");
        SearchPath searchPath = new SearchPath(regressionParameters.getJavaTestClassPath());
        searchPath.append(extraPropDefns.getClassDir());
        jDKOpts.add(searchPath.toString());
        SearchPath searchPath2 = new SearchPath(extraPropDefns.getBootClassDir());
        if (!searchPath2.isEmpty()) {
            jDKOpts.add("-Xbootclasspath/a:" + searchPath2);
        }
        List<String> list3 = regressionParameters.getTestVMJavaOptions();
        jDKOpts.addAll(list3);
        jDKOpts.addAll(list);
        jDKOpts.addAll(extraPropDefns.getVMOpts());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getJavaProg().getPath());
        arrayList.addAll(jDKOpts.toList());
        arrayList.add(GetJDKProperties.class.getName());
        arrayList.addAll(list2);
        arrayList.addAll(extraPropDefns.getClasses());
        Properties properties = new Properties();
        try {
            File file = regressionParameters.getWorkDirectory().getFile("scratch");
            file.mkdirs();
            Process process = new ProcessBuilder(arrayList).directory(file).start();
            this.asyncCopy(process.getErrorStream(), System.err);
            properties.load(process.getInputStream());
            int n = process.waitFor();
            if (n != 0) {
                throw new Fault("failed to get JDK properties for " + this.getJavaProg() + " " + StringUtils.join(list3, " ") + "; exit code " + n);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new Fault("Error accessing extra property definitions: " + interruptedException, interruptedException);
        }
        catch (IOException iOException) {
            throw new Fault("Error accessing extra property definitions: " + iOException, iOException);
        }
        return properties;
    }

    private void asyncCopy(final InputStream inputStream, final PrintStream printStream) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string = bufferedReader.readLine()) != null) {
                        printStream.println(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private List<String> getOutput(Process process) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            return Collections.singletonList(iOException.getMessage());
        }
    }

    private Info getInfo(RegressionParameters regressionParameters) {
        Info info = this.infoMap.get(regressionParameters);
        if (info == null) {
            info = new Info();
            this.infoMap.put(regressionParameters, info);
        }
        return info;
    }

    static class Info {
        Properties jdkProperties;
        Set<String> defaultModules;
        Set<String> systemModules;

        Info() {
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String string) {
            super(string);
        }

        Fault(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

