/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.RegressionParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtraPropDefns {
    private final List<String> files;
    private final List<String> libs;
    private final List<String> bootLibs;
    private final List<String> javacOpts;
    private final List<String> vmOpts;
    private final PrintStream log;
    private File classDir;
    private File bootClassDir;
    private List<String> classes;
    private static Pattern packagePattern = Pattern.compile("package\\s+(((?:\\w+\\.)*)(?:\\w+))\\s*;");
    private static Pattern classPattern = Pattern.compile("(?:public\\s+)?(?:class|enum|interface)\\s+(\\w+)");

    ExtraPropDefns() {
        this(null, null, null, null, null);
    }

    ExtraPropDefns(String string, String string2, String string3, String string4, String string5) {
        this.files = this.asList(string);
        this.libs = this.asList(string2);
        this.bootLibs = this.asList(string3);
        this.javacOpts = this.asList(string4);
        this.vmOpts = this.asList(string5);
        this.log = System.err;
    }

    void compile(RegressionParameters regressionParameters, JDK jDK, File file) throws Fault {
        File file2 = regressionParameters.getTestSuite().getRootDir();
        this.classDir = new File(file, "classes");
        this.bootClassDir = new File(file, "bootClasses");
        this.compile(jDK, this.bootClassDir, new SearchPath(), file2, this.bootLibs, true);
        this.compile(jDK, this.classDir, new SearchPath(this.bootClassDir), file2, this.libs, true);
        this.classes = this.compile(jDK, this.classDir, new SearchPath(this.bootClassDir), file2, this.files, false);
    }

    File getClassDir() {
        return this.classDir;
    }

    File getBootClassDir() {
        return this.bootClassDir;
    }

    List<String> getClasses() {
        return this.classes;
    }

    List<String> getVMOpts() {
        return this.vmOpts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<String> compile(JDK jDK, File file, SearchPath searchPath, File file2, List<String> list, boolean bl) throws Fault {
        Object object;
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("-d");
        arrayList2.add(file.getPath());
        file.mkdirs();
        arrayList2.add("-classpath");
        arrayList2.add(new SearchPath(file).append(searchPath).toString());
        arrayList2.addAll(this.javacOpts);
        boolean bl2 = false;
        if (!file.exists()) {
            bl2 = true;
            file.mkdirs();
        }
        for (String iOException : list) {
            void object2;
            boolean bl3;
            if (iOException.startsWith("[") && iOException.endsWith("]")) {
                bl3 = true;
                String interruptedException = iOException.substring(1, iOException.length() - 1);
            } else {
                bl3 = false;
            }
            object = new File(file2, (String)object2);
            if (!((File)object).exists()) {
                if (bl3) continue;
                System.err.println("Cannot find file " + (String)object2 + " for extra property definitions");
                continue;
            }
            for (File file3 : this.expandJavaFiles((File)object, bl)) {
                arrayList2.add(file3.getPath());
                String string = this.getClassNameFromFile(file3);
                arrayList.add(string);
                File file4 = new File(file, string.replace(".", File.separator) + ".class");
                if (file4.exists() && file3.lastModified() <= file4.lastModified()) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            ArrayList arrayList3 = new ArrayList();
            arrayList3.add(jDK.getJavacProg().getPath());
            arrayList3.addAll(arrayList2);
            try {
                Process process = new ProcessBuilder(arrayList3).redirectErrorStream(true).start();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    while ((object = bufferedReader.readLine()) != null) {
                        this.log.println((String)object);
                    }
                }
                int n = process.waitFor();
                if (n != 0) {
                    throw new Fault("Compilation of extra property definition files failed. rc=" + n);
                }
            }
            catch (IOException iOException) {
                throw new Fault("Compilation of extra property definition files failed.", iOException);
            }
            catch (InterruptedException interruptedException) {
                throw new Fault("Compilation of extra property definition files failed.", interruptedException);
            }
        }
        return arrayList;
    }

    private List<File> expandJavaFiles(File file, boolean bl) throws Fault {
        ArrayList<File> arrayList = new ArrayList<File>();
        this.expandJavaFiles(file, bl, true, arrayList);
        return arrayList;
    }

    private void expandJavaFiles(File file, boolean bl, boolean bl2, List<File> list) throws Fault {
        if (file.isFile()) {
            if (file.getName().endsWith(".java")) {
                list.add(file);
            } else if (bl2) {
                throw new Fault("unexpected file found in extra property definition files: " + file);
            }
        } else if (file.isDirectory()) {
            if (bl) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (File file2 : fileArray) {
                        this.expandJavaFiles(file2, true, false, list);
                    }
                }
            } else if (bl2) {
                throw new Fault("unexpected directory found in extra property definition files" + file);
            }
        }
    }

    private String getClassNameFromFile(File file) throws Fault {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
        }
        catch (IOException iOException) {
            throw new Fault("Problem reading " + file, iOException);
        }
        return this.getClassNameFromSource(stringBuilder.toString());
    }

    private String getClassNameFromSource(String string) throws Fault {
        String string2 = null;
        Matcher matcher = packagePattern.matcher(string);
        if (matcher.find()) {
            string2 = matcher.group(1);
        }
        if ((matcher = classPattern.matcher(string)).find()) {
            String string3 = matcher.group(1);
            return string2 == null ? string3 : string2 + "." + string3;
        }
        throw new Fault("Could not extract the java class name from the provided source");
    }

    private List<String> asList(String string) {
        return string == null ? Collections.emptyList() : Arrays.asList(string.split("\\s+"));
    }

    static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String string) {
            super(string);
        }

        Fault(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

