/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CachingTestFilter
extends TestFilter {
    private TestFilter delegate;
    private final Map<TestDescription, Boolean> cache = new HashMap<TestDescription, Boolean>();

    CachingTestFilter(TestFilter testFilter) {
        if (testFilter == null) {
            throw new NullPointerException();
        }
        this.delegate = testFilter;
    }

    public Map<TestDescription, Boolean> getCache() {
        return Collections.unmodifiableMap(this.cache);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public String getReason() {
        return this.delegate.getReason();
    }

    @Override
    public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        Boolean bl = this.cache.get(testDescription);
        if (bl == null) {
            bl = this.delegate.accepts(testDescription);
            this.cache.put(testDescription, bl);
        }
        return bl;
    }
}

