/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleHelper {
    private static Method findModuleMethod;
    private static Object bootLayer;
    private static Method getUnnamedModuleMethod;
    private static Method isPresentMethod;
    private static Method getMethod;
    private static Method addExportsMethod;
    private static Method addOpensMethod;

    static void addExports(Set<String> set, ClassLoader classLoader) throws Fault {
        for (String string : set) {
            ModuleHelper.addExportsOrOpens(string, false, classLoader);
        }
    }

    static void addOpens(Set<String> set, ClassLoader classLoader) throws Fault {
        for (String string : set) {
            ModuleHelper.addExportsOrOpens(string, true, classLoader);
        }
    }

    private static void addExportsOrOpens(String string, boolean bl, ClassLoader classLoader) throws Fault {
        int n = string.indexOf("/");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            ModuleHelper.init();
            Object object = findModuleMethod.invoke(bootLayer, string2);
            if (!((Boolean)isPresentMethod.invoke(object, new Object[0])).booleanValue()) {
                throw new Fault("module not found: " + string2, null);
            }
            Object object2 = getMethod.invoke(object, new Object[0]);
            Object object3 = getUnnamedModuleMethod.invoke((Object)classLoader, new Object[0]);
            try {
                Method method = bl ? addOpensMethod : addExportsMethod;
                method.invoke(null, object2, string3, object3);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof IllegalArgumentException) {
                    String string4 = invocationTargetException.getCause().getMessage();
                    throw new Fault("package not found: " + string3 + " (" + string4 + ")", null);
                }
                throw new Fault("unexpected exception: " + invocationTargetException, invocationTargetException);
            }
        }
        catch (SecurityException securityException) {
            throw new Fault("unexpected exception: " + securityException, securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("unexpected exception: " + illegalAccessException, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault("unexpected exception: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Fault("unexpected exception: " + invocationTargetException, invocationTargetException);
        }
    }

    private static synchronized void init() throws Fault {
        if (bootLayer != null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("java.lang.ModuleLayer");
            findModuleMethod = clazz.getDeclaredMethod("findModule", String.class);
            Method method = clazz.getDeclaredMethod("boot", new Class[0]);
            bootLayer = method.invoke(null, new Object[0]);
            Class<?> clazz2 = Class.forName("java.lang.JTRegModuleHelper");
            addExportsMethod = clazz2.getDeclaredMethod("addExports", Object.class, String.class, Object.class);
            addOpensMethod = clazz2.getDeclaredMethod("addOpens", Object.class, String.class, Object.class);
            getUnnamedModuleMethod = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
            Class<?> clazz3 = Class.forName("java.util.Optional");
            isPresentMethod = clazz3.getDeclaredMethod("isPresent", new Class[0]);
            getMethod = clazz3.getDeclaredMethod("get", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault("unexpected exception: " + classNotFoundException, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Fault("unexpected exception: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new Fault("unexpected exception: " + securityException, securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("unexpected exception: " + illegalAccessException, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault("unexpected exception: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Fault("unexpected exception: " + invocationTargetException, invocationTargetException);
        }
    }

    static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

