/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.ModuleHelper;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainActionHelper
extends ActionHelper {
    private static final boolean traceCleanup = Flags.get("traceCleanup");
    private static final String MSG_PREFIX = "JavaTest Message: ";
    private static final String SKIP_EXCEPTION = "jtreg.SkippedException";
    private static final String MAIN_THREAD_INTR = "Thread interrupted: ";
    private static final String MAIN_THREAD_TIMEOUT = "Timeout";
    private static final String MAIN_THREW_EXCEPT = "`main' threw exception: ";
    private static final String MAIN_CANT_LOAD_TEST = "Can't load test: ";
    private static final String MAIN_CANT_FIND_MAIN = "Can't find `main' method";
    private static final String MAIN_CANT_INIT_MODULE_EXPORTS = "Can't init module exports: ";
    private static final String MAIN_SKIPPED = "Skipped: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AStatus runClass(String string, Map<String, String> map, Set<String> set, Set<String> set2, SearchPath searchPath, String string2, String[] stringArray, int n, ActionHelper.OutputHandler outputHandler) {
        Object object;
        Class<?> classNotFoundException;
        Object object2;
        ActionHelper.SaveState saveState = new ActionHelper.SaveState();
        Properties properties = System.getProperties();
        for (Map.Entry<String, String> object32 : map.entrySet()) {
            object2 = object32.getKey();
            classNotFoundException = object32.getValue();
            if (((String)object2).equals("test.class.path.prefix")) {
                object = new SearchPath(new String[]{classNotFoundException, System.getProperty("java.class.path")});
                properties.put("java.class.path", ((SearchPath)object).toString());
                continue;
            }
            properties.put(object32.getKey(), object32.getValue());
        }
        System.setProperties(properties);
        PrintStream printStream = outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDOUT, false);
        PrintStream printStream2 = outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDERR, true);
        object2 = AStatus.passed("Execution successful");
        try {
            Object object3;
            Object[] objectArray;
            Class[] classArray;
            if (searchPath != null) {
                classArray = new ArrayList();
                for (File file : new SearchPath(searchPath).asList()) {
                    try {
                        classArray.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                object = new URLClassLoader(classArray.toArray(new URL[classArray.size()]));
                ModuleHelper.addExports(set, (ClassLoader)object);
                ModuleHelper.addOpens(set2, (ClassLoader)object);
                classNotFoundException = ((ClassLoader)object).loadClass(string2);
            } else {
                object = null;
                classNotFoundException = Class.forName(string2);
            }
            if (TestRunner.class.isAssignableFrom(classNotFoundException)) {
                classArray = new Class[]{ClassLoader.class, String[].class};
                objectArray = new Object[]{object, stringArray};
            } else {
                classArray = new Class[]{String[].class};
                objectArray = new Object[]{stringArray};
            }
            Method method = classNotFoundException.getMethod("main", classArray);
            PrintStream printStream3 = System.err;
            AStatus aStatus = MainActionHelper.redirectOutput(printStream, printStream2);
            if (!aStatus.isPassed()) {
                AStatus aStatus2 = aStatus;
                return aStatus2;
            }
            AgentVMThreadGroup agentVMThreadGroup = new AgentVMThreadGroup(printStream2, MSG_PREFIX);
            AgentVMRunnable agentVMRunnable = new AgentVMRunnable(method, objectArray, printStream2);
            Thread thread = new Thread(agentVMThreadGroup, agentVMRunnable, "AgentVMThread");
            Alarm alarm = null;
            if (n > 0) {
                object3 = outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.LOG, true);
                alarm = Alarm.schedulePeriodicInterrupt(n, TimeUnit.SECONDS, (PrintWriter)object3, thread);
            }
            object3 = null;
            thread.start();
            try {
                thread.join();
                if (traceCleanup) {
                    printStream3.println("main method returned");
                }
            }
            catch (InterruptedException interruptedException) {
                printStream3.println("main method interrupted");
                if (thread.isInterrupted() && agentVMThreadGroup.uncaughtThrowable == null) {
                    object3 = interruptedException;
                    object2 = AStatus.error(MAIN_THREAD_INTR + interruptedException.getMessage());
                }
            }
            finally {
                if (traceCleanup) {
                    printStream3.println("cleaning threads");
                }
                agentVMThreadGroup.cleanup();
                if (traceCleanup) {
                    printStream3.println("thread cleanup completed");
                }
                if (alarm != null) {
                    alarm.cancel();
                    if (alarm.didFire() && object3 == null) {
                        printStream2.println("Test timed out. No timeout information is available in agentvm mode.");
                        object3 = new Error("timeout");
                        object2 = AStatus.error(MAIN_THREAD_TIMEOUT);
                    }
                }
            }
            if ((agentVMRunnable.t != null || agentVMThreadGroup.uncaughtThrowable != null) && object3 == null) {
                object3 = agentVMRunnable.t == null ? agentVMThreadGroup.uncaughtThrowable : agentVMRunnable.t;
                object2 = SKIP_EXCEPTION.equals(object3.getClass().getName()) ? AStatus.passed(MAIN_SKIPPED + ((Throwable)object3).toString()) : AStatus.failed(MAIN_THREW_EXCEPT + ((Throwable)object3).toString());
            }
            if (((AStatus)object2).getReason().contains("java.lang.SecurityException: System.exit() forbidden")) {
                object2 = AStatus.failed("Unexpected exit from test");
            } else if (!agentVMThreadGroup.cleanupOK) {
                object2 = AStatus.error("Error while cleaning up threads after test");
            }
        }
        catch (ClassNotFoundException noSuchMethodException) {
            noSuchMethodException.printStackTrace(printStream2);
            printStream2.println();
            printStream2.println("JavaTest Message: main() method must be in a public class named");
            printStream2.println(MSG_PREFIX + string2 + " in file " + string2 + ".java");
            printStream2.println();
            object2 = AStatus.error(MAIN_CANT_LOAD_TEST + noSuchMethodException);
        }
        catch (NoSuchMethodException fault) {
            fault.printStackTrace(printStream2);
            printStream2.println();
            printStream2.println("JavaTest Message: main() method must be in a public class named");
            printStream2.println(MSG_PREFIX + string2 + " in file " + string2 + ".java");
            printStream2.println();
            object2 = AStatus.error(MAIN_CANT_FIND_MAIN);
        }
        catch (ModuleHelper.Fault fault) {
            if (fault.getCause() != null) {
                fault.printStackTrace(printStream2);
            }
            object2 = AStatus.error(MAIN_CANT_INIT_MODULE_EXPORTS + fault.getMessage());
        }
        finally {
            printStream.close();
            printStream2.close();
            object2 = saveState.restore(string, (AStatus)object2);
        }
        return object2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AgentVMThreadGroup
    extends ThreadGroup {
        private final PrintStream out;
        private final String messagePrefix;
        private boolean cleaning = false;
        Throwable uncaughtThrowable = null;
        Thread uncaughtThread = null;
        boolean cleanupOK = false;

        AgentVMThreadGroup(PrintStream printStream, String string) {
            super("AgentVMThreadGroup");
            this.out = printStream;
            this.messagePrefix = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            if (this.uncaughtThrowable == null && !this.cleaning) {
                this.uncaughtThrowable = throwable;
                this.uncaughtThread = thread;
            }
            this.cleanup();
        }

        private void cleanup() {
            this.cleaning = true;
            long l = System.nanoTime();
            block2: for (int i = 1; i <= 4; ++i) {
                long l2 = l + (long)i * 2500L * 1000000L;
                List<Thread> list = this.liveThreads();
                if (list.isEmpty()) {
                    this.cleanupOK = true;
                    return;
                }
                for (Thread thread : list) {
                    thread.interrupt();
                }
                for (Thread thread : list) {
                    long l3 = (l2 - System.nanoTime()) / 1000000L;
                    if (l3 <= 0L) continue block2;
                    try {
                        thread.join(l3);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            List<Thread> list = this.liveThreads();
            if (list.isEmpty()) {
                this.cleanupOK = true;
                return;
            }
            this.out.println();
            this.out.println(this.messagePrefix + "Problem cleaning up the following threads:");
            this.printTraces(list);
            this.cleanupOK = false;
        }

        private List<Thread> liveThreads() {
            int n = this.activeCount() + 1;
            while (true) {
                Thread[] threadArray;
                int n2;
                if ((n2 = this.enumerate(threadArray = new Thread[n])) < threadArray.length) {
                    ArrayList<Thread> arrayList = new ArrayList<Thread>(n2);
                    for (int i = 0; i < n2; ++i) {
                        Thread thread = threadArray[i];
                        if (!thread.isAlive() || thread == Thread.currentThread() || thread.isDaemon()) continue;
                        arrayList.add(thread);
                    }
                    return arrayList;
                }
                n *= 2;
            }
        }

        private void printTraces(List<Thread> list) {
            for (Thread thread : list) {
                this.out.println(thread.getName());
                StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    this.out.println("  at " + stackTraceElementArray[i]);
                    if (i != 20) continue;
                    this.out.println("  ...");
                    break;
                }
                this.out.println();
            }
        }
    }

    private static class AgentVMRunnable
    implements Runnable {
        public Object result;
        private final Method method;
        private final Object[] args;
        private final PrintStream out;
        Throwable t = null;

        public AgentVMRunnable(Method method, Object[] objectArray, PrintStream printStream) {
            this.method = method;
            this.args = objectArray;
            this.out = printStream;
        }

        public void run() {
            try {
                this.result = this.method.invoke(null, this.args);
                this.out.println();
                this.out.println("JavaTest Message: Test complete.");
                this.out.println();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace(this.out);
                this.t = invocationTargetException.getTargetException();
                this.out.println();
                this.out.println("JavaTest Message: Test threw exception: " + this.t.getClass().getName());
                this.out.println("JavaTest Message: shutting down test");
                this.out.println();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(this.out);
                this.t = illegalAccessException;
                this.out.println();
                this.out.println("JavaTest Message: Verify that the class defining the test is");
                this.out.println("JavaTest Message: declared public (test invoked via reflection)");
                this.out.println();
            }
        }
    }

    public static interface TestRunner {
    }
}

