/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;

public class GetJDKProperties {
    public static final String JTREG_MODULES = "jtreg.modules";

    public static void main(String ... stringArray) {
        try {
            GetJDKProperties.run(stringArray);
        }
        catch (ClientCodeException clientCodeException) {
            System.err.println(clientCodeException.getMessage());
            clientCodeException.getCause().printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println("Internal error: please report to jtreg-dev@openjdk.java.net");
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void run(String ... stringArray) throws ClientCodeException, IOException {
        boolean bl = false;
        String string = null;
        Properties properties = new Properties();
        for (String string2 : stringArray) {
            if (string2.equals("--system-properties")) {
                bl = true;
                continue;
            }
            if (string2.startsWith("--modules=")) {
                string = string2.substring(string2.indexOf("=") + 1);
                continue;
            }
            try {
                Class<?> clazz = Class.forName(string2);
                Callable callable = (Callable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                properties.putAll((Map<?, ?>)((Map)callable.call()));
            }
            catch (Throwable throwable) {
                throw new ClientCodeException("Exception while calling user-specified class: " + string2, throwable);
            }
        }
        if (string != null && GetJDKProperties.getJDKVersion() >= 9) {
            void var4_8;
            Object var4_5 = null;
            if (string.equals("boot-layer")) {
                String string3 = GetJDKProperties.getModulesFromBootLayer();
            } else if (string.equals("all-system")) {
                String string4 = GetJDKProperties.getAllSystemModules();
            }
            if (var4_8 != null) {
                properties.put(JTREG_MODULES, (Object)var4_8);
            }
        }
        if (bl) {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        properties.store(System.out, "jdk properties");
    }

    private static int getJDKVersion() {
        String string = System.getProperty("java.specification.version");
        if (string == null) {
            return -1;
        }
        if (string.startsWith("1.")) {
            string = string.substring(2);
        }
        if (string.contains(".")) {
            string = string.substring(0, string.indexOf("."));
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static String getModulesFromBootLayer() {
        try {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.ModuleLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz2 = Class.forName("java.lang.reflect.Layer");
            }
            Method method = clazz2.getDeclaredMethod("boot", new Class[0]);
            Method method2 = clazz2.getDeclaredMethod("modules", new Class[0]);
            try {
                clazz = Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("java.lang.reflect.Module");
            }
            Method method3 = clazz.getDeclaredMethod("getName", new Class[0]);
            StringBuilder stringBuilder = new StringBuilder();
            Object object = method.invoke(null, new Object[0]);
            for (Object e : (Set)method2.invoke(object, new Object[0])) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(method3.invoke(e, new Object[0]));
            }
            return stringBuilder.toString();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private static String getAllSystemModules() {
        try {
            Class<?> clazz = Class.forName("java.lang.module.ModuleFinder");
            Method method = clazz.getDeclaredMethod("ofSystem", new Class[0]);
            Method method2 = clazz.getDeclaredMethod("findAll", new Class[0]);
            Class<?> clazz2 = Class.forName("java.lang.module.ModuleReference");
            Method method3 = clazz2.getDeclaredMethod("descriptor", new Class[0]);
            Class<?> clazz3 = Class.forName("java.lang.module.ModuleDescriptor");
            Method method4 = clazz3.getDeclaredMethod("name", new Class[0]);
            StringBuilder stringBuilder = new StringBuilder();
            Object object = method.invoke(null, new Object[0]);
            for (Object e : (Set)method2.invoke(object, new Object[0])) {
                Object object2 = method3.invoke(e, new Object[0]);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(method4.invoke(object2, new Object[0]));
            }
            return stringBuilder.toString();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public static class ClientCodeException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ClientCodeException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

