/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Harness;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.tool.AntOptionDecoder;
import com.sun.javatest.regtest.tool.Tool;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;

public class Main {
    public static final int EXIT_OK = 0;
    public static final int EXIT_NO_TESTS = 1;
    public static final int EXIT_TEST_FAILED = 2;
    public static final int EXIT_TEST_ERROR = 3;
    public static final int EXIT_BAD_ARGS = 4;
    public static final int EXIT_FAULT = 5;
    public static final int EXIT_EXCEPTION = 6;
    private Tool tool;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public static void main(String[] stringArray) {
        Tool.main(stringArray);
    }

    public Main() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2) {
        this.tool = new Tool(printWriter, printWriter2);
    }

    public int run(String[] stringArray) throws BadArgs, Fault, Harness.Fault, InterruptedException {
        return this.tool.run(stringArray);
    }

    public static class Ant
    extends MatchingTask {
        private final Tool tool = new Tool();
        private File jdk;
        private File dir;
        private File reportDir;
        private File workDir;
        private File nativeDir;
        private String concurrency;
        private String status;
        private String vmOption;
        private String vmOptions;
        private String javacOption;
        private String javacOptions;
        private String javaOption;
        private String javaOptions;
        private String verbose;
        private boolean agentVM;
        private boolean sameVM;
        private boolean otherVM;
        private Boolean failOnError;
        private String resultProperty;
        private String failureProperty;
        private String errorProperty;
        private final List<Commandline.Argument> args = new ArrayList<Commandline.Argument>();

        public void setDir(File file) {
            this.dir = file;
        }

        public void setReportDir(File file) {
            this.reportDir = file;
        }

        public void setWorkDir(File file) {
            this.workDir = file;
        }

        public void setNativeDir(File file) {
            this.nativeDir = file;
        }

        public void setJDK(File file) {
            this.jdk = file;
        }

        public void setConcurrency(String string) {
            this.concurrency = string;
        }

        public void setVMOption(String string) {
            this.vmOption = string;
        }

        public void setVMOptions(String string) {
            this.vmOptions = string;
        }

        public void setJavacOption(String string) {
            this.javacOption = string;
        }

        public void setJavacOptions(String string) {
            this.javacOptions = string;
        }

        public void setJavaOption(String string) {
            this.javaOption = string;
        }

        public void setJavaOptions(String string) {
            this.javaOptions = string;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public void setVerbose(String string) {
            this.verbose = string;
        }

        public void setAgentVM(boolean bl) {
            this.agentVM = bl;
        }

        public void setSameVM(boolean bl) {
            this.sameVM = bl;
        }

        public void setOtherVM(boolean bl) {
            this.otherVM = bl;
        }

        public void setResultProperty(String string) {
            this.resultProperty = string;
        }

        public void setFailureProperty(String string) {
            this.failureProperty = string;
        }

        public void setErrorProperty(String string) {
            this.errorProperty = string;
        }

        public void setFailOnError(boolean bl) {
            this.failOnError = bl;
        }

        public void addArg(Commandline.Argument argument) {
            this.args.add(argument);
        }

        public void execute() {
            Project project = this.getProject();
            Hashtable hashtable = project.getProperties();
            for (Map.Entry entry : hashtable.entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith("javatest.")) continue;
                System.setProperty(string, (String)entry.getValue());
            }
            try {
                Map.Entry entry;
                AntOptionDecoder antOptionDecoder = new AntOptionDecoder(this.tool.options);
                antOptionDecoder.process("-concurrency", this.concurrency);
                antOptionDecoder.process("-dir", this.dir);
                antOptionDecoder.process("-reportDir", this.reportDir);
                antOptionDecoder.process("-workDir", this.workDir);
                antOptionDecoder.process("-nativeDir", this.nativeDir);
                antOptionDecoder.process("-jdk", this.jdk);
                antOptionDecoder.process("-verbose", this.verbose);
                antOptionDecoder.process("-agentVM", this.agentVM);
                antOptionDecoder.process("-sameVM", this.sameVM);
                antOptionDecoder.process("-otherVM", this.otherVM);
                antOptionDecoder.process("-vmoption", this.vmOption);
                antOptionDecoder.process("-vmoptions", this.vmOptions);
                antOptionDecoder.process("-javaoption", this.javaOption);
                antOptionDecoder.process("-javaoptions", this.javaOptions);
                antOptionDecoder.process("-javacoption", this.javacOption);
                antOptionDecoder.process("-javacoptions", this.javacOptions);
                antOptionDecoder.process("-status", this.status);
                if (this.args.size() > 0) {
                    entry = new ArrayList();
                    for (Commandline.Argument argument : this.args) {
                        entry.addAll(Arrays.asList(argument.getParts()));
                    }
                    antOptionDecoder.decodeArgs((List<String>)((Object)entry));
                }
                if (this.tool.testFileArgs.isEmpty() && this.tool.testFileIdArgs.isEmpty() && this.tool.testGroupArgs.isEmpty() && this.dir != null) {
                    entry = this.getDirectoryScanner(this.dir);
                    this.addPaths(this.dir, entry.getIncludedFiles());
                }
                int n = this.tool.run();
                if (this.resultProperty != null) {
                    project.setProperty(this.resultProperty, String.valueOf(n));
                }
                if (this.failureProperty != null && n >= 2) {
                    project.setProperty(this.failureProperty, i18n.getString("main.testsFailed"));
                }
                if (this.errorProperty != null && n >= 3) {
                    project.setProperty(this.errorProperty, i18n.getString("main.testsError"));
                }
                if (this.failOnError == null) {
                    this.failOnError = this.resultProperty == null && this.failureProperty == null && this.errorProperty == null;
                }
                if (this.failOnError.booleanValue() && n != 0) {
                    throw new BuildException(i18n.getString("main.testsFailed"));
                }
            }
            catch (Harness.Fault | BadArgs | Fault exception) {
                throw new BuildException(exception.getMessage(), (Throwable)exception);
            }
            catch (InterruptedException interruptedException) {
                throw new BuildException(i18n.getString("main.interrupted"), (Throwable)interruptedException);
            }
        }

        private void addPaths(File file, String[] stringArray) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.tool.antFileArgs.add(new File(file, string));
                }
            }
        }
    }

    public static class Fault
    extends Exception {
        static final long serialVersionUID = -6780999176737139046L;

        public Fault(I18NResourceBundle i18NResourceBundle, String string, Object ... objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

