/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.diff.Diff;
import com.sun.javatest.diff.Fault;
import com.sun.javatest.diff.HTMLReporter;
import com.sun.javatest.diff.Main;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class SuperDiff
extends Diff {
    protected String resultPath = System.getProperty("jtdiff.super.testResults", "JTreport/text/summary.txt");
    protected int historySize = Integer.getInteger("jtdiff.super.history", 21);
    private SuperTable table;
    private String baseTitle;
    private Map<String, File> historyIndex = new LinkedHashMap<String, File>();
    private Map<String, File> platformIndex = new LinkedHashMap<String, File>();
    private static DateFormat monthDayFormat = new SimpleDateFormat("MMM d");
    private static DateFormat mediumDateFormat = DateFormat.getDateInstance(2);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    SuperDiff(File file) {
        this.table = new SuperTable(file, this.resultPath);
    }

    @Override
    public boolean report(File file) throws Fault, InterruptedException {
        this.baseTitle = this.title;
        boolean bl = true;
        for (YearDay object : this.table.getRecentKeys(this.historySize)) {
            bl &= this.diffPlatforms(object, file);
        }
        for (String string : this.table.platforms) {
            bl &= this.diffHistory(string, file);
        }
        this.writeIndex(file, this.baseTitle);
        return bl;
    }

    protected boolean diff(List<File> list, File file, String string) throws Fault, InterruptedException {
        this.title = string;
        this.reporter = null;
        return this.diff(list, file);
    }

    @Override
    protected void initReporter() throws Fault {
        try {
            this.reporter = new SuperReporter(this.out);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantOpenReport", iOException);
        }
    }

    private boolean diffPlatforms(YearDay yearDay, File file) throws Fault, InterruptedException {
        String string2;
        Map map = (Map)this.table.get(yearDay);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : this.table.platforms) {
            File file2 = (File)map.get(string2);
            if (file2 == null) continue;
            arrayList.add(file2);
        }
        File file3 = new File(file, yearDay.year + "_" + yearDay.dayOfYear + ".html");
        this.platformIndex.put(yearDay.toDateString(monthDayFormat), file3);
        string2 = this.baseTitle == null ? "" : this.baseTitle + ": ";
        return this.diff(arrayList, file3, string2 + yearDay.toDateString(mediumDateFormat));
    }

    private boolean diffHistory(String string, File file) throws Fault, InterruptedException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (YearDay object2 : this.table.getRecentKeys(this.historySize, string)) {
            arrayList.add((File)((Map)this.table.get(object2)).get(string));
        }
        File file2 = new File(file, string + ".html");
        this.historyIndex.put(string, file2);
        String string2 = this.baseTitle == null ? "" : this.baseTitle + ": ";
        return this.diff(arrayList, file2, string2 + string);
    }

    private void writeIndex(File file, String string) throws Fault {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(file, "index.html"))));
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantOpenReport", iOException);
        }
        try {
            SuperReporter superReporter = new SuperReporter(printWriter);
            superReporter.writeMainIndex(string);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.ioError", iOException);
        }
        finally {
            printWriter.close();
        }
    }

    static class YearDay
    implements Comparable<YearDay> {
        final String year;
        final String dayOfYear;

        YearDay(String string, String string2) {
            string.getClass();
            string2.getClass();
            this.year = string;
            this.dayOfYear = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof YearDay)) {
                return false;
            }
            YearDay yearDay = (YearDay)object;
            return this.year.equals(yearDay.year) && this.dayOfYear.equals(yearDay.dayOfYear);
        }

        public int hashCode() {
            return this.year.hashCode() * 37 + this.dayOfYear.hashCode();
        }

        @Override
        public int compareTo(YearDay yearDay) {
            int n = this.compare(this.year, yearDay.year);
            return n == 0 ? this.compare(this.dayOfYear, yearDay.dayOfYear) : n;
        }

        public String toString() {
            return this.year + ":" + this.dayOfYear;
        }

        public Date asDate() {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(1, Integer.parseInt(this.year));
                calendar.set(6, Integer.parseInt(this.dayOfYear));
                return calendar.getTime();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public String toDateString(DateFormat dateFormat) {
            Date date = this.asDate();
            return date == null ? this.toString() : dateFormat.format(date);
        }

        private int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    }

    static class SuperTable
    extends TreeMap<YearDay, Map<String, File>> {
        static final long serialVersionUID = 5933594140534747584L;
        final Set<String> platforms = new TreeSet<String>();
        final Map<String, Info> infoTable = new HashMap<String, Info>();

        SuperTable(File file, String string) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                for (File file3 : file2.listFiles()) {
                    if (!file3.isDirectory()) continue;
                    for (File file4 : file3.listFiles()) {
                        File file5;
                        if (!file4.isDirectory() || !(file5 = new File(file4, string)).exists()) continue;
                        this.add(file2.getName(), file3.getName(), file4.getName(), file5);
                    }
                }
            }
        }

        private void add(String string, String string2, String string3, File file) {
            Date date;
            this.platforms.add(string);
            YearDay yearDay = new YearDay(string2, string3);
            HashMap<String, File> hashMap = (HashMap<String, File>)this.get(yearDay);
            if (hashMap == null) {
                hashMap = new HashMap<String, File>();
                this.put(yearDay, hashMap);
            }
            hashMap.put(string, file);
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(1, Integer.parseInt(string2));
                calendar.set(6, Integer.parseInt(string3));
                date = calendar.getTime();
            }
            catch (NumberFormatException numberFormatException) {
                date = null;
            }
            this.infoTable.put(file.getPath(), new Info(string, date));
        }

        List<YearDay> getRecentKeys(int n) {
            return this.getRecentKeys(n, null);
        }

        List<YearDay> getRecentKeys(int n, String string) {
            LinkedList<YearDay> linkedList = new LinkedList<YearDay>();
            ArrayList arrayList = new ArrayList(this.keySet());
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious() && linkedList.size() < n) {
                YearDay yearDay = (YearDay)listIterator.previous();
                if (string != null && ((Map)this.get(yearDay)).get(string) == null) continue;
                linkedList.addFirst(yearDay);
            }
            return linkedList;
        }

        Info getInfo(String string) {
            return this.infoTable.get(string);
        }
    }

    class SuperReporter
    extends HTMLReporter {
        SuperReporter(Writer writer) throws IOException {
            super(writer);
        }

        @Override
        protected void writeIndexTableInfoHeadings() throws IOException {
            this.out.startTag("th");
            this.out.writeI18N("super.th.platform");
            this.out.endTag("th");
            this.out.startTag("th");
            this.out.writeI18N("super.th.date");
            this.out.endTag("th");
        }

        @Override
        protected void writeIndexTableInfoValues(String string) throws IOException {
            Info info = SuperDiff.this.table.getInfo(string);
            this.out.startTag("td");
            if (info != null) {
                this.out.write(info.platform);
            }
            this.out.endTag("td");
            this.out.startTag("td");
            if (info != null) {
                this.out.write(monthDayFormat.format(info.date));
            }
            this.out.endTag("td");
        }

        void writeMainIndex(String string) throws IOException {
            this.startReport(string);
            if (SuperDiff.this.baseTitle != null) {
                this.out.startTag("h1");
                this.out.write(SuperDiff.this.baseTitle);
                this.out.endTag("h1");
            }
            this.writeMainIndexList(i18n.getString("super.platforms"), SuperDiff.this.platformIndex);
            this.writeMainIndexList(i18n.getString("super.history"), SuperDiff.this.historyIndex);
            this.endReport();
        }

        void writeMainIndexList(String string, Map<String, File> map) throws IOException {
            this.out.startTag("h2");
            this.out.write(string);
            this.out.endTag("h2");
            this.out.startTag("p");
            String string2 = "";
            for (Map.Entry<String, File> entry : map.entrySet()) {
                this.out.write(string2);
                this.out.startTag("a");
                this.out.writeAttr("href", entry.getValue().getName());
                String string3 = "";
                for (String string4 : entry.getKey().split(" ")) {
                    this.out.writeEntity(string3);
                    this.out.write(string4);
                    string3 = "&nbsp;";
                }
                this.out.endTag("a");
                string2 = ", ";
            }
        }
    }

    static class Info {
        final String platform;
        final Date date;

        Info(String string, Date date) {
            this.platform = string;
            this.date = date;
        }
    }
}

