/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.diff.Diff;
import com.sun.javatest.diff.Fault;
import com.sun.javatest.diff.Help;
import com.sun.javatest.diff.StandardDiff;
import com.sun.javatest.diff.SuperDiff;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.tool.AntOptionDecoder;
import com.sun.javatest.regtest.tool.Option;
import com.sun.javatest.regtest.tool.OptionDecoder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;

public class Main {
    private static final String COMPARE = "compare";
    private static final String OUTPUT = "output";
    private static final String DOC = "doc";
    private static final String FILES = "files";
    List<Option> options = Arrays.asList(new Option(Option.ArgType.NONE, "compare", "r", new String[]{"-r", "-reason"}){

        @Override
        public void process(String string, String string2) {
            Main.this.includeReason = true;
        }
    }, new Option(Option.ArgType.NONE, "compare", "s", new String[]{"-s", "-super"}){

        @Override
        public void process(String string, String string2) {
            Main.this.superMode = true;
        }
    }, new Option(Option.ArgType.OLD, "output", "o", new String[]{"-o", "-outFile"}){

        @Override
        public void process(String string, String string2) {
            Main.this.outFile = new File(string2);
        }
    }, new Option(Option.ArgType.STD, "output", "format", new String[]{"-format"}){

        @Override
        public void process(String string, String string2) {
            Main.this.format = string2;
        }
    }, new Option(Option.ArgType.OLD, "output", "title", new String[]{"-title"}){

        @Override
        public void process(String string, String string2) {
            Main.this.title = string2;
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"-h", "-help", "-usage"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setCommandLineHelpQuery(string2);
        }
    }, new Option(Option.ArgType.NONE, "doc", "help", new String[]{"-version"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setVersionFlag(true);
        }
    }, new Option(Option.ArgType.FILE, "files", null, new String[0]){

        @Override
        public void process(String string, String string2) {
            File file = new File(string2);
            Main.this.fileArgs.add(file);
        }
    });
    private PrintWriter out;
    private PrintWriter err;
    private boolean includeReason;
    private String format;
    private String title;
    private File outFile;
    private List<File> fileArgs = new ArrayList<File>();
    private boolean superMode;
    private Help help;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = new PrintWriter(System.err, true);
        Main main = new Main(printWriter, printWriter2);
        try {
            boolean bl;
            try {
                bl = main.run(stringArray);
                if (!bl && main.outFile != null) {
                    printWriter2.println(i18n.getString("main.diffsFound"));
                }
            }
            finally {
                printWriter.flush();
            }
            if (!bl) {
                Main.exit(1);
            }
        }
        catch (Fault fault) {
            printWriter2.println(i18n.getString("main.error", fault.getMessage()));
            Main.exit(2);
        }
        catch (BadArgs badArgs) {
            printWriter2.println(i18n.getString("main.badArgs", badArgs.getMessage()));
            new Help(main.options).showCommandLineHelp(printWriter);
            Main.exit(2);
        }
        catch (InterruptedException interruptedException) {
            printWriter2.println(i18n.getString("main.interrupted"));
            Main.exit(2);
        }
        catch (Exception exception) {
            printWriter2.println(i18n.getString("main.unexpectedException"));
            exception.printStackTrace(System.err);
            Main.exit(3);
        }
    }

    public Main() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2) {
        this.out = printWriter;
        this.err = printWriter2;
    }

    public final boolean run(String[] stringArray) throws BadArgs, Fault, InterruptedException {
        new OptionDecoder(this.options).decodeArgs(stringArray);
        if (this.superMode) {
            if (this.fileArgs.size() != 1 || !this.fileArgs.get(0).isDirectory()) {
                throw new Fault(i18n, "main.bad.super.dir", new Object[0]);
            }
            if (this.format != null) {
                throw new Fault(i18n, "main.bad.super.format", new Object[0]);
            }
            if (this.outFile == null) {
                throw new Fault(i18n, "main.no.output.dir", new Object[0]);
            }
        }
        return this.run();
    }

    private boolean run() throws Fault, InterruptedException {
        if (this.fileArgs.isEmpty() && !this.superMode && this.help == null) {
            this.help = new Help(this.options);
            this.help.setCommandLineHelpQuery(null);
        }
        if (this.help != null) {
            this.help.show(this.out);
            return true;
        }
        Diff diff = this.superMode ? new SuperDiff(this.fileArgs.get(0)) : new StandardDiff(this.fileArgs);
        diff.out = this.out;
        diff.includeReason = this.includeReason;
        diff.format = this.format;
        diff.title = this.title;
        return diff.report(this.outFile);
    }

    private static void exit(int n) {
        System.exit(n);
    }

    public static class Ant
    extends MatchingTask {
        private final Main m = new Main();
        private final List<Commandline.Argument> args = new ArrayList<Commandline.Argument>();
        private String format;
        private File outFile;
        private String title;
        private boolean failOnError = true;
        private String resultProperty;

        public void setFormat(String string) {
            this.format = string;
        }

        public void setOutFile(File file) {
            this.outFile = file;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setResultProperty(String string) {
            this.resultProperty = string;
        }

        public void setFailOnError(boolean bl) {
            this.failOnError = bl;
        }

        public void addArg(Commandline.Argument argument) {
            this.args.add(argument);
        }

        public void execute() {
            try {
                AntOptionDecoder antOptionDecoder = new AntOptionDecoder(this.m.options);
                antOptionDecoder.process("format", this.format);
                antOptionDecoder.process("outFile", this.outFile);
                antOptionDecoder.process("title", this.title);
                if (this.args.size() > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Commandline.Argument argument : this.args) {
                        arrayList.addAll(Arrays.asList(argument.getParts()));
                    }
                    antOptionDecoder.decodeArgs(arrayList);
                }
                boolean bl = this.m.run();
                if (this.resultProperty != null) {
                    Project project = this.getProject();
                    project.setProperty(this.resultProperty, String.valueOf(bl ? 0 : 1));
                }
                if (this.failOnError && !bl) {
                    throw new BuildException(i18n.getString("main.diffsFound"));
                }
            }
            catch (Fault | BadArgs exception) {
                throw new BuildException(exception.getMessage(), (Throwable)exception);
            }
            catch (InterruptedException interruptedException) {
                throw new BuildException(i18n.getString("main.interrupted"), (Throwable)interruptedException);
            }
        }
    }
}

