/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.JCovSocketSaver;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;

public class JCovSESocketSaver
extends JCovSocketSaver {
    public static final String NETWORK_DEF_PROPERTIES_FILENAME = "jcov_network_default.properties";
    public static final String PORT_PROPERTIES_NAME = "port";
    public static final String HOST_PROPERTIES_NAME = "host";

    @Override
    public synchronized void saveResults() {
        try {
            this.host = JCovSESocketSaver.detectHost();
            this.port = JCovSESocketSaver.detectPort();
            String testname = PropertyFinder.findValue("testname", null);
            if (testname == null) {
                testname = PropertyFinder.findValue("file", "result.xml");
            } else if ("<jcov.ignore>".equals(testname)) {
                return;
            }
            int count = 0;
            long[] data = Collect.counts();
            long[] dataVal = new long[data.length];
            int[] dataIdx = new int[data.length];
            int lastIndex = 0;
            for (int i = 0; i < 2000000; ++i) {
                if (data[i] == 0L) continue;
                dataIdx[count] = i;
                dataVal[count] = data[i];
                lastIndex = i;
                ++count;
            }
            Socket s = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    s = new Socket(this.host, this.port);
                }
                catch (UnknownHostException e) {
                    System.err.println("JCovRT: Can't resolve hostname " + this.host + " - unknown host. Exiting. ");
                    return;
                }
                catch (Throwable e) {
                    System.err.println("Attempt to connect to " + this.host + ":" + this.port + " failed: ");
                    System.err.println(e.getMessage());
                }
                if (s != null) break;
                Thread.sleep(3000L);
            }
            if (s == null) {
                return;
            }
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            out.write(new byte[]{74, 67, 79, 86});
            out.write(0);
            out.writeUTF(System.getProperty("user.name"));
            out.writeUTF(testname);
            out.writeUTF(PropertyFinder.findValue("product", ""));
            out.writeBoolean(false);
            out.writeUTF("NIY");
            out.writeInt(count);
            out.writeInt(lastIndex);
            for (int j = 0; j < count; ++j) {
                out.writeInt(dataIdx[j]);
                out.writeLong(dataVal[j]);
            }
            out.close();
            s.close();
        }
        catch (InterruptedException testname) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        File defProperties;
        File file = null;
        String urlString = "";
        URL url = ClassLoader.getSystemClassLoader().getResource(JCovSESocketSaver.class.getCanonicalName().replaceAll("\\.", "/") + ".class");
        if (url != null) {
            urlString = url.toString();
            if (urlString.contains("file:") && urlString.contains("!")) {
                urlString = urlString.substring(urlString.indexOf("file:"), urlString.indexOf(33));
            }
            urlString = urlString.replaceAll("jrt:", "file:");
            try {
                url = new URL(urlString);
                file = new File(url.toURI());
            }
            catch (Exception e) {
                System.err.println("Error while finding " + urlString + " file: " + e);
            }
        }
        if (file == null) {
            file = new File(System.getProperty("java.home") + File.separator + NETWORK_DEF_PROPERTIES_FILENAME);
        }
        if (file != null && file.exists() && (defProperties = new File(file.getParent() + File.separator + NETWORK_DEF_PROPERTIES_FILENAME)).exists()) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(defProperties));
                if (prop.getProperty(PORT_PROPERTIES_NAME) != null) {
                    JCovSESocketSaver.setDefaultPort(Integer.valueOf(prop.getProperty(PORT_PROPERTIES_NAME)));
                }
                if (prop.getProperty(HOST_PROPERTIES_NAME) != null) {
                    JCovSESocketSaver.setDefaultHost(prop.getProperty(HOST_PROPERTIES_NAME));
                }
            }
            catch (Exception e) {
                System.err.println("Error while reading " + defProperties.getAbsolutePath() + " file: " + e);
            }
        }
    }
}

