/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.JCovSaver;
import com.sun.tdk.jcov.runtime.SaverDecorator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkSatelliteDecorator
implements SaverDecorator {
    private JCovSaver wrapped;
    private int port = 3337;
    private static String host = "localhost";
    private static Lock lock = new ReentrantLock();
    private Thread socketClientThread = null;
    private volatile String name = null;

    @Override
    public void init(JCovSaver wrap) {
        this.wrapped = wrap;
        this.listenObserver();
    }

    private void listenObserver() {
        this.socketClientThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Socket socket = new Socket(host, NetworkSatelliteDecorator.this.port);
                    BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                    while (true) {
                        String line = null;
                        try {
                            line = in.readLine();
                        }
                        catch (Exception e) {
                            lock.lock();
                            try {
                                Collect.saveResults();
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        if (line == null) continue;
                        if (line.startsWith("NAME")) {
                            NetworkSatelliteDecorator.this.name = line.substring(4, line.length());
                            System.setProperty("jcov.testname", NetworkSatelliteDecorator.this.name);
                            out.println("named " + NetworkSatelliteDecorator.this.name);
                            out.flush();
                            continue;
                        }
                        if (!line.startsWith("SAVE")) continue;
                        NetworkSatelliteDecorator.this.name = line.substring(4, line.length());
                        System.setProperty("jcov.testname", NetworkSatelliteDecorator.this.name);
                        lock.lock();
                        try {
                            Collect.saveResults();
                        }
                        finally {
                            lock.unlock();
                        }
                        out.println("saved " + NetworkSatelliteDecorator.this.name);
                        out.flush();
                        NetworkSatelliteDecorator.this.name = null;
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(NetworkSatelliteDecorator.class.getName()).log(Level.SEVERE, "SocketClient: ", e);
                    return;
                }
            }
        });
        this.socketClientThread.setDaemon(true);
        this.socketClientThread.start();
    }

    @Override
    public void saveResults() {
        while (this.name == null) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.name != null) {
            System.setProperty("jcov.testname", this.name);
            lock.lock();
            try {
                this.wrapped.saveResults();
            }
            finally {
                lock.unlock();
            }
            this.name = null;
        }
    }
}

