/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.CollectDetect;
import com.sun.tdk.jcov.runtime.JCovSaver;
import com.sun.tdk.jcov.runtime.JCovXMLFileSaver;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.util.RuntimeUtils;
import java.io.File;

public abstract class FileSaver
implements JCovSaver {
    static final int LOCK_REPEAT = 50;
    static final int LOCK_SLEEP = 50000;
    protected String filename;
    protected String template;
    protected InstrumentationOptions.MERGE mergeMode;
    protected boolean insertOnly;
    protected DataRoot root;
    protected boolean scales;
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    protected boolean agentdata = false;

    protected static String genUniqFileName(String filename) {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (new File(filename + "." + i).exists()) continue;
            return filename + "." + i;
        }
        throw new Error("It's impossible...");
    }

    protected FileSaver(DataRoot root, InstrumentationOptions.MERGE merge) {
        this.filename = "result.xml";
        this.template = "template.xml";
        this.mergeMode = merge;
        this.root = root;
        this.scales = merge == InstrumentationOptions.MERGE.SCALE;
    }

    protected FileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge, boolean scales) {
        this.filename = filename;
        this.template = template;
        this.mergeMode = merge;
        this.root = root;
        this.scales = scales;
    }

    public abstract void saveResults(String var1) throws Exception;

    abstract void mergeResults(String var1, String var2, boolean var3) throws Exception;

    @Override
    public void saveResults() {
        if (this.root.getParams().isDynamicCollect() && Collect.enabled) {
            CollectDetect.enterInstrumentationCode();
        }
        try {
            if (this.mergeMode.equals((Object)InstrumentationOptions.MERGE.GEN_SUFF)) {
                this.try2MergeAndSave(this.filename + RuntimeUtils.genSuffix(), this.template, this.scales || this.mergeMode == InstrumentationOptions.MERGE.SCALE);
                return;
            }
            if (new File(this.filename).exists() && !this.mergeMode.equals((Object)InstrumentationOptions.MERGE.OVERWRITE)) {
                this.try2MergeAndSave(this.filename, this.filename, this.scales || this.mergeMode == InstrumentationOptions.MERGE.SCALE);
                return;
            }
            this.try2MergeAndSave(this.filename, this.template, this.scales || this.mergeMode == InstrumentationOptions.MERGE.SCALE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.root.getParams().isDynamicCollect() && Collect.enabled) {
                CollectDetect.leaveInstrumentationCode();
            }
        }
    }

    private void try2MergeAndSave(String filename, String mergeSrc, boolean scales) throws Exception {
        boolean srcExists;
        boolean bl = srcExists = mergeSrc != null && new File(mergeSrc).exists();
        if (srcExists) {
            this.mergeResults(filename, mergeSrc, scales);
        } else {
            this.saveResults(filename);
        }
    }

    public static FileSaver getFileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge) {
        return FileSaver.getFileSaver(root, filename, template, merge, false, false);
    }

    public void setAgentData(boolean agentdata) {
        this.agentdata = agentdata;
    }

    public static FileSaver getFileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge, boolean agentData) {
        FileSaver fileSaver = FileSaver.getFileSaver(root, filename, template, merge, false, false);
        fileSaver.agentdata = agentData;
        return fileSaver;
    }

    public static FileSaver getFileSaver(DataRoot root, boolean insertOnly) {
        return FileSaver.getFileSaver(root, "result.xml", "template.xml", InstrumentationOptions.MERGE.MERGE, insertOnly, false);
    }

    public static FileSaver getFileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge, boolean insertOnly, boolean scales) {
        JCovXMLFileSaver saver = new JCovXMLFileSaver(root, filename, template, merge, scales);
        saver.insertOnly = insertOnly;
        return saver;
    }

    public static void setDisableAutoSave(boolean flag) {
        Collect.saveAtShutdownEnabled = !flag;
    }

    public static void addAutoShutdownSave() {
        PropertyFinder.addAutoShutdownSave();
    }
}

