/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.runtime.Collect;

public class CollectDetect
extends Collect {
    static int last = 0;
    static int prelast = 0;
    static ThreadInfo[] info;
    static ThreadInfo prevInfo;
    static ThreadInfo underConstruction;
    static volatile boolean lock;
    private static long[] invokeCounts;

    public static void enableDetectInternal() {
        if (info == null) {
            underConstruction = new ThreadInfo(0L);
            ++CollectDetect.underConstruction.instLevel;
            info = new ThreadInfo[100];
            long id = Thread.currentThread().getId();
            prevInfo = CollectDetect.infoForThread(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadInfo infoForThread(long id) {
        int hash = (int)(id % (long)info.length);
        ThreadInfo ti = info[hash];
        while (ti != null) {
            if (ti.id == id) {
                prevInfo = ti;
                return ti;
            }
            ti = ti.next;
        }
        ThreadInfo threadInfo = underConstruction;
        synchronized (threadInfo) {
            CollectDetect.underConstruction.id = id;
            CollectDetect.underConstruction.next = info[hash];
            CollectDetect.info[hash] = prevInfo = underConstruction;
            ti = new ThreadInfo(id);
            ti.next = CollectDetect.underConstruction.next;
            CollectDetect.info[hash] = prevInfo = ti;
        }
        return ti;
    }

    public static void hit(int slot) {
        long id = Thread.currentThread().getId();
        ThreadInfo ti = prevInfo;
        if (ti.id != id) {
            ti = CollectDetect.infoForThread(id);
        }
        if (ti.enabled()) {
            Collect.hit(slot);
        }
    }

    public static void hit(int slot, int hash, int fullHash) {
        long id = Thread.currentThread().getId();
        ThreadInfo ti = prevInfo;
        if (ti.id != id) {
            ti = CollectDetect.infoForThread(id);
        }
        if (ti.enabled(hash)) {
            ti.expected = 0;
            Collect.hit(slot);
        }
        if (ti.enabledFull(fullHash)) {
            ti.expectedFull = 0;
            Collect.hit(slot);
        }
    }

    public static void enterInstrumentationCode() {
        if (prevInfo != null) {
            long id = Thread.currentThread().getId();
            ThreadInfo ti = prevInfo;
            if (ti.id != id) {
                ti = CollectDetect.infoForThread(id);
            }
            ++ti.instLevel;
        }
    }

    public static void setExpected(int hash) {
        if (prevInfo != null) {
            long id = Thread.currentThread().getId();
            ThreadInfo ti = prevInfo;
            if (ti.id != id) {
                ti = CollectDetect.infoForThread(id);
            }
            ti.expected = hash;
        }
    }

    public static void enterClinit() {
        if (prevInfo != null) {
            long id = Thread.currentThread().getId();
            ThreadInfo ti = prevInfo;
            if (ti.id != id) {
                ti = CollectDetect.infoForThread(id);
            }
            ti.clinitValue = ti.expected;
        }
    }

    public static void leaveClinit() {
        if (prevInfo != null) {
            long id = Thread.currentThread().getId();
            ThreadInfo ti = prevInfo;
            if (ti.id != id) {
                ti = CollectDetect.infoForThread(id);
            }
            ti.expected = ti.clinitValue;
        }
    }

    public static void setExpectedFull(int fullHash) {
        if (prevInfo != null) {
            long id = Thread.currentThread().getId();
            ThreadInfo ti = prevInfo;
            if (ti.id != id) {
                ti = CollectDetect.infoForThread(id);
            }
            ti.expectedFull = fullHash;
        }
    }

    public static void leaveInstrumentationCode() {
        if (prevInfo != null) {
            long id = Thread.currentThread().getId();
            ThreadInfo ti = prevInfo;
            if (ti.id != id) {
                ti = CollectDetect.infoForThread(id);
            }
            --ti.instLevel;
        }
    }

    public static void enableInvokeCounts() {
        invokeCounts = new long[2000000];
    }

    public static void invokeHit(int id) {
        int n = id;
        invokeCounts[n] = invokeCounts[n] + 1L;
    }

    public static boolean wasInvokeHit(int id) {
        return invokeCounts[id] != 0L;
    }

    public static long invokeCountFor(int id) {
        return invokeCounts[id];
    }

    public static void setInvokeCountFor(int id, long count) {
        CollectDetect.invokeCounts[id] = count;
    }

    static {
        lock = false;
        if (info == null) {
            underConstruction = new ThreadInfo(0L);
            ++CollectDetect.underConstruction.instLevel;
            if (Thread.currentThread() != null) {
                info = new ThreadInfo[100];
                long id = Thread.currentThread().getId();
                prevInfo = CollectDetect.infoForThread(id);
            }
        }
        CollectDetect.enableInvokeCounts();
    }

    private static class ThreadInfo {
        public static int MAX_STACK = 1000;
        long id;
        int instLevel;
        int expected = 0;
        int clinitValue = 0;
        int expectedFull;
        ThreadInfo next;

        ThreadInfo(long id) {
            this.id = id;
        }

        private boolean enabled() {
            return this.instLevel == 0;
        }

        private boolean enabled(int i) {
            return (this.expected == i && i != -1 || this.expected == 0 && i == -1 && Collect.isInitialized) && this.instLevel == 0;
        }

        private boolean enabledFull(int i) {
            return this.expectedFull == i && this.instLevel == 0;
        }
    }
}

