/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.ancfilters;

import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.report.ParameterizedAncFilter;
import com.sun.tdk.jcov.report.ancfilters.DefaultAncFilter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ListANCFilter
implements DefaultAncFilter,
ParameterizedAncFilter {
    private static final String COMMENT_PREFIX = "#";
    private static final String CLASS_METHOD_SEPARATOR = "#";
    private Map<String, Set<String>> excludes;
    private String ancReason;

    @Override
    public boolean accept(DataClass dc) {
        this.assertInitialized();
        return false;
    }

    private void assertInitialized() {
        if (this.excludes == null) {
            throw new IllegalStateException("No ANC list was provided");
        }
    }

    @Override
    public boolean accept(DataClass dc, DataMethod dm) {
        Set<String> methods;
        this.assertInitialized();
        String className = dc.getFullname();
        String methodName = dm.getName();
        int dot = methodName.indexOf(".");
        if (dot > -1) {
            className = className + methodName.substring(0, dot);
            methodName = methodName.substring(dot + 1);
        }
        return (methods = this.excludes.get(className)) != null && methods.contains(methodName + dm.getVmSignature());
    }

    @Override
    public boolean accept(DataMethod dm, DataBlock db) {
        this.assertInitialized();
        return false;
    }

    @Override
    public String getAncReason() {
        this.assertInitialized();
        return this.ancReason;
    }

    @Override
    public String getFilterName() {
        return "list";
    }

    @Override
    public void setParameter(String parameter) throws IOException {
        if (parameter == null) {
            throw new IllegalArgumentException("File must not be null for list filter.");
        }
        this.excludes = new HashMap<String, Set<String>>();
        try (BufferedReader in = new BufferedReader(new FileReader(parameter));){
            String line = in.readLine();
            if (line != null && line.startsWith("#")) {
                this.ancReason = line.substring("#".length());
            } else {
                throw new IllegalStateException("No ANC reason was provided.");
            }
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                int separator = line.indexOf("#");
                if (separator > -1) {
                    String clss = line.substring(0, separator);
                    Set<String> mthds = this.excludes.get(clss);
                    if (mthds == null) {
                        mthds = new HashSet<String>();
                        this.excludes.put(clss, mthds);
                    }
                    mthds.add(line.substring(separator + 1));
                    continue;
                }
                if (line.length() <= 0) continue;
                throw new IllegalStateException("Unidentifiable method " + line);
            }
        }
    }
}

