/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.report.AncFilter;
import com.sun.tdk.jcov.report.ClassCoverage;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.ProductCoverage;
import com.sun.tdk.jcov.report.javap.JavapClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PackageCoverage
extends AbstractCoverage
implements Iterable<ClassCoverage> {
    private String name;
    private List<ClassCoverage> classCoverageList;
    private DataType[] supportedColumns = new DataType[]{DataType.CLASS, DataType.METHOD, DataType.BLOCK, DataType.BRANCH, DataType.LINE};

    public PackageCoverage(DataRoot fileImage, String name, String[] srcRoots, ProductCoverage.CoverageFilter filter, AncFilter[] ancfilters) {
        this(fileImage, name, srcRoots, null, filter, ancfilters);
    }

    public PackageCoverage(DataRoot fileImage, String name, String[] srcRoots, List<JavapClass> javapClasses, ProductCoverage.CoverageFilter filter, AncFilter[] ancfilters) {
        this(fileImage, name, srcRoots, null, filter, ancfilters, false);
    }

    public PackageCoverage(DataRoot fileImage, String name, String[] srcRoots, List<JavapClass> javapClasses, ProductCoverage.CoverageFilter filter, AncFilter[] ancfilters, boolean anonym) {
        this.name = name;
        this.classCoverageList = this._getClassCoverageList(fileImage, srcRoots, javapClasses, filter, ancfilters, anonym);
        if (this.classCoverageList != null) {
            Collections.sort(this.classCoverageList);
        }
    }

    public List<ClassCoverage> getClasses() {
        return this.classCoverageList;
    }

    private List<ClassCoverage> _getClassCoverageList(DataRoot fileImage, String[] srcRoots, List<JavapClass> javapClasses, ProductCoverage.CoverageFilter filter, AncFilter[] ancfilters, boolean anonym) {
        ArrayList<ClassCoverage> result = new ArrayList<ClassCoverage>();
        DataPackage pkg = fileImage.findPackage(this.name, "");
        for (DataClass cls : pkg.getClasses()) {
            ClassCoverage cc = new ClassCoverage(cls, srcRoots, javapClasses, filter, ancfilters, anonym);
            if (filter != null && !filter.accept(cc)) continue;
            result.add(cc);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageCoverage other = (PackageCoverage)obj;
        return this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public CoverageData getData(DataType column) {
        return this.getData(column, -1);
    }

    @Override
    public CoverageData getData(DataType column, int testNumber) {
        switch (column) {
            case CLASS: 
            case METHOD: 
            case FIELD: 
            case BLOCK: 
            case BRANCH: 
            case LINE: {
                CoverageData covered = new CoverageData();
                for (ClassCoverage classCoverage : this.getClasses()) {
                    if (testNumber < 0 || classCoverage.isCoveredByTest(testNumber)) {
                        covered.add(classCoverage.getData(column, testNumber));
                        continue;
                    }
                    covered.add(new CoverageData(0, 0, classCoverage.getData(column, testNumber).getTotal()));
                }
                return covered;
            }
        }
        return new CoverageData();
    }

    @Override
    public DataType getDataType() {
        return DataType.PACKAGE;
    }

    @Override
    protected DataType[] getDataTypes() {
        return this.supportedColumns;
    }

    @Override
    public String getName() {
        return this.name.replace('/', '.');
    }

    @Override
    public boolean isCovered() {
        return this.getData(DataType.CLASS).getCovered() > 0;
    }

    @Override
    public boolean isCoveredByTest(int testnum) {
        for (ClassCoverage c : this.classCoverageList) {
            if (!c.isCoveredByTest(testnum)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ClassCoverage> iterator() {
        return this.classCoverageList.iterator();
    }

    public boolean isEmpty() {
        return this.classCoverageList.isEmpty();
    }
}

