/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.report.CoverageData;
import java.util.HashMap;
import java.util.List;

public class LineCoverage
extends CoverageData {
    final HashMap<Long, Boolean> lines_hits = new HashMap();
    final HashMap<Long, Boolean> lines_ancs = new HashMap();

    public boolean isLineCovered(long lineNum) {
        Boolean isHit = this.lines_hits.get(lineNum);
        return isHit != null && isHit != false;
    }

    public boolean isLineAnc(long lineNum) {
        Boolean isAnc = this.lines_ancs.get(lineNum);
        return isAnc != null && isAnc != false;
    }

    public boolean isCode(long lineNum) {
        return this.lines_hits.get(lineNum) != null;
    }

    void processLineTable(List<DataMethod.LineEntry> lineTable) {
        if (lineTable == null) {
            return;
        }
        for (DataMethod.LineEntry le : lineTable) {
            ++this.total;
            this.lines_hits.put(Long.valueOf(le.line), false);
            this.lines_ancs.put(Long.valueOf(le.line), false);
        }
    }

    public void hitLine(long line) {
        boolean was;
        Boolean wasHit = this.lines_hits.get(line);
        if (wasHit != null && !(was = this.lines_hits.put(line, true).booleanValue())) {
            ++this.covered;
        }
    }

    public void markLineAnc(long line) {
        boolean was;
        Boolean isAnc = this.lines_ancs.get(line);
        if (isAnc != null && !(was = this.lines_ancs.put(line, true).booleanValue())) {
            ++this.anc;
        }
    }

    private void markLineAnc(long line, boolean isAnc) {
        Boolean wasAnc = this.lines_ancs.get(line);
        if (wasAnc != null) {
            if (!wasAnc.booleanValue() && isAnc) {
                ++this.anc;
            } else if (wasAnc.booleanValue() && !isAnc) {
                --this.anc;
            }
            this.lines_ancs.put(line, isAnc || wasAnc != false);
        } else {
            if (isAnc && !this.isLineCovered(line)) {
                ++this.anc;
            }
            this.lines_ancs.put(line, isAnc);
        }
    }

    private void hitLine(long line, boolean isHit) {
        Boolean wasHit = this.lines_hits.get(line);
        if (wasHit != null) {
            if (!wasHit.booleanValue() && isHit) {
                ++this.covered;
            } else if (wasHit.booleanValue() && !isHit) {
                --this.covered;
            }
            this.lines_hits.put(line, isHit || wasHit != false);
        } else {
            if (isHit) {
                ++this.covered;
            }
            ++this.total;
            this.lines_hits.put(line, isHit);
        }
    }

    void processLineCoverage(LineCoverage lineCov) {
        for (long line : lineCov.lines_hits.keySet()) {
            this.hitLine(line, lineCov.lines_hits.get(line));
        }
        for (long line : lineCov.lines_ancs.keySet()) {
            this.markLineAnc(line, lineCov.lines_ancs.get(line));
        }
    }

    public long firstLine() {
        long firstLine = -1L;
        for (long lineNum : this.lines_hits.keySet()) {
            if (firstLine >= 0L && lineNum >= firstLine) continue;
            firstLine = lineNum;
        }
        return firstLine < 0L ? 1L : firstLine;
    }

    public long lastLine() {
        long lastLine = -1L;
        for (long lineNum : this.lines_hits.keySet()) {
            if (lastLine >= 0L && lineNum <= lastLine) continue;
            lastLine = lineNum;
        }
        return lastLine < 0L ? 1L : lastLine;
    }
}

