/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.MemberCoverage;
import java.util.Arrays;

public class FieldCoverage
extends MemberCoverage {
    private DataType[] supportedColumns = new DataType[]{DataType.FIELD};

    public FieldCoverage(DataField fld) {
        this.count = fld.getCount();
        this.startLine = 0;
        this.modifiers = Arrays.deepToString(fld.getAccessFlags());
        this.name = fld.getName();
        this.signature = fld.getSignature();
        this.scale = fld.getScale();
        this.access = fld.getAccess();
    }

    @Override
    public DataType getDataType() {
        return DataType.FIELD;
    }

    @Override
    public CoverageData getData(DataType column) {
        return this.getData(column, -1);
    }

    @Override
    public CoverageData getData(DataType column, int testNumber) {
        switch (column) {
            case FIELD: {
                return new CoverageData(this.count > 0L ? 1 : 0, 0, 1);
            }
        }
        return new CoverageData();
    }

    @Override
    protected DataType[] getDataTypes() {
        return this.supportedColumns;
    }
}

