/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.io;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.ScaleOptions;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.tools.SimpleScaleCompressor;
import com.sun.tdk.jcov.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class Reader {
    protected static final int IO_BUF_SIZE = 524288;

    public static BufferedReader openFile4Reading(String filename) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), Charset.forName("UTF-8")), 524288);
    }

    public static DataRoot readXML(String fileName) throws FileFormatException {
        return Reader.readXML(fileName, true, null);
    }

    public static DataRoot readXML(InputStream is) throws FileFormatException {
        return Reader.readXML(is, true, null);
    }

    public static DataRoot readXML(String fileName, boolean read_scales, MemberFilter filter) throws FileFormatException {
        FileInputStream in = null;
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                throw new FileFormatException("File " + fileName + " doesn''t exist");
            }
            in = new FileInputStream(f);
            DataRoot dataRoot = Reader.readXML(in, read_scales, filter);
            dataRoot.setStorageFileName(fileName);
            in.close();
            in = null;
            DataRoot dataRoot2 = dataRoot;
            return dataRoot2;
        }
        catch (Exception e) {
            if (!(e instanceof FileFormatException)) {
                throw new FileFormatException(e.getMessage(), e);
            }
            throw (FileFormatException)e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static DataRoot readXML(InputStream input, boolean read_scales, MemberFilter filter) throws FileFormatException {
        DataRoot root = new DataRoot("", false);
        ScaleOptions scaleOpts = new ScaleOptions(read_scales, 0, new SimpleScaleCompressor());
        root.setScaleOpts(scaleOpts);
        root.setAcceptor(filter);
        ReaderFactory rf = ReaderFactory.newInstance(Utils.getJavaVersion(), input);
        root.setReaderFactory(rf);
        root.readDataFrom();
        if (read_scales && scaleOpts.getScaleSize() == 0) {
            root.createScales();
        }
        return root;
    }

    public static DataRoot readXMLHeader(String fileName) throws FileFormatException {
        try {
            return Reader.readXMLHeader(new FileInputStream(fileName));
        }
        catch (FileNotFoundException ex) {
            throw new FileFormatException(ex.getMessage());
        }
    }

    public static DataRoot readXMLHeader(InputStream input) throws FileFormatException {
        DataRoot root = new DataRoot("", false);
        ReaderFactory rf = ReaderFactory.newInstance(Utils.getJavaVersion(), input);
        root.setReaderFactory(rf);
        root.readHeader();
        return root;
    }
}

