/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;

public class HashesAttribute
extends Attribute {
    private String algorithm;
    private Map<String, byte[]> nameToHash;

    HashesAttribute(String algorithm, Map<String, byte[]> nameToHash) {
        super("ModuleHashes");
        this.algorithm = algorithm;
        this.nameToHash = nameToHash;
    }

    public HashesAttribute() {
        this(null, null);
    }

    @Override
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        String algorithm = cr.readUTF8(off, buf);
        int hash_count = cr.readUnsignedShort(off += 2);
        off += 2;
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (int i = 0; i < hash_count; ++i) {
            String mn = cr.readModule(off, buf);
            int hash_length = cr.readUnsignedShort(off += 2);
            off += 2;
            byte[] hash = new byte[hash_length];
            for (int j = 0; j < hash_length; ++j) {
                hash[j] = (byte)(0xFF & cr.readByte(off + j));
            }
            off += hash_length;
            map.put(mn, hash);
        }
        return new HashesAttribute(algorithm, map);
    }

    @Override
    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector attr = new ByteVector();
        int index = cw.newUTF8(this.algorithm);
        attr.putShort(index);
        attr.putShort(0);
        return attr;
    }
}

