/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.CharacterRangeTableAttribute;
import com.sun.tdk.jcov.instrument.DataBlockFallThrough;
import com.sun.tdk.jcov.instrument.DataBlockTargetDefault;
import com.sun.tdk.jcov.instrument.DataBranchCond;
import com.sun.tdk.jcov.instrument.DataBranchGoto;
import com.sun.tdk.jcov.instrument.DataBranchSwitch;
import com.sun.tdk.jcov.instrument.DataExit;
import com.sun.tdk.jcov.instrument.DataExitSimple;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.Instrumenter;
import com.sun.tdk.jcov.instrument.OffsetRecordingMethodAdapter;
import com.sun.tdk.jcov.instrument.SimpleBasicBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

class BlockCodeMethodAdapter
extends OffsetRecordingMethodAdapter {
    private final MethodVisitor nextVisitor;
    private final List<DataExit> exits;
    private final Map<AbstractInsnNode, SimpleBasicBlock> insnToBB;
    private final InstrumentationParams params;

    public BlockCodeMethodAdapter(MethodVisitor mv, DataMethodWithBlocks method, InstrumentationParams params) {
        super(new MethodNode(method.getAccess(), method.getName(), method.getVmSignature(), method.getSignature(), method.getExceptions()), method);
        this.nextVisitor = mv;
        this.insnToBB = new IdentityHashMap<AbstractInsnNode, SimpleBasicBlock>();
        this.exits = new ArrayList<DataExit>();
        this.params = params;
    }

    private SimpleBasicBlock getBB(AbstractInsnNode insn, int startBCI) {
        SimpleBasicBlock bb = this.insnToBB.get(insn);
        if (bb == null) {
            bb = new SimpleBasicBlock(this.method.rootId, startBCI);
            this.insnToBB.put(insn, bb);
        } else if (startBCI >= 0) {
            bb.setStartBCI(startBCI);
        }
        return bb;
    }

    private SimpleBasicBlock getBB(AbstractInsnNode insn) {
        return this.getBB(insn, -1);
    }

    private AbstractInsnNode peek(ListIterator iit) {
        if (iit.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iit.next();
            iit.previous();
            return insn;
        }
        return null;
    }

    private SimpleBasicBlock[] completeComputationOfCodeLabelNodes() {
        MethodNode methodNode = (MethodNode)this.mv;
        InsnList instructions = methodNode.instructions;
        int[] allToReal = new int[instructions.size()];
        int allIdx = 0;
        int insnIdx = 0;
        ListIterator<AbstractInsnNode> iit = instructions.iterator();
        AbstractInsnNode insnFirst = this.peek(iit);
        SimpleBasicBlock bbFirst = this.getBB(insnFirst, 0);
        while (iit.hasNext()) {
            AbstractInsnNode insn = iit.next();
            allToReal[allIdx++] = insnIdx;
            int bci = this.bcis[insnIdx];
            int opcode = insn.getOpcode();
            if (opcode < 0) {
                if (insn.getType() != 15) continue;
                LineNumberNode lineNode = (LineNumberNode)insn;
                this.method().addLineEntry(bci, lineNode.line);
                continue;
            }
            ++insnIdx;
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 168: 
                case 198: 
                case 199: {
                    JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                    LabelNode insnTrue = jumpInsn.label;
                    int bciFalse = this.bcis[insnIdx];
                    DataBranchCond branch = new DataBranchCond(this.method.rootId, bci, bciFalse - 1);
                    AbstractInsnNode insnFalse = this.peek(iit);
                    assert (insnFalse != null);
                    SimpleBasicBlock bbTrue = this.getBB(insnTrue);
                    SimpleBasicBlock bbFalse = this.getBB(insnFalse, bciFalse);
                    this.exits.add(branch);
                    break;
                }
                case 170: {
                    LabelNode labCase;
                    TableSwitchInsnNode switchInsn = (TableSwitchInsnNode)insn;
                    LabelNode insnDflt = switchInsn.dflt;
                    SimpleBasicBlock bbDefault = this.getBB(insnDflt);
                    DataBlockTargetDefault blockDefault = new DataBlockTargetDefault(bbDefault.rootId());
                    int bciEnd = this.bcis[insnIdx] - 1;
                    DataBranchSwitch branch = new DataBranchSwitch(this.method.rootId, bci, bciEnd, blockDefault);
                    this.exits.add(branch);
                    ListIterator<LabelNode> lit = switchInsn.labels.listIterator();
                    int key = switchInsn.min;
                    while (lit.hasNext()) {
                        labCase = lit.next();
                        SimpleBasicBlock simpleBasicBlock = this.getBB(labCase);
                    }
                    break;
                }
                case 171: {
                    LabelNode labCase;
                    LookupSwitchInsnNode switchInsn = (LookupSwitchInsnNode)insn;
                    LabelNode insnDflt = switchInsn.dflt;
                    SimpleBasicBlock bbDefault = this.getBB(insnDflt);
                    DataBlockTargetDefault blockDefault = new DataBlockTargetDefault(bbDefault.rootId());
                    int bciEnd = this.bcis[insnIdx] - 1;
                    DataBranchSwitch branch = new DataBranchSwitch(this.method.rootId, bci, bciEnd, blockDefault);
                    this.exits.add(branch);
                    ListIterator<Integer> kit = switchInsn.keys.listIterator();
                    ListIterator<LabelNode> lit = switchInsn.labels.listIterator();
                    while (lit.hasNext()) {
                        labCase = lit.next();
                        SimpleBasicBlock bbCase = this.getBB(labCase);
                        Integer n = kit.next();
                    }
                    break;
                }
                case 167: {
                    JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                    int bciEnd = this.bcis[insnIdx] - 1;
                    DataBranchGoto branch = new DataBranchGoto(this.method.rootId, bci, bciEnd);
                    this.exits.add(branch);
                    CharacterRangeTableAttribute.CRTEntry[] insnTarget = jumpInsn.label;
                    SimpleBasicBlock bbTarget = this.getBB((AbstractInsnNode)insnTarget);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    int bciNext = this.bcis[insnIdx];
                    DataExitSimple exit = new DataExitSimple(this.method.rootId, bci, bciNext - 1, insn.getOpcode());
                    this.exits.add(exit);
                    AbstractInsnNode insnNext = this.peek(iit);
                    if (insnNext == null) break;
                    this.getBB(insnNext, bciNext);
                    break;
                }
            }
        }
        LabelNode previousHandler = null;
        for (TryCatchBlockNode tcbn : methodNode.tryCatchBlocks) {
            LabelNode insnHandler = tcbn.handler;
            if (insnHandler == previousHandler) continue;
            previousHandler = insnHandler;
            SimpleBasicBlock exit = this.getBB(insnHandler);
        }
        if (this.method().getCharacterRangeTable() != null) {
            boolean newBlock = true;
            int skip = 0;
            iit = instructions.iterator();
            block11: while (iit.hasNext()) {
                AbstractInsnNode insn = iit.next();
                int index = instructions.indexOf(insn);
                int bci = this.bcis[allToReal[index]];
                if (bci == skip) continue;
                if (this.insnToBB.get(insn) != null) {
                    skip = this.bcis[allToReal[instructions.indexOf(insn)]];
                }
                if (insn.getOpcode() < 0) continue;
                for (CharacterRangeTableAttribute.CRTEntry entry : this.method().getCharacterRangeTable().getEntries()) {
                    if (entry.startBCI() == bci) {
                        if ((entry.flags & 1) == 0) continue;
                        newBlock = false;
                        if (this.insnToBB.get(insn) != null) continue;
                        this.getBB(insn);
                        continue block11;
                    }
                    if (entry.endBCI() != index || (entry.flags & 0x10) == 0) continue;
                    newBlock = true;
                }
            }
        }
        Object[] basicBlocks = new SimpleBasicBlock[this.insnToBB.size()];
        int i = 0;
        for (Map.Entry<AbstractInsnNode, SimpleBasicBlock> entry : this.insnToBB.entrySet()) {
            SimpleBasicBlock bb = entry.getValue();
            if (bb.startBCI() < 0) {
                AbstractInsnNode insn = entry.getKey();
                int index = instructions.indexOf(insn);
                int bci = this.bcis[allToReal[index]];
                bb.setStartBCI(bci);
            }
            basicBlocks[i++] = bb;
        }
        Arrays.sort(basicBlocks);
        return basicBlocks;
    }

    private void computeEndBCIsAndFoldInExits(SimpleBasicBlock[] basicBlocks) {
        int ei = 0;
        SimpleBasicBlock prev = basicBlocks[0];
        for (int bi = 1; bi <= basicBlocks.length; ++bi) {
            int exitStart;
            int start;
            SimpleBasicBlock curr = null;
            if (bi == basicBlocks.length) {
                start = this.method().getBytecodeLength();
            } else {
                curr = basicBlocks[bi];
                start = curr.startBCI();
            }
            int prevStart = prev.startBCI();
            int prevEnd = start - 1;
            prev.setEndBCI(prevEnd);
            DataExit exit = null;
            if (ei < this.exits.size()) {
                exit = this.exits.get(ei);
                exitStart = exit.startBCI();
            } else {
                exitStart = -1;
            }
            if (exitStart >= prevStart && exitStart <= prevEnd) {
                prev.setExit(exit);
                ++ei;
            } else if (curr != null) {
                DataBlockFallThrough fall = new DataBlockFallThrough(curr.rootId());
                curr.add(fall);
            }
            prev = curr;
        }
        assert (ei == this.exits.size());
    }

    private void insertInstrumentation() {
        MethodNode methodNode = (MethodNode)this.mv;
        InsnList instructions = methodNode.instructions;
        for (Map.Entry<AbstractInsnNode, SimpleBasicBlock> entry : this.insnToBB.entrySet()) {
            AbstractInsnNode insn = entry.getKey();
            SimpleBasicBlock bb = entry.getValue();
            instructions.insert(insn, Instrumenter.instrumentation(bb, this.params.isDetectInternal()));
        }
    }

    @Override
    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        if (attr instanceof CharacterRangeTableAttribute) {
            this.method().setCharacterRangeTable((CharacterRangeTableAttribute)attr);
        }
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        BasicBlock[] basicBlocks = this.completeComputationOfCodeLabelNodes();
        this.computeEndBCIsAndFoldInExits((SimpleBasicBlock[])basicBlocks);
        this.insertInstrumentation();
        this.method().setBasicBlocks(basicBlocks);
        MethodNode methodNode = (MethodNode)this.mv;
        methodNode.accept(this.nextVisitor);
    }
}

