/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.Merger;
import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.filter.ConveyerFilter;
import com.sun.tdk.jcov.filter.FilterFactory;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.io.ClassSignatureFilter;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.processing.DataProcessorSPI;
import com.sun.tdk.jcov.processing.DefaultDataProcessorSPI;
import com.sun.tdk.jcov.processing.ProcessingException;
import com.sun.tdk.jcov.processing.StubSpi;
import com.sun.tdk.jcov.report.AncFilter;
import com.sun.tdk.jcov.report.DefaultReportGeneratorSPI;
import com.sun.tdk.jcov.report.ParameterizedAncFilter;
import com.sun.tdk.jcov.report.ProductCoverage;
import com.sun.tdk.jcov.report.ReportGenerator;
import com.sun.tdk.jcov.report.ReportGeneratorSPI;
import com.sun.tdk.jcov.report.SmartTestService;
import com.sun.tdk.jcov.report.ancfilters.DefaultAncFilter;
import com.sun.tdk.jcov.report.javap.JavapClass;
import com.sun.tdk.jcov.report.javap.JavapRepGen;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.tools.SPIDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepGen
extends JCovCMDTool {
    static final String CUSTOM_REPORT_GENERATOR_SPI = "customreport.spi";
    static final String DATA_PROCESSOR_SPI = "dataprocessor.spi";
    private static final String ANC_FILTER_PARAMETER_SEPARATOR = ":";
    private static final Logger logger;
    private boolean noEnums = false;
    private boolean showFields = false;
    private ReportGeneratorSPI[] reportGeneratorSPIs;
    private DataProcessorSPI[] dataProcessorSPIs;
    private String[] include = new String[]{".*"};
    private String[] exclude = new String[]{""};
    private String[] m_include = new String[]{".*"};
    private String[] m_exclude = new String[]{""};
    private String[] fms = null;
    private String filter = null;
    private String[] ancfilters = null;
    private String[] ancdeffilters = null;
    private boolean noAbstract = false;
    private boolean syntheticOn = false;
    private boolean isPublicAPI = false;
    private String[] filenames;
    private String name;
    private String outputDir;
    private String testlist;
    private String srcRootPath;
    private boolean anonym = false;
    private boolean withTestsInfo = false;
    private String classesPath;
    private AncFilter[] ancfiltersClasses = null;
    private String mainReportTitle = null;
    private String overviewListTitle = null;
    private String entitiesTitle = null;
    static final OptionDescr DSC_FMT;
    public static final OptionDescr DSC_OUTPUT;
    public static final OptionDescr DSC_TEST_LIST;
    static final OptionDescr DSC_FILTER_PLUGIN;
    static final OptionDescr DSC_ANC_FILTER_PLUGINS;
    static final OptionDescr DSC_ANC_DEFAULT_FILTERS;
    public static final OptionDescr DSC_SRC_ROOT;
    static final OptionDescr DSC_VERBOSE;
    public static final OptionDescr DSC_NO_ABSTRACT;
    public static final OptionDescr DSC_SYNTHETIC_ON;
    public static final OptionDescr DSC_PUBLIC_API;
    public static final OptionDescr DSC_ANONYM;
    public static final OptionDescr DSC_JAVAP;
    public static final OptionDescr DSC_TESTS_INFO;
    public static final OptionDescr DSC_REPORT_TITLE_MAIN;
    public static final OptionDescr DSC_REPORT_TITLE_OVERVIEW;
    public static final OptionDescr DSC_REPORT_TITLE_ENTITIES;

    public RepGen() {
        this.readPlugins = true;
    }

    public void generateReport(String output, Result jcovResult) throws ProcessingException, FileFormatException, Exception {
        this.generateReport(this.getDefaultReportGenerator(), output, jcovResult, null);
    }

    public void generateReport(String format, String output, Result jcovResult) throws ProcessingException, FileFormatException, Exception {
        this.generateReport(format, output, jcovResult, null);
    }

    public void generateReport(String format, String output, Result jcovResult, String srcRootPath) throws ProcessingException, FileFormatException, Exception {
        ReportGenerator rg = null;
        rg = format != null ? this.findReportGenerator(format) : this.getDefaultReportGenerator();
        if (rg == null) {
            throw new Exception("Specified ReportGenerator name (" + format + ") was not found");
        }
        this.generateReport(rg, output, jcovResult, srcRootPath);
    }

    public void generateReport(ReportGenerator rg, String output, Result jcovResult, String srcRootPath) throws ProcessingException, FileFormatException, Exception {
        this.generateReport(rg, output, jcovResult, srcRootPath, null);
    }

    public void generateReport(ReportGenerator rg, String output, Result jcovResult, String srcRootPath, List<JavapClass> classes) throws ProcessingException, FileFormatException, Exception {
        try {
            logger.log(Level.INFO, "-- Writing report to {0}", output);
            rg.init(output);
            logger.fine("OK");
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Error while reading output file by ReportGenerator " + rg.getClass().getName(), ex);
            return;
        }
        logger.log(Level.INFO, "-- Reading data from {0}", jcovResult.getResultPath());
        DataRoot file_image = this.readDataRootFile(jcovResult.getResultPath(), jcovResult.isTestListSet(), this.include, this.exclude, this.fms);
        if (!this.syntheticOn) {
            file_image.applyFilter(new ANC_FILTER());
        }
        Object customFilter = null;
        if (this.filter != null) {
            logger.fine("-- Initializing custom filter");
            customFilter = this.initCustomFilter(this.filter, null);
            logger.fine("OK");
        }
        if (customFilter != null) {
            logger.log(Level.INFO, "-- Applying filter {0}", customFilter.getClass().getName());
            file_image.applyFilter((MemberFilter)customFilter);
            logger.fine("OK");
        }
        if (this.ancfilters != null) {
            this.ancfiltersClasses = new AncFilter[this.ancfilters.length];
            for (int i = 0; i < this.ancfilters.length; ++i) {
                try {
                    String ancfilter = this.ancfilters[i];
                    Class<?> ancFilteClass = Class.forName(ancfilter);
                    this.ancfiltersClasses[i] = (AncFilter)ancFilteClass.newInstance();
                    continue;
                }
                catch (Exception e) {
                    throw new Error("Cannot create an instance of AncFilter: ", e);
                }
            }
        }
        if (this.ancdeffilters != null) {
            ServiceLoader<DefaultAncFilter> loader = ServiceLoader.load(DefaultAncFilter.class);
            ArrayList<AncFilter> defaultANCFiltersList = new ArrayList<AncFilter>();
            if (this.ancfiltersClasses != null && this.ancfiltersClasses.length > 0) {
                defaultANCFiltersList.addAll(Arrays.asList(this.ancfiltersClasses));
            }
            if (this.ancdeffilters.length == 1 && this.ancdeffilters[0].equals("all")) {
                for (DefaultAncFilter filter : loader) {
                    if (filter instanceof ParameterizedAncFilter) continue;
                    defaultANCFiltersList.add(filter);
                }
            } else {
                for (String defaulAncFilter : this.ancdeffilters) {
                    boolean found = false;
                    for (DefaultAncFilter filter : loader) {
                        String filterParameters;
                        String filterName;
                        int separatorPosition = defaulAncFilter.indexOf(ANC_FILTER_PARAMETER_SEPARATOR);
                        if (separatorPosition > -1) {
                            filterName = defaulAncFilter.substring(0, separatorPosition);
                            filterParameters = defaulAncFilter.substring(separatorPosition + ANC_FILTER_PARAMETER_SEPARATOR.length());
                        } else {
                            filterName = defaulAncFilter;
                            filterParameters = null;
                        }
                        if (!filterName.equals(filter.getFilterName())) continue;
                        if (filterParameters != null) {
                            if (filter instanceof ParameterizedAncFilter) {
                                try {
                                    ((ParameterizedAncFilter)((Object)filter)).setParameter(filterParameters);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Unable to set parameter for filter " + (String)filterName + ANC_FILTER_PARAMETER_SEPARATOR + e.getMessage());
                                }
                            } else {
                                throw new RuntimeException((String)filterName + " filter does not accept parameters: " + filter);
                            }
                        }
                        found = true;
                        defaultANCFiltersList.add(filter);
                        break;
                    }
                    if (found) continue;
                    throw new RuntimeException("There is no default ANC filter for \"" + (String)defaulAncFilter + "\" value");
                }
            }
            this.ancfiltersClasses = defaultANCFiltersList.toArray(new AncFilter[defaultANCFiltersList.size()]);
        }
        if (this.dataProcessorSPIs != null) {
            for (DataProcessorSPI spi : this.dataProcessorSPIs) {
                logger.log(Level.INFO, "-- Applying data processor {0}", spi.getClass());
                file_image = spi.getDataProcessor().process(file_image);
            }
        }
        logger.fine("OK");
        SmartTestService sts = null;
        if (jcovResult.isTestListSet()) {
            logger.fine("-- Initializing test list");
            sts = new SmartTestService(jcovResult.getTestList());
            if (file_image.getScaleOpts().getScaleSize() != sts.getTestCount()) {
                logger.log(Level.SEVERE, "The sizes of tests in JCov file and in test list differ.\nDatafile {0} contains {1} item(s).\nThe test list contains {2} item(s).", new Object[]{jcovResult.getResultPath(), file_image.getScaleOpts().getScaleSize(), sts.getTestCount()});
                throw new Exception("The sizes of tests in JCov file and in test list differ");
            }
            logger.fine("OK");
        }
        ReportGenerator.Options options = new ReportGenerator.Options(srcRootPath, sts, classes, this.withTestsInfo, false, this.mainReportTitle, this.overviewListTitle, this.entitiesTitle);
        options.setInstrMode(file_image.getParams().getMode());
        options.setAnonymOn(this.anonym);
        try {
            ProductCoverage coverage = new ProductCoverage(file_image, options.getSrcRootPaths(), options.getJavapClasses(), this.isPublicAPI, this.noAbstract, this.anonym, this.ancfiltersClasses);
            logger.log(Level.INFO, "- Starting ReportGenerator {0}", rg.getClass().getName());
            rg.generateReport(coverage, options);
        }
        catch (Throwable ex) {
            if (ex.getMessage() != null) {
                throw new Exception("ReportGenerator produced exception " + ex.getMessage(), ex);
            }
            throw new Exception("ReportGenerator produced exception " + ex, ex);
        }
        logger.log(Level.INFO, "- Report generation done");
    }

    public ReportGenerator getDefaultReportGenerator() {
        return this.findReportGenerator("html");
    }

    private ReportGenerator findReportGenerator(String name) {
        ReportGenerator rg = null;
        if (this.reportGeneratorSPIs != null) {
            for (ReportGeneratorSPI reportGeneratorSPI : this.reportGeneratorSPIs) {
                rg = reportGeneratorSPI.getReportGenerator(name);
                if (rg == null) continue;
                return rg;
            }
        }
        return new DefaultReportGeneratorSPI().getReportGenerator(name);
    }

    protected DataRoot readDataRootFile(String filename, boolean readScales, String[] include, String[] exclude, String[] modif) throws FileFormatException {
        DataRoot file_image = null;
        ClassSignatureFilter acceptor = new ClassSignatureFilter(include, exclude, this.m_include, this.m_exclude, modif);
        file_image = Reader.readXML(filename, readScales, (MemberFilter)acceptor);
        return file_image;
    }

    public static void main(String[] args) {
        RepGen tool = new RepGen();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    @Override
    protected String usageString() {
        return "java com.sun.tdk.jcov.RepGen [options] filename";
    }

    @Override
    protected String exampleString() {
        return "java -cp jcov.jar com.sun.tdk.jcov.RepGen -include java.lang.* -format html -output out result.xml";
    }

    @Override
    protected String getDescr() {
        return "generates text or HTML (or custom) reports";
    }

    private MemberFilter createCustomFilter(String spiName) {
        return FilterFactory.getInstance(spiName).getMemberFilter();
    }

    private MemberFilter initCustomFilter(String filter, String sig) {
        MemberFilter customPlugin = null;
        MemberFilter sigFilter = null;
        if (filter != null) {
            customPlugin = this.createCustomFilter(filter);
        }
        if (customPlugin == null && sigFilter == null) {
            return null;
        }
        if (customPlugin != null && sigFilter != null) {
            ConveyerFilter f = new ConveyerFilter();
            f.add(sigFilter);
            f.add(customPlugin);
            return f;
        }
        return sigFilter != null ? sigFilter : customPlugin;
    }

    public void setReportGeneratorSPIs(ReportGeneratorSPI[] reportGeneratorSPI) {
        this.reportGeneratorSPIs = reportGeneratorSPI;
    }

    public ReportGeneratorSPI[] getReportGeneratorSPIs() {
        return this.reportGeneratorSPIs;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String[] getFms() {
        return this.fms;
    }

    public void setFms(String[] fms) {
        this.fms = fms;
    }

    public String[] getInclude() {
        return this.include;
    }

    public void setInclude(String[] include) {
        this.include = include;
    }

    public boolean isIsPublicAPI() {
        return this.isPublicAPI;
    }

    public void setIsPublicAPI(boolean isPublicAPI) {
        this.isPublicAPI = isPublicAPI;
    }

    public boolean isNoAbstract() {
        return this.noAbstract;
    }

    public void setNoAbstract(boolean noAbstract) {
        this.noAbstract = noAbstract;
    }

    public boolean isSyntheticOn() {
        return this.syntheticOn;
    }

    public void setNoANC(boolean syntheticOn) {
        this.syntheticOn = syntheticOn;
    }

    public boolean isWithTestsInfo() {
        return this.withTestsInfo;
    }

    public void setWithTestsInfo(boolean withTestsInfo) {
        this.withTestsInfo = withTestsInfo;
    }

    public boolean isNoEnums() {
        return this.noEnums;
    }

    public void setNoEnums(boolean noEnums) {
        this.noEnums = noEnums;
    }

    public boolean isShowFields() {
        return this.showFields;
    }

    public void setShowFields(boolean showFields) {
    }

    public String[] getExclude() {
        return this.exclude;
    }

    public void setExclude(String[] exclude) {
        this.exclude = exclude;
    }

    public String getSrcRootPath() {
        return this.srcRootPath;
    }

    public void setDataProcessorsSPIs(DataProcessorSPI[] dataProcessorSPIs) {
        this.dataProcessorSPIs = dataProcessorSPIs;
    }

    public void resetDefaults() {
        try {
            this.handleEnv_(this.defineHandler());
            this.reportGeneratorSPIs = null;
            this.setNoAbstract(false);
            this.setIsPublicAPI(false);
        }
        catch (JCovTool.EnvHandlingException envHandlingException) {
            // empty catch block
        }
    }

    public void configure(String[] include, String[] exclude, String[] classModifiers, String filter, boolean generateShortFormat, boolean publicAPI, boolean hideAbstract, boolean hideMethods, boolean hideBlocks, boolean hideBranches, boolean hideLines, boolean hideFields) {
        this.setFilters(include, exclude, classModifiers);
        this.setFilter(filter);
        this.isPublicAPI = publicAPI;
    }

    public void setFilters(String[] include, String[] exclude, String[] classModifiers) {
        if (include == null) {
            include = new String[]{".*"};
        }
        this.include = include;
        if (exclude == null) {
            exclude = new String[]{""};
        }
        this.exclude = exclude;
        this.fms = classModifiers;
    }

    @Override
    protected int run() throws Exception {
        Result r;
        File srcRootPathFile;
        boolean srcZipped = false;
        if (this.srcRootPath != null && (srcRootPathFile = new File(this.srcRootPath)).exists() && srcRootPathFile.isFile() && (this.srcRootPath.endsWith(".zip") || this.srcRootPath.endsWith(".jar"))) {
            srcZipped = true;
            this.srcRootPath = this.outputDir + File.separator + srcRootPathFile.getName().replace(".zip", "").replace(".jar", "");
            Utils.unzipFolder(srcRootPathFile, this.srcRootPath);
        }
        try {
            logger.log(Level.INFO, "-- Reading test list");
            if (this.filenames.length != 1) {
                Merger merger = new Merger();
                Result[] results = Merger.initResults(this.filenames, true);
                Merger.Merge merge = new Merger.Merge(results, null);
                merger.setAddMissing(true);
                merger.setRead_scales(true);
                merger.setDefaultReadingFilter(this.include, this.exclude, this.m_include, this.m_exclude, this.fms);
                merger.merge(merge, this.outputDir, true);
                ReportGenerator rg = this.name != null ? this.findReportGenerator(this.name) : this.getDefaultReportGenerator();
                if (rg == null) {
                    throw new Exception("Specified ReportGenerator name (" + this.name + ") was not found");
                }
                rg.init(this.outputDir);
                String[] tl = this.testlist != null ? Utils.readLines(this.testlist) : merge.getResultTestList();
                SmartTestService sts = new SmartTestService(tl);
                ReportGenerator.Options options = new ReportGenerator.Options(this.srcRootPath, sts, null, true, true, this.mainReportTitle, this.overviewListTitle, this.entitiesTitle);
                try {
                    DataRoot mergedResult = merge.getResult();
                    if (!this.syntheticOn) {
                        mergedResult.applyFilter(new ANC_FILTER());
                    }
                    if (this.dataProcessorSPIs != null) {
                        for (DataProcessorSPI spi : this.dataProcessorSPIs) {
                            logger.log(Level.INFO, "-- Applying data processor {0}", spi.getClass());
                            mergedResult = spi.getDataProcessor().process(mergedResult);
                        }
                    }
                    ProductCoverage coverage = new ProductCoverage(mergedResult, options.getSrcRootPaths(), null, this.isPublicAPI, this.noAbstract, this.ancfiltersClasses);
                    rg.generateReport(coverage, options);
                    if (srcZipped) {
                        Utils.deleteDirectory(new File(this.srcRootPath));
                    }
                }
                catch (Throwable ex) {
                    if (ex.getMessage() != null) {
                        throw new Exception("ReportGenerator produced exception " + ex.getMessage(), ex);
                    }
                    throw new Exception("ReportGenerator produced exception " + ex, ex);
                }
                return 0;
            }
            r = new Result(this.filenames[0], this.testlist);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error while reading testlist", ex);
            return 1;
        }
        if (this.classesPath != null) {
            try {
                logger.log(Level.INFO, "-- Creating javap report");
                this.setDataProcessorsSPIs(null);
                new JavapRepGen(this).run(this.filenames[0], this.classesPath, this.outputDir);
                return 0;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error while creating javap report", ex);
                return 1;
            }
        }
        try {
            this.generateReport(this.name, this.outputDir, r, this.srcRootPath);
            if (srcZipped) {
                Utils.deleteDirectory(new File(this.srcRootPath));
            }
            return 0;
        }
        catch (FileFormatException e) {
            logger.log(Level.SEVERE, e.getMessage(), Arrays.toString(this.filenames));
        }
        catch (ProcessingException e) {
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return 0;
    }

    @Override
    protected EnvHandler defineHandler() {
        EnvHandler envHandler = new EnvHandler(new OptionDescr[]{DSC_FMT, DSC_OUTPUT, InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_MINCLUDE_LIST, InstrumentationOptions.DSC_MEXCLUDE_LIST, InstrumentationOptions.DSC_MINCLUDE, InstrumentationOptions.DSC_MEXCLUDE, InstrumentationOptions.DSC_FM, InstrumentationOptions.DSC_FM_LIST, DSC_NO_ABSTRACT, DSC_SYNTHETIC_ON, DSC_PUBLIC_API, DSC_SRC_ROOT, DSC_VERBOSE, DSC_FILTER_PLUGIN, DSC_ANC_FILTER_PLUGINS, DSC_ANC_DEFAULT_FILTERS, DSC_TEST_LIST, DSC_ANONYM, DSC_JAVAP, DSC_TESTS_INFO, DSC_REPORT_TITLE_MAIN, DSC_REPORT_TITLE_OVERVIEW, DSC_REPORT_TITLE_ENTITIES}, (JCovTool)this);
        SPIDescr spiDescr = new SPIDescr(CUSTOM_REPORT_GENERATOR_SPI, ReportGeneratorSPI.class);
        spiDescr.setDefaultSPI(new DefaultReportGeneratorSPI());
        envHandler.registerSPI(spiDescr);
        spiDescr = new SPIDescr(DATA_PROCESSOR_SPI, DataProcessorSPI.class);
        spiDescr.addPreset("none", new StubSpi());
        spiDescr.setDefaultSPI(new DefaultDataProcessorSPI());
        envHandler.registerSPI(spiDescr);
        return envHandler;
    }

    private int handleEnv_(EnvHandler opts) throws JCovTool.EnvHandlingException {
        ArrayList<DataProcessorSPI> dataProcessors;
        ArrayList<ReportGeneratorSPI> reportGenerators;
        if (opts.isSet(DSC_VERBOSE)) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.SEVERE);
        }
        this.name = opts.getValue(DSC_FMT);
        this.outputDir = opts.getValue(DSC_OUTPUT);
        this.filter = opts.getValue(DSC_FILTER_PLUGIN);
        this.ancfilters = opts.getValues(DSC_ANC_FILTER_PLUGINS);
        this.ancdeffilters = opts.getValues(DSC_ANC_DEFAULT_FILTERS);
        this.noAbstract = opts.isSet(DSC_NO_ABSTRACT);
        this.isPublicAPI = opts.isSet(DSC_PUBLIC_API);
        this.anonym = opts.isSet(DSC_ANONYM);
        this.syntheticOn = opts.isSet(DSC_SYNTHETIC_ON);
        this.include = InstrumentationOptions.handleInclude(opts);
        this.exclude = InstrumentationOptions.handleExclude(opts);
        this.fms = InstrumentationOptions.handleFM(opts);
        this.m_include = InstrumentationOptions.handleMInclude(opts);
        this.m_exclude = InstrumentationOptions.handleMExclude(opts);
        this.testlist = opts.getValue(DSC_TEST_LIST);
        Utils.checkFileCanBeNull(this.testlist, "testlist filename", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_CANREAD, Utils.CheckOptions.FILE_ISFILE);
        this.withTestsInfo = opts.isSet(DSC_TESTS_INFO);
        this.srcRootPath = null;
        if (opts.isSet(DSC_SRC_ROOT)) {
            this.srcRootPath = opts.getValue(DSC_SRC_ROOT);
        }
        if (opts.isSet(DSC_REPORT_TITLE_MAIN)) {
            this.mainReportTitle = opts.getValue(DSC_REPORT_TITLE_MAIN);
        }
        if (opts.isSet(DSC_REPORT_TITLE_OVERVIEW)) {
            this.overviewListTitle = opts.getValue(DSC_REPORT_TITLE_OVERVIEW);
        }
        if (opts.isSet(DSC_REPORT_TITLE_ENTITIES)) {
            this.entitiesTitle = opts.getValue(DSC_REPORT_TITLE_ENTITIES);
        }
        if ((reportGenerators = opts.getSPIs(ReportGeneratorSPI.class)) != null) {
            this.reportGeneratorSPIs = reportGenerators.toArray(new ReportGeneratorSPI[reportGenerators.size()]);
        }
        if ((dataProcessors = opts.getSPIs(DataProcessorSPI.class)) != null) {
            this.dataProcessorSPIs = dataProcessors.toArray(new DataProcessorSPI[dataProcessors.size()]);
        }
        this.classesPath = opts.getValue(DSC_JAVAP);
        return 0;
    }

    @Override
    protected int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        String[] srcs = opts.getTail();
        if (srcs == null) {
            throw new JCovTool.EnvHandlingException("no input files specified");
        }
        this.filenames = srcs;
        Utils.checkFileNotNull(this.filenames[0], "JCov datafile", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_CANREAD, Utils.CheckOptions.FILE_ISFILE);
        return this.handleEnv_(opts);
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(RepGen.class.getName());
        DSC_FMT = new OptionDescr("format", new String[]{"fmt"}, "Report generation output.", 1, "Specifies the format of the report.\nUse \"text\" for generate text report and \"html\" for generate HTML report\nText report in one file which contains method/block/branch coverage information.\nHTML report contains coverage information with marked-up sources.\n\nCustom reports can be specified with ReportGeneratorSPI interface.", "html");
        DSC_OUTPUT = new OptionDescr("repgen.output", new String[]{"output", "o"}, "", 1, "Output directory for generating text and HTML reports.", "report");
        DSC_TEST_LIST = new OptionDescr("tests", "Test list", 1, "Specify the path to the file containing test list. File should contain a list of tests\nwith one name per line.");
        DSC_FILTER_PLUGIN = new OptionDescr("filter", "", 1, "Custom filtering plugin class");
        DSC_ANC_FILTER_PLUGINS = new OptionDescr("ancfilter", new String[]{"ancf"}, "Custom anc filtering plugin classes", 2, "");
        DSC_ANC_DEFAULT_FILTERS = new OptionDescr("ancdeffilters", new String[]{"ancdf"}, "Default ANC filter name to use in report", 2, "");
        DSC_SRC_ROOT = new OptionDescr("sourcepath", new String[]{"source", "src"}, "The source files.", 1, "");
        DSC_VERBOSE = new OptionDescr("verbose", "Verbosity.", "Enable verbose mode.");
        DSC_NO_ABSTRACT = new OptionDescr("noabstract", "Additional filtering", "Do not count abstract methods");
        DSC_SYNTHETIC_ON = new OptionDescr("syntheticon", "Additional filtering", "Count coverage for synthetic methods");
        DSC_PUBLIC_API = new OptionDescr("publicapi", "", "Count only public and protected members");
        DSC_ANONYM = new OptionDescr("anonym", "", "include methods from anonymous classes into the report");
        DSC_JAVAP = new OptionDescr("javap", new String[]{"javap"}, "Path to the class files of the product to use javap", 1, "");
        DSC_TESTS_INFO = new OptionDescr("testsinfo", "Additional information about for specified tests' list", "Show covererage for all tests in test list");
        DSC_REPORT_TITLE_MAIN = new OptionDescr("mainReportTitle", new String[]{"mainReportTitle", "mrtitle"}, "The main report title", 1, "");
        DSC_REPORT_TITLE_OVERVIEW = new OptionDescr("overviewReportTitle", new String[]{"overviewReportTitle", "ortitle"}, "The overview list report title", 1, "");
        DSC_REPORT_TITLE_ENTITIES = new OptionDescr("entitiesReportTitle", new String[]{"entitiesReportTitle", "ertitle"}, "Entities report title (for modules, packages, subpackages)", 1, "");
    }

    public static class ANC_FILTER
    implements MemberFilter {
        @Override
        public boolean accept(DataClass clz) {
            return true;
        }

        @Override
        public boolean accept(DataClass clz, DataMethod m) {
            boolean ancMethod = (m.getAccess() & 0x1000) != 0;
            ancMethod = ancMethod || clz.getSuperName().equals("java/lang/Enum") && (m.getName().equals("valueOf") || m.getName().equals("values"));
            return !ancMethod || m.getName().startsWith("lambda$");
        }

        @Override
        public boolean accept(DataClass clz, DataField f) {
            return true;
        }
    }
}

