/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tdk.jcov.DiffCoverage;
import com.sun.tdk.jcov.RepGen;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.processing.DataProcessorSPI;
import com.sun.tdk.jcov.processing.DefaultDataProcessorSPI;
import com.sun.tdk.jcov.processing.StubSpi;
import com.sun.tdk.jcov.report.AncFilter;
import com.sun.tdk.jcov.report.ProductCoverage;
import com.sun.tdk.jcov.report.ReportGenerator;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.tools.SPIDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class IssueCoverage
extends JCovCMDTool {
    static final String DATA_PROCESSOR_SPI = "dataprocessor.spi";
    private String hg_path = "hg";
    private String hg_repo_dir = "jdk";
    private String output = "report";
    private String hg_comment = "";
    private DataProcessorSPI[] dataProcessorSPIs;
    private static final Logger logger;
    private String resultFile;
    private String replaceDiff = "";
    private HashMap<String, DiffCoverage.SourceLine[]> sources;
    static OptionDescr DSC_HG_PATH;
    static OptionDescr DSC_REPLACE_DIFF;
    static OptionDescr DSC_ISSUE_TO_FIND;
    static OptionDescr DSC_REPO_DIR;
    static OptionDescr DSC_OUTPUT;

    @Override
    protected int run() throws Exception {
        String logline;
        String[] command = new String[]{this.hg_path, "log", "-k", this.hg_comment};
        ProcessBuilder pb = new ProcessBuilder(command).directory(new File(this.hg_repo_dir));
        Process proc = pb.start();
        InputStream inputStream = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        ArrayList<Integer> changesets = new ArrayList<Integer>();
        while ((logline = br.readLine()) != null) {
            if (!logline.contains("changeset:")) continue;
            try {
                changesets.add(Integer.parseInt(logline.split(":")[1].trim()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (changesets.size() == 0) {
            logger.log(Level.SEVERE, "No changes found in the repository for " + this.hg_comment);
            return 2;
        }
        String[] change_command = new String[changesets.size() + 2];
        change_command[0] = this.hg_path;
        change_command[1] = "diff";
        for (int i = 0; i < changesets.size(); ++i) {
            change_command[i + 2] = "-c " + changesets.get(i);
        }
        ProcessBuilder pb1 = new ProcessBuilder(change_command).directory(new File(this.hg_repo_dir));
        Process proc1 = pb1.start();
        InputStream patchInputStream = proc1.getInputStream();
        try {
            DataProcessorSPI[] sourceName;
            BufferedReader in = new BufferedReader(new InputStreamReader(patchInputStream, "UTF-8"));
            DiffCoverage.HGDiffHandler handler = new DiffCoverage.HGDiffHandler(in);
            this.sources = new HashMap();
            while ((sourceName = handler.getNextSource()) != null) {
                DiffCoverage.SourceLine line;
                LinkedList<DiffCoverage.SourceLine> lines = new LinkedList<DiffCoverage.SourceLine>();
                while ((line = handler.getNextSourceLine()) != null) {
                    lines.add(line);
                }
                if (lines.size() > 0) {
                    logger.log(Level.INFO, "File {0} has {1} new lines", new Object[]{sourceName, lines.size()});
                    this.sources.put((String)sourceName, lines.toArray(new DiffCoverage.SourceLine[lines.size()]));
                    continue;
                }
                logger.log(Level.INFO, "File {0} doesn't have new lines", (Object)sourceName);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error while parsing diff", ex);
            return 2;
        }
        final HashMap<String, ArrayList<MethodWithParams>> changed = new HashMap<String, ArrayList<MethodWithParams>>();
        this.processChangedClasses(changesets, changed);
        DataRoot data = Reader.readXML(this.resultFile, false, new MemberFilter(){

            @Override
            public boolean accept(DataClass clz) {
                String className = IssueCoverage.this.replaceDiff != null && IssueCoverage.this.replaceDiff.contains("#module") ? IssueCoverage.this.replaceDiff.replaceAll("\\#module", clz.getModuleName()) + clz.getFullname().substring(0, clz.getFullname().lastIndexOf(47) + 1) + clz.getSource() : IssueCoverage.this.replaceDiff + clz.getFullname().substring(0, clz.getFullname().lastIndexOf(47) + 1) + clz.getSource();
                return changed.get(className) != null;
            }

            @Override
            public boolean accept(DataClass clz, DataMethod m) {
                return true;
            }

            @Override
            public boolean accept(DataClass clz, DataField f) {
                return true;
            }
        });
        if (this.dataProcessorSPIs != null) {
            for (DataProcessorSPI spi : this.dataProcessorSPIs) {
                data = spi.getDataProcessor().process(data);
            }
        }
        AncFilter notChanged = new AncFilter(){

            @Override
            public boolean accept(DataClass clz) {
                return false;
            }

            @Override
            public boolean accept(DataClass clz, DataMethod m) {
                String className = IssueCoverage.this.replaceDiff != null && IssueCoverage.this.replaceDiff.contains("#module") ? IssueCoverage.this.replaceDiff.replaceAll("\\#module", clz.getModuleName()) + clz.getFullname().substring(0, clz.getFullname().lastIndexOf(47) + 1) + clz.getSource() : IssueCoverage.this.replaceDiff + clz.getFullname().substring(0, clz.getFullname().lastIndexOf(47) + 1) + clz.getSource();
                if (changed.get(className) != null) {
                    for (MethodWithParams method : (ArrayList)changed.get(className)) {
                        if (!m.getName().equals(method.getMethodName()) && (!m.getName().contains("$") || !m.getName().endsWith(method.getMethodName())) || method.getMethodParams().size() != 0 && (m.getFormattedSignature().split(",").length != method.getMethodParams().size() || !m.getFormattedSignature().matches(".*" + method.getParamsRegex()))) continue;
                        method.setFound(true);
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean accept(DataMethod m, DataBlock b) {
                return false;
            }

            @Override
            public String getAncReason() {
                return "No changes";
            }
        };
        RepGen rr = new RepGen();
        ReportGenerator rg = rr.getDefaultReportGenerator();
        try {
            ReportGenerator.Options options = new ReportGenerator.Options(new File(this.hg_repo_dir + "/" + this.replaceDiff).getAbsolutePath(), null, null, false, false);
            ProductCoverage coverage = new ProductCoverage(data, options.getSrcRootPaths(), options.getJavapClasses(), false, false, false, new AncFilter[]{notChanged});
            for (String classFile : changed.keySet()) {
                for (MethodWithParams method : changed.get(classFile)) {
                    if (method.isFound()) continue;
                    logger.log(Level.WARNING, "Could not find changed method {0} from classfile {1}", new String[]{method.toString(), classFile});
                }
            }
            rg.init(this.output);
            rg.generateReport(coverage, options);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in report generation:", e);
        }
        return 0;
    }

    private void processChangedClasses(ArrayList<Integer> changesets, HashMap<String, ArrayList<MethodWithParams>> changed) {
        try {
            String classline;
            ArrayList<String> files = new ArrayList<String>();
            String[] command = new String[]{this.hg_path, "log", "-k", this.hg_comment, "--stat"};
            ProcessBuilder pb = new ProcessBuilder(command).directory(new File(this.hg_repo_dir));
            Process proc = pb.start();
            InputStream inputStream = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((classline = br.readLine()) != null) {
                if (!classline.contains("|") || !classline.contains("+") && !classline.contains("-")) continue;
                try {
                    files.add(classline.split(" ")[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.parseClassFiles(files, changesets.get(0), changed);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in parsing changed files:", e);
        }
    }

    private void parseClassFiles(ArrayList<String> files, int changeset, HashMap<String, ArrayList<MethodWithParams>> changed) {
        try {
            for (String file : files) {
                String[] command = new String[]{this.hg_path, "cat", file, "-r", String.valueOf(changeset)};
                ProcessBuilder pb = new ProcessBuilder(command).directory(new File(this.hg_repo_dir));
                Process proc = pb.start();
                InputStream inputStream = proc.getInputStream();
                Path destination = Paths.get(new File(this.hg_repo_dir).getAbsolutePath() + File.pathSeparator + "temp" + File.pathSeparator + ".java", new String[0]);
                Files.copy(inputStream, destination, new CopyOption[0]);
                DiffCoverage.SourceLine[] lines = this.sources.get(file);
                this.parseClassFile(destination.toFile(), lines, file, changed);
                destination.toFile().delete();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in parsing changed files:", e);
        }
    }

    private void parseClassFile(File c, DiffCoverage.SourceLine[] lines, String classFile, HashMap<String, ArrayList<MethodWithParams>> changed) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticsCollector, null, null);
        Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjects(c);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticsCollector, null, null, fileObjects);
        JavacTask javacTask = (JavacTask)task;
        SourcePositions sourcePositions = Trees.instance(javacTask).getSourcePositions();
        Iterable<? extends CompilationUnitTree> parseResult = null;
        try {
            parseResult = javacTask.parse();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error in parsing source file:", e);
        }
        if (parseResult != null) {
            for (CompilationUnitTree compilationUnitTree : parseResult) {
                compilationUnitTree.accept(new MethodParser(compilationUnitTree, sourcePositions, lines, classFile, changed), null);
            }
        }
    }

    @Override
    protected EnvHandler defineHandler() {
        EnvHandler envHandler = new EnvHandler(new OptionDescr[]{DSC_REPLACE_DIFF, DSC_ISSUE_TO_FIND, DSC_REPO_DIR, DSC_OUTPUT, DSC_HG_PATH}, (JCovTool)this);
        SPIDescr spiDescr = new SPIDescr(DATA_PROCESSOR_SPI, DataProcessorSPI.class);
        spiDescr.addPreset("none", new StubSpi());
        spiDescr.setDefaultSPI(new DefaultDataProcessorSPI());
        envHandler.registerSPI(spiDescr);
        return envHandler;
    }

    @Override
    protected int handleEnv(EnvHandler envHandler) throws JCovTool.EnvHandlingException {
        String[] tail = envHandler.getTail();
        if (tail == null) {
            throw new JCovTool.EnvHandlingException("No input files. Please specify JCov data file and diff (mercurial) file.");
        }
        ArrayList<DataProcessorSPI> dataProcessors = envHandler.getSPIs(DataProcessorSPI.class);
        if (dataProcessors != null) {
            this.dataProcessorSPIs = dataProcessors.toArray(new DataProcessorSPI[dataProcessors.size()]);
        }
        this.replaceDiff = envHandler.getValue(DSC_REPLACE_DIFF);
        this.hg_path = envHandler.getValue(DSC_HG_PATH);
        this.hg_comment = envHandler.getValue(DSC_ISSUE_TO_FIND);
        this.hg_repo_dir = envHandler.getValue(DSC_REPO_DIR);
        this.output = envHandler.getValue(DSC_OUTPUT);
        this.resultFile = tail[0];
        Utils.checkFileNotNull(tail[0], "JCov datafile", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_CANREAD);
        return 0;
    }

    @Override
    protected String getDescr() {
        return null;
    }

    @Override
    protected String usageString() {
        return null;
    }

    @Override
    protected String exampleString() {
        return null;
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(IssueCoverage.class.getName());
        DSC_HG_PATH = new OptionDescr("hgPath", new String[]{"hgPath", "hg"}, "", 1, "Path to the hg", "hg");
        DSC_REPLACE_DIFF = new OptionDescr("replaceDiff", "Manage replacing", 1, "Set replacement pattern for diff filenames (e.g. to cut out \"src/classes\" you can specify -replaceDiff src/classes:)");
        DSC_ISSUE_TO_FIND = new OptionDescr("issueToFind", new String[]{"issueToFind", "if"}, "", 1, "Set issue identifier to find in repository history");
        DSC_REPO_DIR = new OptionDescr("localRepo", new String[]{"localRepo", "lr"}, "", 1, "Path to the local repository");
        DSC_OUTPUT = new OptionDescr("output", new String[]{"output", "o"}, "", 1, "Output directory for generating HTML report.", "report");
    }

    class MethodWithParams {
        private String methodName;
        private List<String> methodParams;
        private boolean found = false;

        MethodWithParams(String methodName, List<String> methodParams) {
            this.methodName = methodName;
            this.methodParams = methodParams;
        }

        public List<String> getMethodParams() {
            return this.methodParams;
        }

        public void setMethodParams(List<String> methodParams) {
            this.methodParams = methodParams;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getParamsRegex() {
            if (this.methodParams.size() == 0) {
                return "\\(\\)";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\\(");
            for (int i = 0; i < this.methodParams.size(); ++i) {
                String param = this.methodParams.get(i);
                if (param.equals("K") || param.equals("V")) {
                    param = "Object";
                }
                if (param.contains("<")) {
                    param = param.substring(0, param.indexOf("<"));
                }
                param = Pattern.quote(param);
                if (i < this.methodParams.size() - 1) {
                    sb.append(".*").append(param).append(",");
                    continue;
                }
                sb.append(".*").append(param).append("\\)");
            }
            return sb.toString();
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.methodName).append("( ");
            for (String param : this.methodParams) {
                result.append(param).append(" ");
            }
            result.append(")");
            return result.toString();
        }
    }

    private class MethodParser
    extends TreeScanner<Void, Void> {
        private final CompilationUnitTree compilationUnitTree;
        private final SourcePositions sourcePositions;
        private final LineMap lineMap;
        private final DiffCoverage.SourceLine[] lines;
        private HashMap<String, ArrayList<MethodWithParams>> changed;
        private String classFile;
        private List<ClassTree> classes;

        private MethodParser(CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, DiffCoverage.SourceLine[] lines, String classFile, HashMap<String, ArrayList<MethodWithParams>> changed) {
            this.compilationUnitTree = compilationUnitTree;
            this.sourcePositions = sourcePositions;
            this.lineMap = compilationUnitTree.getLineMap();
            this.lines = lines;
            this.changed = changed;
            this.classFile = classFile;
            this.classes = new ArrayList<ClassTree>();
        }

        @Override
        public Void visitClass(ClassTree paramClassTree, Void paramP) {
            this.classes.add(paramClassTree);
            return (Void)super.visitClass(paramClassTree, paramP);
        }

        private String findClassName(MethodTree method) {
            String simpleName = "";
            String className = "";
            HashMap<String, Integer> annonym = new HashMap<String, Integer>();
            for (ClassTree classTree : this.classes) {
                simpleName = classTree.getSimpleName().toString();
                if (simpleName.isEmpty()) {
                    if (annonym.get(className) == null) {
                        annonym.put(className, 1);
                    } else {
                        annonym.put(className, (Integer)annonym.get(className) + 1);
                    }
                } else {
                    className = String.valueOf(simpleName);
                }
                for (Tree tree : classTree.getMembers()) {
                    if (!method.equals(tree)) continue;
                    if (simpleName.isEmpty()) {
                        simpleName = className + "$" + annonym.get(className);
                    }
                    return simpleName;
                }
            }
            return simpleName;
        }

        @Override
        public Void visitMethod(MethodTree arg0, Void arg1) {
            long startPosition = this.sourcePositions.getStartPosition(this.compilationUnitTree, arg0);
            long startLine = this.lineMap.getLineNumber(startPosition);
            long endPosition = this.sourcePositions.getEndPosition(this.compilationUnitTree, arg0);
            long endLine = this.lineMap.getLineNumber(endPosition);
            if (this.lines != null) {
                for (DiffCoverage.SourceLine line : this.lines) {
                    String simpleClassName;
                    if ((long)line.line < startLine || (long)line.line > endLine) continue;
                    if (this.changed.get(this.classFile) == null) {
                        this.changed.put(this.classFile, new ArrayList());
                    }
                    String methodName = this.classFile.endsWith((simpleClassName = this.findClassName(arg0)) + ".java") ? arg0.getName().toString() : "$" + simpleClassName + "." + arg0.getName();
                    ArrayList<String> params = new ArrayList<String>();
                    for (VariableTree variableTree : arg0.getParameters()) {
                        params.add(variableTree.getType().toString());
                    }
                    this.changed.get(this.classFile).add(new MethodWithParams(methodName, params));
                    return (Void)super.visitMethod(arg0, arg1);
                }
            }
            return (Void)super.visitMethod(arg0, arg1);
        }
    }
}

