/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PathClassLoader
extends ClassLoader {
    private File[] path;
    private Map<String, Class<?>> classes = new Hashtable();
    private Map<File, ZipFile> zips = new Hashtable<File, ZipFile>();

    public PathClassLoader(String pathString) {
        this.path = this.split(pathString);
    }

    public PathClassLoader(File baseDir, String pathString) {
        this.path = this.split(pathString);
        for (int i = 0; i < this.path.length; ++i) {
            File f = this.path[i];
            if (f.isAbsolute()) continue;
            this.path[i] = new File(baseDir, f.getPath());
        }
    }

    public PathClassLoader(File[] path) {
        this.path = path;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.classes.get(name);
        if (cl == null) {
            try {
                cl = this.findSystemClass(name);
            }
            catch (ClassNotFoundException e) {
                cl = this.locateClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    private synchronized Class<?> locateClass(String name) throws ClassNotFoundException {
        Class<?> c = this.classes.get(name);
        if (c != null) {
            return c;
        }
        for (int i = 0; i < this.path.length; ++i) {
            c = this.path[i].isDirectory() ? this.locateClassInDir(name, this.path[i]) : this.locateClassInJar(name, this.path[i]);
            if (c == null) continue;
            this.classes.put(name, c);
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> locateClassInDir(String name, File dir) throws ClassNotFoundException {
        String cname = name.replace('.', '/') + ".class";
        try {
            File file = new File(dir, cname);
            return this.readClass(name, new FileInputStream(file), (int)file.length());
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class<?> locateClassInJar(String name, File jarFile) throws ClassNotFoundException {
        String cname = name.replace('.', '/') + ".class";
        try {
            ZipEntry ze;
            ZipFile z = this.zips.get(jarFile);
            if (z == null) {
                z = new ZipFile(jarFile);
                this.zips.put(jarFile, z);
            }
            if ((ze = z.getEntry(cname)) == null) {
                return null;
            }
            return this.readClass(name, z.getInputStream(ze), (int)ze.getSize());
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> readClass(String name, InputStream in, int size) throws IOException {
        byte[] data = new byte[size];
        try {
            for (int total = 0; total < size; total += in.read(data, total, size - total)) {
            }
        }
        finally {
            in.close();
        }
        return this.defineClass(name, data, 0, data.length);
    }

    private File[] split(String s) {
        char pathCh = File.pathSeparatorChar;
        Vector<File> v = new Vector<File>();
        int start = 0;
        int i = s.indexOf(pathCh);
        while (i != -1) {
            this.add(s.substring(start, i), v);
            start = i + 1;
            i = s.indexOf(pathCh, start);
        }
        if (start != s.length()) {
            this.add(s.substring(start), v);
        }
        Object[] path = new File[v.size()];
        v.copyInto(path);
        return path;
    }

    private void add(String s, Vector<File> v) {
        if (s.length() != 0) {
            v.addElement(new File(s));
        }
    }
}

